/*
 * Decompiled with CFR 0.152.
 */
package oracle.jldif.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final byte[] charset;
    private static byte[] binaryCodes;

    public static String encode(String inStr) {
        String outStr = null;
        if (inStr != null) {
            outStr = new String(Base64.encode(inStr.getBytes()));
        }
        return outStr;
    }

    public static String utfEncode(String inStr) {
        String outStr = null;
        try {
            if (inStr != null) {
                outStr = new String(Base64.encode(inStr.getBytes("UTF-8")), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee.getMessage());
        }
        return outStr;
    }

    public static String decode(String inStr) {
        String outStr = null;
        if (inStr != null) {
            outStr = new String(Base64.decode(inStr.getBytes()));
        }
        return outStr;
    }

    public static String utfDecode(String inStr) {
        String outStr = null;
        try {
            if (inStr != null) {
                outStr = new String(Base64.decode(inStr.getBytes("UTF-8")), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee.getMessage());
        }
        return outStr;
    }

    public static byte[] encode(byte[] inBytes) {
        byte[] outBytes = new byte[(inBytes.length + 2) / 3 * 4];
        int ix = 0;
        int index = 0;
        while (ix < inBytes.length) {
            boolean byte2Present = false;
            boolean byte3Present = false;
            int val = Base64.unsignedByteToInt(inBytes[ix]) << 8;
            if (ix + 1 < inBytes.length) {
                val |= Base64.unsignedByteToInt(inBytes[ix + 1]);
                byte2Present = true;
            }
            val <<= 8;
            if (ix + 2 < inBytes.length) {
                val |= Base64.unsignedByteToInt(inBytes[ix + 2]);
                byte3Present = true;
            }
            outBytes[index + 3] = (byte)(byte3Present ? charset[val & 0x3F] : 61);
            outBytes[index + 2] = (byte)(byte2Present ? charset[(val >>= 6) & 0x3F] : 61);
            outBytes[index + 1] = charset[(val >>= 6) & 0x3F];
            outBytes[index + 0] = charset[(val >>= 6) & 0x3F];
            ix += 3;
            index += 4;
        }
        return outBytes;
    }

    public static byte[] decode(byte[] inBytes) {
        int len = inBytes.length;
        for (int ix = 0; ix < inBytes.length; ++ix) {
            if (binaryCodes[inBytes[ix]] >= 0) continue;
            --len;
        }
        int tmpBytesLen = (len + 3) / 4 * 3;
        byte[] tmpBytes = new byte[tmpBytesLen];
        int tempBuf = 0;
        int prevBits = 0;
        int jx = 0;
        for (int ix = 0; ix < inBytes.length; ++ix) {
            byte val = binaryCodes[inBytes[ix]];
            if (val < 0) continue;
            tempBuf = tempBuf << 6 | val;
            if (prevBits >= 2) {
                tmpBytes[jx++] = (byte)(tempBuf >> (prevBits -= 2) & 0xFF);
                continue;
            }
            prevBits += 6;
        }
        byte[] outBytes = new byte[jx];
        System.arraycopy(tmpBytes, 0, outBytes, 0, jx);
        return outBytes;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static void main(String[] args) {
        boolean decode = false;
        if (args.length == 0) {
            System.out.println("usage:  java Base64 [-d] String");
            System.exit(0);
        }
        if ("-d".equalsIgnoreCase(args[0])) {
            decode = true;
        }
        if (decode && args.length == 1) {
            System.out.println("usage:  java Base64 [-d] String");
            System.exit(0);
        }
        if (decode) {
            String encoded = args[1];
            String decoded = null;
            if (encoded != null) {
                decoded = new String(Base64.decode(encoded.getBytes()));
            }
            System.out.println("Encoded String : " + encoded);
            System.out.println("Decoded String : " + decoded);
        } else {
            String orginal = args[0];
            String encoded = null;
            if (orginal != null) {
                encoded = new String(Base64.encode(orginal.getBytes()));
            }
            System.out.println("Orginal String : " + orginal);
            System.out.println("Encoded String : " + encoded);
        }
    }

    static {
        int i;
        charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
        binaryCodes = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64.binaryCodes[i] = -1;
        }
        Base64.binaryCodes[43] = 62;
        Base64.binaryCodes[47] = 63;
        for (i = 48; i <= 57; ++i) {
            Base64.binaryCodes[i] = (byte)(52 + i - 48);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.binaryCodes[i] = (byte)(26 + i - 97);
        }
        for (i = 65; i <= 90; ++i) {
            Base64.binaryCodes[i] = (byte)(i - 65);
        }
    }
}

