/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import oracle.jdeveloper.xml.dtd.grammar.Entity;
import oracle.jdevimpl.xml.dtd.parser.XMLCharReader;
import oracle.jdevimpl.xml.dtd.parser.XMLReader;

class XMLEntity
implements Entity {
    private String _mName;
    int flags;
    String url;
    String pubid;
    private char cdata;
    String ndata;
    boolean inStack;
    private String text;
    private XMLCharReader reader;
    static final int PARAMETER_ENTITY = 65536;
    static final int PARSED_ENTITY = 131072;

    public XMLEntity(String name) {
        this._mName = name;
    }

    public XMLEntity(String s, boolean flag) {
        this(s);
        this.text = "";
        this.inStack = false;
        if (flag) {
            this.setNodeFlag(65536);
        }
    }

    public XMLEntity(String s, boolean flag, int i) {
        this(s, flag);
        this.cdata = (char)i;
        this.text = String.valueOf(this.cdata);
    }

    public XMLEntity(String s, boolean flag, int i, boolean flag1) {
        this(s, flag);
        this.cdata = (char)i;
        this.text = String.valueOf(this.cdata);
        if (flag1) {
            this.setNodeFlag(131072);
        }
    }

    public XMLEntity(String s, boolean flag, String s1) {
        this(s, flag);
        this.text = s1;
    }

    public final String getName() {
        return this._mName;
    }

    void checkChildType(int i) {
        switch (i) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        System.err.println("XMLEntity : checkChildType - ERROR");
    }

    char getChar(int i) {
        if (this.text == null) {
            return this.cdata;
        }
        return this.text.charAt(i);
    }

    int getLength() {
        if (this.cdata > '\u0000') {
            return -1;
        }
        if (this.text == null) {
            return 0;
        }
        return this.text.length();
    }

    public String getValue() {
        return this.text;
    }

    public String getNotationName() {
        return this.ndata;
    }

    public String getPublicId() {
        return this.pubid;
    }

    XMLCharReader getReader(XMLReader xmlreader) throws IOException {
        if (this.text == null || this.text.length() == 0) {
            return null;
        }
        if (this.reader == null) {
            this.reader = new XMLCharReader(this.text, xmlreader.getSystemId(), xmlreader.getPublicId());
        } else {
            this.reader.reset();
        }
        this.reader.setPrevReader(xmlreader.input);
        return this.reader;
    }

    public String getSystemId() {
        return this.url;
    }

    boolean isExternalEntity() {
        return this.url != null;
    }

    boolean isParameterEntity() {
        return this.isNodeFlag(65536);
    }

    public void setValue(String s) {
        this.text = s;
    }

    void setNotationName(String s) {
        this.ndata = s;
    }

    void setURL(String s) {
        this.url = s;
    }

    public boolean isNodeFlag(int i) {
        return (this.flags & i) == i;
    }

    public void resetNodeFlag(int i) {
        this.flags &= ~i;
    }

    public void setNodeFlag(int i) {
        this.flags |= i;
    }
}

