/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.jdeveloper.xml.dtd.grammar.DtdLoader;
import oracle.jdevimpl.xml.dtd.parser.AbstractParser;
import oracle.jdevimpl.xml.dtd.parser.MarkupDefaultHandler;
import oracle.jdevimpl.xml.dtd.parser.ParserError;
import oracle.jdevimpl.xml.dtd.parser.XMLEntity;
import oracle.jdevimpl.xml.dtd.parser.XMLExternalReader;
import oracle.jdevimpl.xml.dtd.parser.XMLNotation;
import oracle.jdevimpl.xml.dtd.parser.XMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractDtdParser
extends AbstractParser {
    public static final String JDEV_DTD_METADATA_NS = "http://xmlns.oracle.com/bali/xml/metadata/jdev/dtd";
    public static final QualifiedName CONTENT_VALIDATOR = QualifiedName.getQualifiedName("http://xmlns.oracle.com/bali/xml/metadata/jdev/dtd", "contentValidator");
    protected int externalDtdLevel;
    protected DtdLoader dtdNamespaceLoader;
    private Map internalEntities;

    protected AbstractDtdParser() {
        MarkupDefaultHandler handler = new MarkupDefaultHandler();
        this.setEntityResolver(handler);
        this.setDeclHandler(handler);
        this.setDTDHandler(handler);
        this.setLexicalHandler(handler);
        this.setError(new ParserError());
        this.setLoader(new DtdLoader());
        this.setupExternalReader();
        this.externalDtdLevel = 0;
    }

    protected AbstractDtdParser(AbstractDtdParser abstractDtdParser) {
        this(abstractDtdParser, abstractDtdParser.dtdNamespaceLoader);
    }

    protected AbstractDtdParser(AbstractParser abstractParser, DtdLoader loader) {
        super(abstractParser);
        this.setLoader(loader);
        this.externalDtdLevel = 0;
    }

    public void setLoader(DtdLoader loader) {
        this.dtdNamespaceLoader = loader;
    }

    public void setupExternalReader() {
        if (this.getReader() == null) {
            this.setReader(new XMLReader(this, this.getError(), this.getEntityResolver()));
        }
        this.getReader().reset();
        XMLExternalReader extReader = this.getReader().getExternalReader();
        extReader.startInput = 0;
        this.setReader(extReader);
    }

    public boolean pushExternalDTD(String systemId, InputSource inputSource) throws SAXException, IOException {
        return AbstractDtdParser.pushExternalDTD((AbstractParser)this, systemId, inputSource);
    }

    public boolean pushExternalDTD(String systemId, String publicId) throws SAXException, IOException {
        return AbstractDtdParser.pushExternalDTD((AbstractParser)this, systemId, publicId);
    }

    protected String getCurrentNamespace() {
        return this.dtdNamespaceLoader.getNamespace();
    }

    protected XMLEntity findEntity(String name, boolean parameterEntity) {
        if (parameterEntity) {
            return this.getInternalEntity(name);
        }
        return this.getGeneralEntity(name);
    }

    protected XMLNotation findNotation(String name) {
        return (XMLNotation)this.dtdNamespaceLoader.findNotation(name);
    }

    public void parseDocument() throws SAXException, IOException {
        this.err.setLocator(this.reader);
        ++this.externalDtdLevel;
        this.parseMarkupDecl();
        if (!this.reader.isEOF()) {
            this.err.error0(192, 0);
        }
        --this.externalDtdLevel;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parseMarkupDecl() throws SAXException, IOException {
        this.reader.skipWhiteSpace();
        while (!this.reader.isEOF()) {
            block20: {
                block21: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            block22: {
                                                if (!this.reader.tryRead(cDECLSTART, 0, cDECLSTART.length)) break block21;
                                                if (!this.reader.tryRead(cELEMENT, 0, cELEMENT.length)) break block22;
                                                this.parseElementDecl();
                                                break block20;
                                            }
                                            if (!this.reader.tryRead(cATTLIST, 0, cATTLIST.length)) break block23;
                                            this.parseAttlistDecl();
                                            break block20;
                                        }
                                        if (!this.reader.tryRead(cENTITY, 0, cENTITY.length)) break block24;
                                        this.parseEntityDecl();
                                        break block20;
                                    }
                                    if (!this.reader.tryRead(cNOTATION, 0, cNOTATION.length)) break block25;
                                    this.parseNotationDecl();
                                    break block20;
                                }
                                if (!this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) break block26;
                                this.parseComment();
                                break block20;
                            }
                            if (!this.reader.tryRead(cCDATASTART, 2, cCDATASTART.length - 2)) break block27;
                            char[] ac = this.reader.scanCDATA(this.bounds);
                            if (this.bounds[1] != 0) {
                                String data = new String(ac, this.bounds[0], this.bounds[1]);
                                this.cntHandler.characters(ac, this.bounds[0], this.bounds[1]);
                            }
                            break block20;
                        }
                        if (this.externalDtdLevel <= 0 || !this.reader.tryRead(91)) break block28;
                        this.reader.skipWhiteSpace();
                        if (this.reader.tryRead(cINCLUDE, 0, cINCLUDE.length)) {
                            this.reader.skipWhiteSpace();
                            if (!this.reader.tryRead(91)) {
                                this.err.error0(114, 0);
                            }
                            this.parseMarkupDecl();
                            if (!this.reader.tryRead(cENTITYDATAEND, 1, cENTITYDATAEND.length - 1)) {
                                this.err.error0(115, 0);
                            }
                            break block20;
                        } else if (this.reader.tryRead(cIGNORE, 0, cIGNORE.length)) {
                            this.reader.skipIgnoreSection();
                            this.reader.skipWhiteSpace();
                            break block20;
                        } else {
                            this.err.error2(101, 0, "IGNORE", "INCLUDE");
                            this.reader.skipIgnoreSection();
                            this.reader.skipWhiteSpace();
                        }
                        break block20;
                    }
                    this.err.error0(192, 0);
                    return;
                }
                if (this.externalDtdLevel <= 0 || !this.reader.tryRead(91)) {
                    if (this.reader.tryRead(cPISTART, 0, cPISTART.length)) {
                        this.parsePI();
                    } else if (this.reader.tryRead(37)) {
                        XMLEntity xmlentity = this.parseEntity(true);
                        if (xmlentity == null) {
                            this.reader.skipWhiteSpace();
                            continue;
                        }
                        if (!this.reader.pushEntityRef(xmlentity)) {
                            this.reader.skipWhiteSpace();
                            continue;
                        }
                        if (xmlentity.isExternalEntity()) {
                            this.reader = this.reader.getExternalReader();
                            this.err.setLocator(this.reader);
                            ++this.externalDtdLevel;
                        }
                        this.parseMarkupDecl();
                        if (xmlentity.isExternalEntity()) {
                            --this.externalDtdLevel;
                            this.reader = this.reader.getInternalReader();
                            this.err.setLocator(this.reader);
                        } else {
                            this.reader.popXMLReader();
                        }
                    } else {
                        if (this.reader.tryRead(93)) {
                            return;
                        }
                        this.reader.skipWhiteSpace();
                        if (this.reader.isEOF()) {
                            return;
                        }
                        this.err.error0(192, 0);
                        return;
                    }
                }
            }
            this.reader.skipWhiteSpace();
        }
    }

    abstract void parseElementDecl() throws SAXException, IOException;

    private XMLEntity _parseEntityDecl() throws SAXException, IOException {
        this.reader.requireWhiteSpace();
        boolean parameterEntity = this.reader.checkParEntity();
        String entityName = this.reader.scanQName();
        String entityNameDecl = parameterEntity ? "%" + entityName : entityName;
        XMLEntity xmlEntity = this.findEntity(entityName, parameterEntity);
        if (xmlEntity != null) {
            xmlEntity = new XMLEntity(entityName, parameterEntity);
            if (this.fixedDTD) {
                this.addEntity(xmlEntity, parameterEntity);
                if (this.externalDtdLevel > 0) {
                    xmlEntity.setNodeFlag(64);
                }
            }
        } else {
            xmlEntity = new XMLEntity(entityName, parameterEntity);
            this.addEntity(xmlEntity, parameterEntity);
            if (this.externalDtdLevel > 0) {
                xmlEntity.setNodeFlag(64);
            }
        }
        boolean external = false;
        this.reader.requireWhiteSpace();
        if (this.reader.tryRead(cPUBLIC, 0, cPUBLIC.length)) {
            external = true;
            this.reader.requireWhiteSpace();
            xmlEntity.pubid = this.reader.scanPubIdLiteral();
            xmlEntity.url = this.reader.skipWhiteSpace() ? this.reader.scanQuotedString() : "";
        } else if (this.reader.tryRead(cSYSTEM, 0, cSYSTEM.length)) {
            external = true;
            this.reader.requireWhiteSpace();
            xmlEntity.url = this.reader.scanQuotedString();
        }
        if (external) {
            if (!"".equals(xmlEntity.url)) {
                try {
                    URL url = new URL(this.getBaseURL(), xmlEntity.url);
                    xmlEntity.setURL(url.toString());
                }
                catch (MalformedURLException _ex) {
                    // empty catch block
                }
            }
            boolean hasWhiteSpace = this.reader.skipWhiteSpace();
            if (this.reader.tryRead(cNDATA, 0, cNDATA.length)) {
                if (!hasWhiteSpace) {
                    this.err.error0(190, 0);
                }
                if (parameterEntity) {
                    this.err.error0(117, 0);
                }
                this.reader.requireWhiteSpace();
                xmlEntity.ndata = this.reader.scanQName();
                if (!parameterEntity && xmlEntity.ndata == null) {
                    this.err.error0(118, 0);
                }
                this.dtdHandler.unparsedEntityDecl(entityName, xmlEntity.pubid, xmlEntity.url, xmlEntity.ndata);
            }
            this.declHandler.externalEntityDecl(entityNameDecl, xmlEntity.pubid, xmlEntity.url);
        } else {
            String entityValue = this.parseEntityValue();
            xmlEntity.setValue(entityValue);
            xmlEntity.setNodeFlag(131072);
            this.setEntityValue(xmlEntity, parameterEntity);
            this.declHandler.internalEntityDecl(entityNameDecl, entityValue);
        }
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
            this.parseComment(true);
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
        return xmlEntity;
    }

    /*
     * Unable to fully structure code
     */
    private String parseEntityValue() throws SAXException, IOException {
        entityValue = "";
        i = this.reader.read();
        if (i != 34 && i != 39) {
            i = this.processParseEntityValue(i);
        }
        do lbl-1000:
        // 3 sources

        {
            entityValue = entityValue + this.reader.scanEntityString(i);
            if (!this.reader.tryRead(i)) {
                if (!this.reader.tryRead(37)) continue;
            } else {
                return entityValue;
            }
            entityValue = entityValue + this.parseEntityRefValue();
            if (!this.reader.isEOF()) ** GOTO lbl-1000
        } while (!this.reader.isEOF());
        this.err.error0(193, 0);
        return entityValue;
    }

    protected abstract int processParseEntityValue(int var1) throws SAXException, IOException;

    /*
     * Unable to fully structure code
     */
    private String parseEntityRefValue() throws SAXException, IOException {
        entityValue = "";
        xmlEntity = this.parseEntity(true);
        if (xmlEntity == null) {
            return "";
        }
        if (xmlEntity.getLength() == -1) {
            return xmlEntity.getValue();
        }
        if (!this.reader.pushEntityRef(xmlEntity)) {
            return "";
        }
        do lbl-1000:
        // 3 sources

        {
            entityValue = entityValue + this.reader.scanEntityString(65535);
            if (!this.reader.tryRead(37)) continue;
            entityValue = entityValue + this.parseEntityRefValue();
            if (!this.reader.isEOF()) ** GOTO lbl-1000
        } while (!this.reader.isEOF());
        this.reader.popXMLReader();
        return entityValue;
    }

    protected XMLEntity parseEntityDecl() throws SAXException, IOException {
        XMLEntity xmlEntity = this._parseEntityDecl();
        if (xmlEntity.ndata != null) {
            XMLNotation xMLNotation = this.findNotation(xmlEntity.ndata);
        }
        return xmlEntity;
    }

    protected void parseNotationDecl() throws SAXException, IOException {
        this.reader.requireWhiteSpace();
        String s = this.reader.scanQName();
        XMLNotation xmlNotation = this.findNotation(s);
        if (xmlNotation != null) {
            this.err.error1(136, 1, s);
            xmlNotation = new XMLNotation(s);
        } else {
            xmlNotation = new XMLNotation(s);
            this.addNotation(xmlNotation);
            if (this.externalDtdLevel > 0) {
                xmlNotation.setNodeFlag(64);
            }
        }
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(cPUBLIC, 0, cPUBLIC.length)) {
            this.reader.requireWhiteSpace();
            xmlNotation.setPublicId(this.reader.scanPubIdLiteral());
            boolean hasWhiteSpace = this.reader.skipWhiteSpace();
            if (!this.reader.tryRead(62)) {
                if (!hasWhiteSpace) {
                    this.err.error0(190, 0);
                }
                xmlNotation.setSystemId(this.reader.scanQuotedString());
                this.reader.skipWhiteSpace();
                if (!this.reader.tryRead(62)) {
                    this.err.error1(100, 0, ">");
                }
            }
        } else if (this.reader.tryRead(cSYSTEM, 0, cSYSTEM.length)) {
            this.reader.requireWhiteSpace();
            xmlNotation.setSystemId(this.reader.scanQuotedString());
            this.reader.skipWhiteSpace();
            if (!this.reader.tryRead(62)) {
                this.err.error1(100, 0, ">");
            }
        } else {
            this.err.error2(101, 0, "PUBLIC", "SYSTEM");
            if (this.reader.tryRead(62)) {
                this.err.error1(100, 0, ">");
            }
            return;
        }
        try {
            URL url = this.baseURL != null ? new URL(this.baseURL, xmlNotation.getSystemId()) : new URL(new URL(this.reader.getSystemId()), xmlNotation.getSystemId());
            xmlNotation.setSystemId(url.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.dtdHandler.notationDecl(s, xmlNotation.getPublicId(), xmlNotation.getSystemId());
    }

    protected abstract void parseAttlistDecl() throws SAXException, IOException;

    protected void init() throws SAXException, IOException {
        super.init();
        this.internalEntities = null;
    }

    protected void reset() throws SAXException, IOException {
        super.reset();
        this.internalEntities = null;
    }

    protected void parseComment(boolean dashdash) throws SAXException, IOException {
        char[] comment = this.reader.scanComment(this.bounds, dashdash);
        if (this.bounds[1] != 0) {
            this.lexHandler.comment(comment, this.bounds[0], this.bounds[1]);
        }
    }

    protected String getParsedComment(boolean dashdash) throws SAXException, IOException {
        char[] comment = this.reader.scanComment(this.bounds, dashdash);
        if (this.bounds[1] != 0) {
            return new String(comment, this.bounds[0], this.bounds[1]);
        }
        return "";
    }

    private void addNotation(XMLNotation notation) {
        this.dtdNamespaceLoader.addNotation(notation.getName(), notation);
    }

    private void addEntity(XMLEntity entity, boolean parameterEntity) {
        if (parameterEntity) {
            this.addInternalEntity(entity);
        } else {
            this.dtdNamespaceLoader.addEntity(entity.getName(), entity);
        }
    }

    private void setEntityValue(XMLEntity entity, boolean parameterEntity) {
        if (!parameterEntity) {
            this.dtdNamespaceLoader.addEntityValue(entity.getValue(), entity);
        }
    }

    private void addInternalEntity(XMLEntity entity) {
        if (this.internalEntities == null) {
            this.internalEntities = new HashMap();
        }
        this.internalEntities.put(entity.getName(), entity);
    }

    private XMLEntity getInternalEntity(String entityName) {
        if (this.internalEntities == null) {
            return null;
        }
        return (XMLEntity)this.internalEntities.get(entityName);
    }

    private XMLEntity getGeneralEntity(String entityName) {
        return (XMLEntity)this.dtdNamespaceLoader.findEntity(entityName);
    }

    static boolean pushExternalDTD(AbstractParser parser, String systemId, String publicId) throws SAXException, IOException {
        InputSource inputSource = parser.entResolver.resolveEntity(publicId, systemId);
        return AbstractDtdParser.pushExternalDTD(parser, systemId, inputSource);
    }

    static boolean pushExternalDTD(AbstractParser parser, String systemId, InputSource inputSource) throws SAXException, IOException {
        if (inputSource != null) {
            Reader dtdReader = inputSource.getCharacterStream();
            if (dtdReader != null) {
                parser.reader.pushXMLReader(dtdReader, inputSource.getSystemId(), inputSource.getPublicId());
            } else {
                InputStream dtdInputStream = inputSource.getByteStream();
                if (dtdInputStream != null) {
                    parser.reader.pushXMLReader(dtdInputStream, inputSource.getSystemId(), inputSource.getPublicId());
                } else {
                    systemId = inputSource.getSystemId();
                    if (systemId != null) {
                        try {
                            parser.reader.pushXMLReader(new URL(systemId), systemId, inputSource.getPublicId());
                        }
                        catch (MalformedURLException malformedUrlException) {
                            parser.err.setException(malformedUrlException);
                            parser.err.error1(112, 1, systemId);
                        }
                    } else {
                        parser.err.error1(113, 1, systemId);
                    }
                }
            }
        } else {
            parser.err.error1(112, 1, systemId);
            return false;
        }
        return true;
    }
}

