/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

abstract class DtdGrammarComponent
implements GrammarComponent {
    private static final String METADATA_NAMESPACE = "http://xmlns.oracle.com/bali/xml/metadata";
    private DtdAnnotation m_DtdAnnotation = new DtdAnnotation();
    private Map<String, String> m_ComponentMetadata = new HashMap<String, String>();
    private Node m_ApplicationAnnotation;

    DtdGrammarComponent() {
    }

    public Annotation getAnnotation() {
        if (this.m_DtdAnnotation == null) {
            this.m_DtdAnnotation = new DtdAnnotation();
        }
        return this.m_DtdAnnotation;
    }

    void addComponentMetadata(String metadataName, String metadataValue) {
        this.m_ComponentMetadata.put(metadataName, metadataValue);
    }

    abstract String getMetadataElementName();

    private Node getApplicationAnnotation() {
        if (this.m_ApplicationAnnotation == null) {
            this.m_ApplicationAnnotation = DomUtils.getScratchDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
            Element metadata = DomUtils.getScratchDocument().createElementNS(METADATA_NAMESPACE, this.getMetadataElementName());
            for (Map.Entry<String, String> entry : this.m_ComponentMetadata.entrySet()) {
                Text mdText = DomUtils.getScratchDocument().createTextNode(entry.getValue());
                Element mdElement = DomUtils.getScratchDocument().createElementNS(METADATA_NAMESPACE, entry.getKey());
                mdElement.appendChild(mdText);
                metadata.appendChild(mdElement);
            }
            this.m_ApplicationAnnotation.appendChild(metadata);
        }
        return this.m_ApplicationAnnotation;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.m_ApplicationAnnotation != null) {
            this.removeChildren(this.m_ApplicationAnnotation);
        }
    }

    private void removeChildren(Node node) {
        Node lastChild;
        while ((lastChild = node.getLastChild()) != null) {
            this.removeChildren(lastChild);
            node.removeChild(lastChild);
        }
        if (node instanceof XMLNode) {
            ((XMLNode)node).freeNode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DtdAnnotation
    implements Annotation {
        private DtdAnnotation() {
        }

        @Override
        public String getApplicationInformationSource() {
            return null;
        }

        @Override
        public Collection getUserInformation() {
            return null;
        }

        @Override
        public String getUserInformationSource() {
            return null;
        }

        @Override
        public Collection getAttributes() {
            return null;
        }

        @Override
        public Collection<Node> getApplicationInformation() {
            Node appAnnotation = DtdGrammarComponent.this.getApplicationAnnotation();
            if (appAnnotation != null) {
                return Collections.singleton(appAnnotation);
            }
            return null;
        }
    }
}

