/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd;

import java.io.IOException;
import java.net.URL;
import oracle.jdeveloper.xml.dtd.DtdRegistry;
import oracle.jdeveloper.xml.dtd.grammar.DtdGrammar;
import oracle.jdeveloper.xml.dtd.grammar.DtdLoader;
import oracle.jdeveloper.xml.dtd.grammar.DtdLoaderFactory;
import oracle.jdevimpl.xml.dtd.parser.AbstractDtdParser;
import oracle.jdevimpl.xml.dtd.parser.SgmlDtdParser;
import oracle.jdevimpl.xml.dtd.parser.XmlDtdParser;
import org.xml.sax.SAXException;

public class DtdLoadingUtils {
    private static DtdLoadingUtils instance;

    public static DtdLoadingUtils getInstance() {
        if (instance == null) {
            instance = new DtdLoadingUtils();
        }
        return instance;
    }

    private DtdLoadingUtils() {
    }

    public static DtdGrammar loadDtd(String namespaceURI, String publicID, String systemID, String rootElement, boolean xmlDtdFormat, boolean caseSensitive) {
        URL location = DtdRegistry.getLocalSystemIdLocation(systemID);
        return DtdLoadingUtils.loadDtd(namespaceURI, publicID, systemID, rootElement, xmlDtdFormat, caseSensitive, location);
    }

    public static DtdGrammar loadDtd(String namespaceURI, String publicID, String systemID, String rootElement, boolean xmlDtdFormat, boolean caseSensitive, URL location) {
        DtdGrammar grammar = null;
        DtdLoader loader = DtdLoaderFactory.getLoader(publicID);
        if (loader != null) {
            DtdLoadingUtils.parseDtd(namespaceURI, publicID, systemID, rootElement, loader, xmlDtdFormat, caseSensitive, location);
            grammar = loader.getGrammar();
        }
        return grammar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseDtd(String namespaceURI, String publicID, String systemID, String rootElement, DtdLoader loader, boolean xmlDtdFormat, boolean caseSensitive, URL location) {
        try {
            String name = rootElement == null ? namespaceURI : rootElement;
            loader.start(name, namespaceURI, rootElement, publicID, location, caseSensitive);
            AbstractDtdParser parser = DtdLoadingUtils.getParser(xmlDtdFormat);
            parser.setLoader(loader);
            String internalSystemID = location.toExternalForm();
            if (DtdLoadingUtils.pushReader(parser, namespaceURI, internalSystemID)) {
                parser.parseDocument();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            loader.finish();
        }
    }

    private static AbstractDtdParser getParser(boolean xmlDtdFormat) throws SAXException, IOException {
        AbstractDtdParser parser = xmlDtdFormat ? new XmlDtdParser() : new SgmlDtdParser();
        return parser;
    }

    private static boolean pushReader(AbstractDtdParser parser, String publicId, String systemId) throws IOException, SAXException {
        return parser.pushExternalDTD(systemId, publicId);
    }
}

