/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.util.PrefixMapParser;
import oracle.bali.xml.util.QualifiedNameParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameToStringUtils {
    public static Map<String, String> parsePrefixMappings(CharSequence input, int[] indexInOut) throws ParseException {
        return PrefixMapParser.parsePrefixMappings(input, indexInOut);
    }

    public static CharSequence writePrefixMappings(Map<String, String> prefixToNamespace) {
        if (prefixToNamespace.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        out.append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : prefixToNamespace.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.append('|');
            }
            out.append(entry.getKey());
            out.append(':');
            out.append(entry.getValue());
        }
        out.append(']');
        return out;
    }

    public static QualifiedName parseQualifiedName(Map<String, String> prefixToNamespace, CharSequence input, int[] indexInOut) throws ParseException {
        return QualifiedNameParser.__parseQualifiedNameString(prefixToNamespace, input, indexInOut);
    }

    public static CharSequence writeQualifiedName(Map<String, String> prefixToNamespaceExisting, Map<String, String> prefixToNamespaceNew, QualifiedName name) {
        StringBuilder out = new StringBuilder();
        NameToStringUtils._appendQualifiedName(prefixToNamespaceExisting, prefixToNamespaceNew, NameToStringUtils._buildReverseMap(prefixToNamespaceExisting), name, out);
        return out;
    }

    public static XmlKey parseXmlKey(Map<String, String> prefixToNamespace, CharSequence input, int[] indexInOut) throws ParseException {
        return QualifiedNameParser.parseXmlKey(prefixToNamespace, input, indexInOut);
    }

    public static XmlKey parseXmlKeyWithPrefixMappings(CharSequence input, int[] indexInOut) throws ParseException {
        return NameToStringUtils.parseXmlKeyWithPrefixMappings(null, input, indexInOut);
    }

    public static XmlKey parseXmlKeyWithPrefixMappings(Map<String, String> initialNamespaces, CharSequence input, int[] indexInOut) throws ParseException {
        Map<String, String> prefixToNamespace = NameToStringUtils.parsePrefixMappings(input, indexInOut);
        if (initialNamespaces != null && !initialNamespaces.isEmpty()) {
            if (prefixToNamespace.isEmpty()) {
                prefixToNamespace = initialNamespaces;
            } else {
                int mergeMaxSize = prefixToNamespace.size() + initialNamespaces.size();
                LinkedHashMap<String, String> merged = new LinkedHashMap<String, String>(mergeMaxSize);
                merged.putAll(initialNamespaces);
                merged.putAll(prefixToNamespace);
                prefixToNamespace = merged;
            }
        }
        return NameToStringUtils.parseXmlKey(prefixToNamespace, input, indexInOut);
    }

    public static CharSequence writeXmlKeyWithPrefixMappings(XmlKey key) {
        LinkedHashMap<String, String> prefixToNamespace = new LinkedHashMap<String, String>();
        CharSequence keyStr = NameToStringUtils.writeXmlKey(Collections.<String, String>emptyMap(), prefixToNamespace, key);
        if (prefixToNamespace.isEmpty()) {
            return keyStr;
        }
        CharSequence prefixMapStr = NameToStringUtils.writePrefixMappings(prefixToNamespace);
        StringBuilder sb = new StringBuilder(prefixMapStr.length() + keyStr.length());
        sb.append(prefixMapStr);
        sb.append(keyStr);
        return sb;
    }

    public static CharSequence writeXmlKey(Map<String, String> prefixToNamespaceExisting, Map<String, String> prefixToNamespaceNew, XmlKey key) {
        short type = key.getNodeType();
        if (type == 1 || type == 2) {
            QualifiedName attrName;
            StringBuilder out = new StringBuilder();
            Map<String, String> namespaceToPrefix = NameToStringUtils._buildReverseMap(prefixToNamespaceExisting);
            List path = key.getElementQNamePath();
            if (path != null && !path.isEmpty()) {
                for (QualifiedName name : path) {
                    if (out.length() > 0) {
                        out.append('/');
                    }
                    NameToStringUtils._appendQualifiedName(prefixToNamespaceExisting, prefixToNamespaceNew, namespaceToPrefix, name, out);
                }
            }
            if ((attrName = key.getAttributeQName()) != null) {
                if (out.length() > 0) {
                    out.append('/');
                }
                out.append('@');
                NameToStringUtils._appendQualifiedName(prefixToNamespaceExisting, prefixToNamespaceNew, namespaceToPrefix, attrName, out);
            }
            return out;
        }
        if (type == 0) {
            String namespace = key.getNamespace();
            if (namespace == null) {
                return "{}";
            }
            return "{" + namespace + "}";
        }
        switch (type) {
            case 3: {
                return "text()";
            }
            case 4: {
                return "cdata-section()";
            }
            case 7: {
                return "processing-instruction()";
            }
            case 8: {
                return "comment()";
            }
            case 9: {
                return "document-node()";
            }
            case 10: {
                return "document-type()";
            }
        }
        throw new IllegalArgumentException("Unsupported key type " + type + "; key=" + key);
    }

    private static String _prefix(Map<String, String> namespaceToPrefix, Map<String, String> prefixToNamespaceExisting, Map<String, String> prefixToNamespaceNew, String namespace) {
        String found = namespaceToPrefix.get(namespace);
        if (found != null) {
            return found;
        }
        int i = 0;
        while (NameToStringUtils._eitherContains(prefixToNamespaceExisting, prefixToNamespaceNew, "n" + i)) {
            ++i;
        }
        String prefix = "n" + i;
        namespaceToPrefix.put(namespace, prefix);
        prefixToNamespaceNew.put(prefix, namespace);
        return prefix;
    }

    private static <T> boolean _eitherContains(Map<? extends T, ?> a, Map<? extends T, ?> b, T value) {
        return a.containsKey(value) || b.containsKey(value);
    }

    private static Map<String, String> _buildReverseMap(Map<String, String> prefixToNamespace) {
        HashMap<String, String> reverse = new HashMap<String, String>(prefixToNamespace.size());
        for (Map.Entry<String, String> entry : prefixToNamespace.entrySet()) {
            reverse.put(entry.getValue(), entry.getKey());
        }
        return reverse;
    }

    private static void _appendQualifiedName(Map<String, String> prefixToNamespaceExisting, Map<String, String> prefixToNamespaceNew, Map<String, String> namespaceToPrefix, QualifiedName name, StringBuilder out) {
        if (name.getIdentifier() != null) {
            out.append('!');
            out.append(name.getIdentifier());
            out.append('!');
        }
        NameToStringUtils._appendSimpleQName(prefixToNamespaceExisting, prefixToNamespaceNew, namespaceToPrefix, name.getNamespace(), name.getName(), out);
        if (name.getAttributeName() != null) {
            out.append("[@");
            NameToStringUtils._appendSimpleQName(prefixToNamespaceExisting, prefixToNamespaceNew, namespaceToPrefix, name.getAttributeNamespace(), name.getAttributeName(), out);
            out.append('=');
            NameToStringUtils._appendQuoted(out, name.getAttributeValue(), '\'');
            out.append(']');
        }
    }

    private static void _appendQuoted(StringBuilder out, CharSequence input, char quote) {
        out.append(quote);
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            out.append(c);
            if (c != quote) continue;
            out.append(c);
        }
        out.append(quote);
    }

    private static void _appendSimpleQName(Map<String, String> prefixToNamespaceExisting, Map<String, String> prefixToNamespaceNew, Map<String, String> namespaceToPrefix, String namespace, String name, StringBuilder out) {
        String prefix;
        if (namespace != null && (prefix = NameToStringUtils._prefix(namespaceToPrefix, prefixToNamespaceExisting, prefixToNamespaceNew, namespace)) != null && !"".equals(prefix)) {
            out.append(prefix);
            out.append(':');
        }
        out.append(name);
    }

    private NameToStringUtils() {
    }

    public static class ParseException
    extends Exception {
        ParseException(CharSequence input, int startIndex, int errorIndex, String errorMsg) {
            this(input, startIndex, errorIndex, errorMsg, null);
        }

        ParseException(CharSequence input, int startIndex, int errorIndex, String errorMsg, Throwable cause) {
            super("Parse exception: " + errorMsg + "; input='" + input + "' startIndex=" + startIndex + " errorIndex=" + errorIndex, cause);
        }
    }
}

