/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.sax;

import java.io.IOException;
import java.util.Stack;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.sax.AbstractXmlReader;
import oracle.bali.xml.sax.DefaultLexicalHandler;
import oracle.bali.xml.sax.DummyLocator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class TreeWalkerXmlReader
extends AbstractXmlReader {
    private LexicalHandler _lexicalHandler;
    private boolean _supportPrefixes = false;
    private final TreeWalker _walker;
    private final Locator _dummyLocator;
    private final AttributesImpl _saxAttributes = new AttributesImpl();
    private final Stack _namespacePrefixStack = new Stack();
    private static final String _NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String _NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";

    public TreeWalkerXmlReader(TreeWalker walker) {
        if (walker == null) {
            throw new IllegalArgumentException("Can not pass null TreeWalker to " + this.getClass().getName() + "!");
        }
        Node curNode = walker.getCurrentNode();
        if (curNode == null) {
            throw new IllegalArgumentException("Can not pass TreeWalker with null current node to " + this.getClass().getName() + "!");
        }
        this._walker = walker;
        Document doc = DomUtils.getOwnerDocument(curNode);
        this._dummyLocator = new DummyLocator(doc);
    }

    public void setNamespacePrefixesFeature(boolean value) {
        this._supportPrefixes = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource input) throws IOException, SAXException {
        this.getContentHandler().setDocumentLocator(this._dummyLocator);
        this.getContentHandler().startDocument();
        try {
            this._parse(this._walker);
        }
        finally {
            this.getContentHandler().endDocument();
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this._getLexicalHandler();
        }
        throw new SAXNotRecognizedException("Property: " + name + " not supported");
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            if (value instanceof LexicalHandler) {
                this._lexicalHandler = (LexicalHandler)value;
            }
        } else {
            throw new SAXNotRecognizedException("Property: " + name + " not supported");
        }
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (_NAMESPACES_FEATURE.equals(name)) {
            return true;
        }
        if (_NAMESPACE_PREFIXES_FEATURE.equals(name)) {
            return this._supportPrefixes;
        }
        throw new SAXNotRecognizedException("Feature: " + name + " not supported");
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (_NAMESPACES_FEATURE.equals(name)) {
            if (!value) {
                throw new SAXNotSupportedException("namespaces always on");
            }
        } else if (_NAMESPACE_PREFIXES_FEATURE.equals(name)) {
            this.setNamespacePrefixesFeature(value);
        } else {
            throw new SAXNotRecognizedException("Feature:" + name + " not supported");
        }
    }

    private void _parse(TreeWalker walker) throws IOException, SAXException {
        Node node = walker.getCurrentNode();
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                this._parseElement((Element)node, walker);
                break;
            }
            case 3: {
                this._parseTextNode((Text)node);
                break;
            }
            case 4: {
                this._parseCDATASection((CDATASection)node);
                break;
            }
            case 7: {
                this._parseProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this._parseCommentNode((Comment)node);
                break;
            }
            case 9: {
                this._parseChildren(walker);
                break;
            }
            case 10: {
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw new SAXParseException("Encountered unknown node type " + node.getNodeType() + " in node " + node, this._dummyLocator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _parseChildren(TreeWalker walker) throws SAXException, IOException {
        Node parentNode = walker.getCurrentNode();
        try {
            Node child = walker.firstChild();
            while (child != null) {
                this._parse(walker);
                child = walker.nextSibling();
            }
        }
        finally {
            walker.setCurrentNode(parentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _parseElement(Element element, TreeWalker walker) throws SAXException, IOException {
        int numNamespacePrefixes = this._processAttributesAndNamespaces(element);
        String curNamespace = element.getNamespaceURI();
        String curLocalName = DomUtils.getLocalName(element);
        String curQName = this._getQName(element.getPrefix(), curLocalName);
        this.getContentHandler().startElement(curNamespace, curLocalName, curQName, this._saxAttributes);
        try {
            this._parseChildren(walker);
        }
        finally {
            this.getContentHandler().endElement(curNamespace, curLocalName, curQName);
            this._endPrefixMappings(numNamespacePrefixes);
        }
    }

    private int _processAttributesAndNamespaces(Element element) throws SAXException {
        this._saxAttributes.clear();
        if (!element.hasAttributes()) {
            return 0;
        }
        int prefixesEncountered = 0;
        NamedNodeMap attrMap = element.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Node curAttr = attrMap.item(i);
            String curNamespace = curAttr.getNamespaceURI();
            String curLocalName = DomUtils.getLocalName(curAttr);
            String curValue = curAttr.getNodeValue();
            if (curNamespace == null) {
                curNamespace = "";
            }
            String curNamespacePrefix = null;
            if (curLocalName == null) {
                curLocalName = curAttr.getNodeName();
            }
            if ("http://www.w3.org/2000/xmlns/".equals(curNamespace)) {
                curNamespacePrefix = "xmlns".equals(curLocalName) ? "" : curLocalName;
            }
            if (curNamespacePrefix != null) {
                this._namespacePrefixStack.push(curNamespacePrefix);
                ++prefixesEncountered;
                this.getContentHandler().startPrefixMapping(curNamespacePrefix, curValue);
                if (!this._supportPrefixes) continue;
            }
            this._saxAttributes.addAttribute(curNamespace, curLocalName, this._getQName(curAttr.getPrefix(), curLocalName), "CDATA", curValue);
        }
        return prefixesEncountered;
    }

    private void _endPrefixMappings(int numToPop) throws SAXException {
        for (int i = 0; i < numToPop; ++i) {
            String prefix = (String)this._namespacePrefixStack.pop();
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    private String _getQName(String prefix, String localName) {
        int prefixSize;
        int n = prefixSize = prefix != null ? prefix.length() : 0;
        if (prefixSize == 0) {
            return localName;
        }
        int localNameSize = localName.length();
        StringBuffer qNameBuffer = new StringBuffer(prefixSize + 1 + localNameSize);
        qNameBuffer.append(prefix);
        qNameBuffer.append(':');
        qNameBuffer.append(localName);
        return qNameBuffer.toString();
    }

    private void _parseTextNode(Text text) throws SAXException {
        this._parseCharacterData(text);
    }

    private void _parseCDATASection(CDATASection cdata) throws SAXException {
        this._getLexicalHandler().startCDATA();
        this._parseCharacterData(cdata);
        this._getLexicalHandler().endCDATA();
    }

    private void _parseCharacterData(CharacterData data) throws SAXException {
        String dataString = data.getData();
        if (dataString != null) {
            char[] chars = dataString.toCharArray();
            this.getContentHandler().characters(chars, 0, chars.length);
        }
    }

    private void _parseProcessingInstruction(ProcessingInstruction pi) throws SAXException {
        this.getContentHandler().processingInstruction(pi.getTarget(), pi.getData());
    }

    private void _parseCommentNode(Comment comment) throws SAXException {
        char[] arr = comment.getData().toCharArray();
        this._getLexicalHandler().comment(arr, 0, arr.length);
    }

    private LexicalHandler _getLexicalHandler() {
        return this._lexicalHandler == null ? DefaultLexicalHandler.getDefaultLexicalHandler() : this._lexicalHandler;
    }
}

