/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.util.XMLUtils;

public class OracleStandaloneMetadataFile
implements StandaloneMetadataFile {
    private URL _location;
    private String _targetNS = null;
    private GrammarMetadata _grammarMetadata = null;
    private static final Logger _LOGGER = Logger.getLogger(OracleStandaloneMetadataFile.class.getName());

    public OracleStandaloneMetadataFile(URL location) throws StandaloneMetadataFileException {
        if (location == null) {
            throw new StandaloneMetadataFileException("No URL specified for StandaloneMetadataFile");
        }
        this._location = location;
        try {
            this._targetNS = XMLUtils.getTargetNamespace(this._location);
        }
        catch (Exception e) {
            throw new StandaloneMetadataFileException(e.getMessage(), e);
        }
    }

    public URL getLocation() {
        return this._location;
    }

    public String getTargetNamespace() {
        return this._targetNS;
    }

    public GrammarMetadata getGrammarMetadata() {
        if (this._grammarMetadata == null) {
            try {
                this._grammarMetadata = new GrammarMetadata(this._location);
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "Error getting Grammar Metadata", e);
            }
        }
        return this._grammarMetadata;
    }
}

