/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataFunctionRegistry;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataProvider;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.metadata.structured.StructuredMetadataUtils;
import oracle.bali.xml.metadata.util.MetadataProviderUtils;
import oracle.bali.xml.metadata.util.PseudoXmlKeyUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarMetadataProvider
extends XmlMetadataProvider {
    private final GrammarResolver _grammarResolver;
    private final GrammarResolverListener _grammarListener = new GrammarListener();
    private final ConcurrentHashMap<Object, Map> _metadataCache = new ConcurrentHashMap(173, 0.75f, 5);
    private final ConcurrentHashMap<XmlKey, Map> _sharedElementMetadataCache = new ConcurrentHashMap(11, 0.75f, 5);
    private final ConcurrentHashMap<XmlKey, Map> _sharedAttributeMetadataCache = new ConcurrentHashMap(11, 0.75f, 5);
    private final MetadataFunctionRegistry _functionRegistry = new MetadataFunctionRegistry();
    private final Map<Grammar, Map<QualifiedName, List<StructuredMetadataBean>>> _globalMetadataCache = new LinkedHashMap<Grammar, Map<QualifiedName, List<StructuredMetadataBean>>>();
    public static final String GRAMMAR_METADATA_ELEMENT = "grammarMetadata";
    public static final String ELEMENT_METADATA_ELEMENT = "elementMetadata";
    public static final String ATTRIBUTE_METADATA_ELEMENT = "attributeMetadata";
    public static final String SHARED_ELEMENT_METADATA_ELEMENT = "sharedElementMetadata";
    public static final String SHARED_ATTRIBUTE_METADATA_ELEMENT = "sharedAttributeMetadata";
    private static final QualifiedName _EXTRA_FIXED_ATTR_METADATA = QualifiedName.getQualifiedName("oracle.bali.xml.metadata.grammar.GrammarMetadataProvider", "extraFixedAttributeMetadata");
    private static final QualifiedName _PSEUDO_XMLKEY_METADATA = QualifiedName.getQualifiedName("oracle.bali.xml.metadata.grammar.GrammarMetadataProvider", "pseudoXmlKeyMetadata");
    private static final String _FIXED_ATTRIBUTE = "fixedAttribute";
    private static final String _PSEUDO_XML_KEYS = "pseudoXmlKeys";
    private static final Logger _LOGGER = Logger.getLogger(GrammarMetadataProvider.class.getName());

    public GrammarMetadataProvider(GrammarResolver resolver) {
        this(null, resolver);
    }

    public GrammarMetadataProvider(MetadataProvider base, GrammarResolver resolver) {
        super(base);
        this._grammarResolver = resolver;
        this._initGlobalMetadataAndFunctions();
        this._grammarResolver.addGrammarResolverListener(this._grammarListener);
    }

    @Override
    protected Map getLayerMetadata(Object key) {
        Map metadata = this._metadataCache.get(key);
        if (metadata == null) {
            if (key instanceof XmlKey) {
                XmlKey xmlKey = (XmlKey)key;
                metadata = this._createLayerMetadata(xmlKey);
            } else {
                metadata = Collections.EMPTY_MAP;
            }
            this._metadataCache.put(key, metadata);
        }
        return metadata;
    }

    @Override
    protected Object getLayerMetadataItem(Object key, Object itemKey) {
        Object metadataItem = null;
        Map metadata = this.getLayerMetadata(key);
        if (metadata != null) {
            metadataItem = metadata.get(itemKey);
        }
        return metadataItem;
    }

    @Override
    protected Object getLayerFunction(String prefix, String name) {
        return this._functionRegistry.getFunction(prefix, name);
    }

    @Override
    protected List<StructuredMetadataBean> getLayerGlobalMetadata(QualifiedName globalItemName) {
        ArrayList<StructuredMetadataBean> combinedList = new ArrayList<StructuredMetadataBean>();
        for (Map<QualifiedName, List<StructuredMetadataBean>> perGrammarMap : this._globalMetadataCache.values()) {
            List<StructuredMetadataBean> perGrammarList = perGrammarMap.get(globalItemName);
            if (perGrammarList == null) continue;
            combinedList.addAll(perGrammarList);
        }
        if (combinedList.isEmpty()) {
            return Collections.emptyList();
        }
        return combinedList;
    }

    @Override
    protected Collection getLayerPseudoXmlKeys(Object baseKey) {
        ArrayList<XmlKey> keys = Collections.EMPTY_LIST;
        if (baseKey instanceof XmlKey) {
            XmlKey baseXmlKey = (XmlKey)baseKey;
            PseudoXmlKeyUtil pxku = (PseudoXmlKeyUtil)this.getLayerMetadataItem(baseKey, _PSEUDO_XMLKEY_METADATA);
            if (pxku != null) {
                Collection<String> identifiers = pxku.getPseudoXmlKeyIdentifiers();
                keys = new ArrayList<XmlKey>(identifiers.size());
                for (String id : identifiers) {
                    XmlKey pseudoKey = ImmutableXmlKey.createPseudoElementKey(baseXmlKey.getElementQNamePath(), id);
                    keys.add(pseudoKey);
                }
            }
        }
        return keys;
    }

    protected void postProcessMetadataMap(XmlKey key, Map map) {
    }

    private Map _createLayerMetadata(XmlKey xmlKey) {
        Map<QualifiedName, Map<QualifiedName, PseudoXmlKeyUtil>> metadata = new HashMap(this._getSharedMetadata(xmlKey));
        if (xmlKey.getNodeType() == 1) {
            Map extraMetadataItems;
            QualifiedName attrQName;
            Map valueMap;
            XmlKey masterKey;
            Map extraFixedAttrMetadata;
            QualifiedName elementName = xmlKey.getElementQName();
            String identifier = elementName.getIdentifier();
            if (identifier != null) {
                Map pseudoMetadata;
                XmlKey baseKey = GrammarMetadataProvider._getMasterKey(xmlKey);
                PseudoXmlKeyUtil pseudoXmlKeyUtil = (PseudoXmlKeyUtil)this.getLayerMetadataItem(baseKey, _PSEUDO_XMLKEY_METADATA);
                if (pseudoXmlKeyUtil != null && (pseudoMetadata = pseudoXmlKeyUtil.getMetadataMap(identifier)) != null) {
                    metadata.putAll(pseudoMetadata);
                }
                return metadata;
            }
            String attrNamespace = elementName.getAttributeNamespace();
            String attrName = elementName.getAttributeName();
            String attrValue = elementName.getAttributeValue();
            if (attrName != null && attrValue != null && (extraFixedAttrMetadata = (Map)this.getLayerMetadataItem(masterKey = GrammarMetadataProvider._getMasterKey(xmlKey), _EXTRA_FIXED_ATTR_METADATA)) != null && (valueMap = (Map)extraFixedAttrMetadata.get(attrQName = QualifiedName.getQualifiedName(attrNamespace, attrName))) != null && (extraMetadataItems = (Map)valueMap.get(attrValue)) != null) {
                metadata.putAll(extraMetadataItems);
            }
        }
        GrammarComponent grammarComponent = GrammarUtils.getGrammarComponent(this._grammarResolver, xmlKey);
        Collection<Object> appInfos = Collections.emptyList();
        String metadataElementName = null;
        if (grammarComponent != null) {
            Annotation annotation = grammarComponent.getAnnotation();
            if (annotation != null && (appInfos = annotation.getApplicationInformation()) == null) {
                appInfos = Collections.emptyList();
            }
            if (grammarComponent instanceof Grammar) {
                metadataElementName = GRAMMAR_METADATA_ELEMENT;
            } else if (grammarComponent instanceof ElementDef) {
                metadataElementName = ELEMENT_METADATA_ELEMENT;
            } else if (grammarComponent instanceof AttributeDef) {
                metadataElementName = ATTRIBUTE_METADATA_ELEMENT;
            }
        }
        if (metadataElementName != null && !appInfos.isEmpty()) {
            for (Node appInfoItem : appInfos) {
                if (appInfoItem.getNodeType() != 1) continue;
                Element infoElement = (Element)appInfoItem;
                try {
                    NodeList elementList = infoElement.getElementsByTagNameNS("http://xmlns.oracle.com/bali/xml/metadata", metadataElementName);
                    Node metadataElement = null;
                    if (elementList != null) {
                        metadataElement = (Element)elementList.item(0);
                    }
                    if (metadataElement == null) continue;
                    for (Node child = metadataElement.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() != 1) continue;
                        Element childElement = (Element)child;
                        if (_FIXED_ATTRIBUTE.equals(child.getLocalName()) && "http://xmlns.oracle.com/bali/xml/metadata".equals(child.getNamespaceURI())) {
                            Map fixedAttrMetadata = MetadataProviderUtils.processFixedAttributeElement(childElement);
                            if (fixedAttrMetadata.isEmpty()) continue;
                            metadata.put(_EXTRA_FIXED_ATTR_METADATA, Collections.unmodifiableMap(fixedAttrMetadata));
                            continue;
                        }
                        if (_PSEUDO_XML_KEYS.equals(child.getLocalName()) && "http://xmlns.oracle.com/bali/xml/metadata".equals(child.getNamespaceURI())) {
                            metadata.put(_PSEUDO_XMLKEY_METADATA, (Map<QualifiedName, PseudoXmlKeyUtil>)((Object)new PseudoXmlKeyUtil(childElement)));
                            continue;
                        }
                        MetadataProviderUtils.addMetadataToMap(metadata, childElement);
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Error getting metadata for key: " + xmlKey, e);
                }
            }
        }
        if (metadata.isEmpty()) {
            metadata = Collections.EMPTY_MAP;
        } else {
            this.postProcessMetadataMap(xmlKey, metadata);
        }
        return metadata;
    }

    private void _initGlobalMetadataAndFunctions() {
        Collection grammars = this._grammarResolver.getGrammars();
        for (Grammar g : grammars) {
            this._processGlobalMetadataAndFunctions(g, true);
        }
    }

    private synchronized void _processGlobalMetadataAndFunctions(Grammar grammar, boolean add) {
        Collection<Node> appInfoNodes;
        Annotation annotation = grammar.getAnnotation();
        if (annotation != null && (appInfoNodes = annotation.getApplicationInformation()) != null) {
            LogRecord lr;
            LinkedHashMap<QualifiedName, ArrayList<StructuredMetadataBean>> globalMetadataMap = new LinkedHashMap<QualifiedName, ArrayList<StructuredMetadataBean>>();
            LinkedList<Element> newFunctions = new LinkedList<Element>();
            LinkedList<Element> oldFunctions = new LinkedList<Element>();
            String preferredPrefix = null;
            for (Node appInfoNode : appInfoNodes) {
                Element appInfoElement;
                Node grammarMetadata;
                if (!DomUtils.isElement(appInfoNode) || (grammarMetadata = DomUtils.getNamedChild(appInfoElement = (Element)appInfoNode, "http://xmlns.oracle.com/bali/xml/metadata", GRAMMAR_METADATA_ELEMENT)) == null) continue;
                for (Node child = grammarMetadata.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!DomUtils.isElement(child)) continue;
                    QualifiedName childQName = DomUtils.getQualifiedName(child);
                    if (MetadataProviderUtils.FUNCTIONS_QNAME.equals(childQName)) {
                        oldFunctions.add((Element)child);
                        continue;
                    }
                    if (MetadataProviderUtils.PREFERRED_PREFIX_QNAME.equals(childQName)) {
                        String found = DomUtils.getTextNodeValue(child);
                        if (found == null) continue;
                        preferredPrefix = found.trim();
                        continue;
                    }
                    if (!MetadataProviderUtils.GLOBAL_METADATA_QNAME.equals(childQName)) continue;
                    for (Node globalChild = child.getFirstChild(); globalChild != null; globalChild = globalChild.getNextSibling()) {
                        XmlKey ownerNSKey;
                        StructuredMetadataBean bean;
                        if (!DomUtils.isElement(globalChild)) continue;
                        Element globalChildElem = (Element)globalChild;
                        QualifiedName globalChildName = DomUtils.getQualifiedName(globalChildElem);
                        if (MetadataProviderUtils.FUNCTIONS_QNAME.equals(globalChildName)) {
                            newFunctions.add((Element)globalChild);
                            continue;
                        }
                        if (!add || (bean = StructuredMetadataUtils.createStructuredMetadata(globalChildElem, ownerNSKey = ImmutableXmlKey.createNamespaceKey(grammar.getTargetNamespace()))) == null) continue;
                        ArrayList<StructuredMetadataBean> smdList = (ArrayList<StructuredMetadataBean>)globalMetadataMap.get(globalChildName);
                        if (smdList == null) {
                            smdList = new ArrayList<StructuredMetadataBean>(5);
                            globalMetadataMap.put(globalChildName, smdList);
                        }
                        smdList.add(bean);
                    }
                }
            }
            if (add) {
                this._globalMetadataCache.put(grammar, globalMetadataMap);
            } else {
                this._globalMetadataCache.remove(grammar);
            }
            for (Element functions : oldFunctions) {
                try {
                    MetadataProviderUtils.processFunctionsElement(functions, this._functionRegistry, preferredPrefix, add);
                }
                catch (MetadataException e) {
                    lr = new LogRecord(Level.WARNING, "Error registering metadata functions for grammar {0}!");
                    lr.setThrown(e);
                    lr.setParameters(new Object[]{grammar.getGrammarIdentifier()});
                    _LOGGER.log(lr);
                }
            }
            for (Element functions : newFunctions) {
                try {
                    MetadataProviderUtils.processFunctionsElement(functions, this._functionRegistry, null, add);
                }
                catch (MetadataException e) {
                    lr = new LogRecord(Level.WARNING, "Error registering metadata functions for grammar {0}!");
                    lr.setThrown(e);
                    lr.setParameters(new Object[]{grammar.getGrammarIdentifier()});
                    _LOGGER.log(lr);
                }
            }
        }
    }

    private Map _getSharedMetadata(XmlKey key) {
        String namespace = key.getTargetNamespace();
        XmlKey namespaceKey = ImmutableXmlKey.createNamespaceKey(namespace);
        Map sharedElementMetadata = this._sharedElementMetadataCache.get(namespaceKey);
        Map sharedAttributeMetadata = this._sharedAttributeMetadataCache.get(namespaceKey);
        if (sharedElementMetadata == null || sharedAttributeMetadata == null) {
            sharedElementMetadata = new HashMap(11);
            sharedAttributeMetadata = new HashMap(11);
            Grammar g = this._grammarResolver.getGrammarForNamespace(namespace);
            if (g != null) {
                GrammarMetadataProvider._buildSharedMetadataForGrammar(g, sharedElementMetadata, sharedAttributeMetadata);
            }
            if (sharedElementMetadata.isEmpty()) {
                sharedElementMetadata = Collections.emptyMap();
            }
            if (sharedAttributeMetadata.isEmpty()) {
                sharedAttributeMetadata = Collections.emptyMap();
            }
            this._sharedElementMetadataCache.put(namespaceKey, sharedElementMetadata);
            this._sharedAttributeMetadataCache.put(namespaceKey, sharedAttributeMetadata);
        }
        if (key.getNodeType() == 1) {
            return sharedElementMetadata;
        }
        if (key.getNodeType() == 2) {
            return sharedAttributeMetadata;
        }
        return Collections.emptyMap();
    }

    private static void _buildSharedMetadataForGrammar(Grammar grammar, Map sharedElementMetadata, Map sharedAttributeMetadata) {
        Collection<Node> appInfoNodes;
        Annotation annotation;
        if (grammar != null && (annotation = grammar.getAnnotation()) != null && (appInfoNodes = annotation.getApplicationInformation()) != null) {
            for (Node appInfoElement : appInfoNodes) {
                Node sharedAttributeNode;
                Node grammarMetadata;
                if (appInfoElement.getNodeType() != 1 || (grammarMetadata = DomUtils.getNamedChild(appInfoElement, "http://xmlns.oracle.com/bali/xml/metadata", GRAMMAR_METADATA_ELEMENT)) == null) continue;
                Node sharedElementNode = DomUtils.getNamedChild(grammarMetadata, "http://xmlns.oracle.com/bali/xml/metadata", SHARED_ELEMENT_METADATA_ELEMENT);
                if (sharedElementNode != null) {
                    GrammarMetadataProvider._addSharedMetadata(sharedElementNode.getFirstChild(), sharedElementMetadata);
                }
                if ((sharedAttributeNode = DomUtils.getNamedChild(grammarMetadata, "http://xmlns.oracle.com/bali/xml/metadata", SHARED_ATTRIBUTE_METADATA_ELEMENT)) != null) {
                    GrammarMetadataProvider._addSharedMetadata(sharedAttributeNode.getFirstChild(), sharedAttributeMetadata);
                }
                return;
            }
        }
    }

    private static void _addSharedMetadata(Node metadataItem, Map metadataMap) {
        while (metadataItem != null) {
            if (metadataItem.getNodeType() == 1) {
                MetadataProviderUtils.addMetadataToMap(metadataMap, (Element)metadataItem);
            }
            metadataItem = metadataItem.getNextSibling();
        }
    }

    private static XmlKey _getMasterKey(XmlKey elementKey) {
        ArrayList<QualifiedName> strippedPath = new ArrayList<QualifiedName>(elementKey.getElementQNamePath());
        int lastIndex = strippedPath.size() - 1;
        QualifiedName variantName = (QualifiedName)strippedPath.get(lastIndex);
        QualifiedName masterName = QualifiedName.getQualifiedName(variantName.getNamespace(), variantName.getName());
        strippedPath.set(lastIndex, masterName);
        return ImmutableXmlKey.createElementKey(strippedPath);
    }

    private class GrammarListener
    implements GrammarResolverListener {
        private GrammarListener() {
        }

        public void grammarResolverChanged(GrammarResolverEvent e) {
            XmlKey namespaceKey;
            GrammarMetadataProvider.this._metadataCache.clear();
            Set grammarsAdded = e.getGrammarsAdded();
            Set grammarsRemoved = e.getGrammarsRemoved();
            Set grammarsChanged = e.getGrammarsChanged();
            for (Grammar added : grammarsAdded) {
                GrammarMetadataProvider.this._processGlobalMetadataAndFunctions(added, true);
            }
            for (Grammar removed : grammarsRemoved) {
                GrammarMetadataProvider.this._processGlobalMetadataAndFunctions(removed, false);
                namespaceKey = ImmutableXmlKey.createNamespaceKey(removed.getTargetNamespace());
                GrammarMetadataProvider.this._sharedElementMetadataCache.remove(namespaceKey);
                GrammarMetadataProvider.this._sharedAttributeMetadataCache.remove(namespaceKey);
            }
            for (Grammar changed : grammarsChanged) {
                GrammarMetadataProvider.this._processGlobalMetadataAndFunctions(changed, false);
                GrammarMetadataProvider.this._processGlobalMetadataAndFunctions(changed, true);
                namespaceKey = ImmutableXmlKey.createNamespaceKey(changed.getTargetNamespace());
                GrammarMetadataProvider.this._sharedElementMetadataCache.remove(namespaceKey);
                GrammarMetadataProvider.this._sharedAttributeMetadataCache.remove(namespaceKey);
            }
        }
    }
}

