/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.metadata.el.ELException;

final class Lookups {
    public static final Object lookupArray(Object array, int index) throws ELException {
        try {
            return Array.get(array, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final Object lookupList(List list, int index) throws ELException {
        try {
            return list.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final Object lookupMap(Map map, Object key) throws ELException {
        return map.get(key);
    }

    public static final Object lookupBean(Class beanClass, Object bean, String property) throws ELException {
        Method reader = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                if (!property.equals(pds[i].getName())) continue;
                reader = pds[i].getReadMethod();
                if (reader != null) {
                    return reader.invoke(bean, null);
                }
                break;
            }
        }
        catch (Exception e) {
            throw new ELException(e);
        }
        if (reader == null) {
            throw new ELException(property + " is not readable");
        }
        return null;
    }

    public static final void updateArray(Object array, int index, Object value) throws ELException {
        try {
            Array.set(array, index, value);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ELException(e);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final void updateList(List list, int index, Object value) throws ELException {
        try {
            list.set(index, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ELException(e);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public static final void updateMap(Map map, Object key, Object value) throws ELException {
        map.put(key, value);
    }

    public static final void updateBean(Class beanClass, Object bean, String property, Object value) throws ELException {
        Method writer = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                if (!property.equals(pds[i].getName())) continue;
                writer = pds[i].getWriteMethod();
                if (writer != null) {
                    try {
                        writer.invoke(bean, value);
                        continue;
                    }
                    catch (Exception e) {
                        throw new ELException("Error setting value " + value + " on property " + pds[i].getName() + " of " + bean, e);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            if (e instanceof ELException) {
                throw (ELException)e;
            }
            throw new ELException(e);
        }
        if (writer == null) {
            throw new ELException(property + " is not writable");
        }
    }

    public static final boolean isBeanReadOnly(Class beanClass, Object bean, String property) throws ELException {
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                if (!property.equals(pds[i].getName())) continue;
                Method writer = pds[i].getWriteMethod();
                return writer == null;
            }
        }
        catch (Exception e) {
            throw new ELException(e);
        }
        throw new ELException("Property \"" + property + "\" does not exist");
    }

    public static final Class getBeanType(Class beanClass, Object bean, String property) throws ELException {
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                if (!property.equals(pds[i].getName())) continue;
                Method reader = pds[i].getReadMethod();
                if (reader != null) {
                    return reader.getReturnType();
                }
                Method writer = pds[i].getWriteMethod();
                if (writer != null) {
                    return writer.getParameterTypes()[0];
                }
                throw new ELException("No writers or readers for property \"" + property + "\"");
            }
        }
        catch (Exception e) {
            throw new ELException(e);
        }
        throw new ELException("Property \"" + property + "\" does not exist");
    }

    private Lookups() {
    }
}

