/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.AbstractMetadataEvaluator;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayeredMetadataEvaluator
extends AbstractMetadataEvaluator {
    private static final Object _NULL_OBJECT = new Object();
    public static final int NONE = 0;
    public static final int KEY = 1;
    private final MetadataEvaluator _base;
    private final ConcurrentHashMap<Object, Map> _keyCache = new ConcurrentHashMap(53, 0.75f, 5);

    public LayeredMetadataEvaluator(MetadataEvaluator base) {
        this._base = base;
    }

    @Override
    public final Collection getPseudoXmlKeys(Object masterKey) {
        Collection pseudoXmlKeys = Collections.EMPTY_SET;
        if (this._base != null) {
            pseudoXmlKeys = new LinkedHashSet();
            pseudoXmlKeys.addAll(this._base.getPseudoXmlKeys(masterKey));
            pseudoXmlKeys.addAll(this.getLayerPseudoXmlKeys(masterKey));
        } else {
            pseudoXmlKeys = this.getLayerPseudoXmlKeys(masterKey);
        }
        return pseudoXmlKeys;
    }

    @Override
    public List<StructuredMetadataBean> getGlobalMetadata(QualifiedName globalItemName) {
        List<StructuredMetadataBean> baseList;
        List<StructuredMetadataBean> layerList;
        try {
            layerList = this.getLayerGlobalMetadata(globalItemName);
        }
        catch (Exception e) {
            e.printStackTrace();
            layerList = Collections.emptyList();
        }
        if (this._base != null) {
            try {
                baseList = this._base.getGlobalMetadata(globalItemName);
            }
            catch (Exception e) {
                e.printStackTrace();
                baseList = Collections.emptyList();
            }
        } else {
            baseList = Collections.emptyList();
        }
        if (layerList.isEmpty()) {
            return baseList;
        }
        if (baseList.isEmpty()) {
            return layerList;
        }
        ArrayList<StructuredMetadataBean> combinedList = new ArrayList<StructuredMetadataBean>();
        combinedList.addAll(layerList);
        combinedList.addAll(baseList);
        return combinedList;
    }

    @Override
    protected Object getMetadataItemImpl(Object key, Object itemKey, Node node) {
        Object metadataItem = this._getLayerMetadataItem(key, itemKey, node);
        if (metadataItem == null && this._base != null) {
            metadataItem = this._base.getMetadataItem(key, itemKey, node);
        }
        return metadataItem;
    }

    protected abstract MetadataInfo getLayerMetadataInfo(Object var1, Object var2, Node var3);

    protected List<StructuredMetadataBean> getLayerGlobalMetadata(QualifiedName globalItemName) {
        return Collections.emptyList();
    }

    protected Collection getLayerPseudoXmlKeys(Object masterKey) {
        return Collections.EMPTY_SET;
    }

    protected void cacheValue(Object value, int cacheType, Object key, Object itemKey, Node node) {
        if (cacheType == 1) {
            ConcurrentHashMap<Object, Object> keyMap = this._keyCache.get(key);
            if (keyMap == null) {
                keyMap = new ConcurrentHashMap<Object, Object>(16, 0.75f, 3);
                this._keyCache.put(key, keyMap);
            }
            keyMap.put(itemKey, value);
        }
    }

    protected Object getCachedValue(Object key, Object itemKey, Node node) {
        Object value = null;
        Map keyMap = this._keyCache.get(key);
        if (keyMap != null) {
            value = keyMap.get(itemKey);
        }
        return value;
    }

    protected void clearMetadataCache() {
        this._keyCache.clear();
    }

    private Object _getLayerMetadataItem(Object key, Object itemKey, Node node) {
        Object metadataValue = this.getCachedValue(key, itemKey, node);
        if (metadataValue == _NULL_OBJECT) {
            return null;
        }
        if (metadataValue == null) {
            MetadataInfo info = this.getLayerMetadataInfo(key, itemKey, node);
            if (info != null) {
                Object value = info.value;
                if (info.value == null) {
                    value = _NULL_OBJECT;
                }
                this.cacheValue(value, info.cacheType, key, itemKey, node);
                metadataValue = info.value;
            } else {
                this.cacheValue(_NULL_OBJECT, 1, key, itemKey, node);
            }
        }
        return metadataValue;
    }

    protected class MetadataInfo {
        public Object value;
        public int cacheType;

        public MetadataInfo(Object value, int cacheType) {
            this.value = value;
            this.cacheType = cacheType;
        }
    }
}

