/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDNode;

public class OracleWildcard
implements Wildcard {
    private XSDAny _xsdAny = null;
    private int _variety = -1;
    private int _processingRule = -1;
    private List _namespaceConstraints = null;
    private Annotation _annotation = null;

    public int getMinOccurs() {
        return this._xsdAny.getMinOccurs();
    }

    public int getMaxOccurs() {
        int maxOccurs = this._xsdAny.getMaxOccurs();
        if (0x7FFFFFF8 == maxOccurs) {
            maxOccurs = -1;
        }
        return maxOccurs;
    }

    public int getVariety() {
        if (this._variety == -1) {
            this._determineVariety();
        }
        return this._variety;
    }

    public List getNamespaceConstraintList() {
        if (this._namespaceConstraints == null) {
            this._determineVariety();
        }
        return this._namespaceConstraints;
    }

    public int getProcessingRule() {
        if (this._processingRule == -1) {
            String processingRuleString = this._xsdAny.getProcessContents();
            this._processingRule = "lax".equals(processingRuleString) ? 1 : ("skip".equals(processingRuleString) ? 2 : 0);
        }
        return this._processingRule;
    }

    public String getName() {
        return this._xsdAny.getName();
    }

    public String getTargetNamespace() {
        return this._xsdAny.getTargetNS();
    }

    public Annotation getAnnotation() {
        if (this._annotation == null) {
            this._annotation = new OracleAnnotation((XSDNode)this._xsdAny);
        }
        return this._annotation;
    }

    OracleWildcard(XSDAny xsdAny) {
        this._xsdAny = xsdAny;
    }

    private synchronized void _determineVariety() {
        if (this._variety == -1) {
            this._namespaceConstraints = Collections.EMPTY_LIST;
            if (this._xsdAny.isAnyNamespaceAllowed()) {
                this._variety = 0;
            } else if (this._xsdAny.getNamespaceNotAllowed() != null) {
                this._variety = 1;
            } else {
                this._variety = 2;
                String[] allowedNamespaces = this._xsdAny.getNamespaceAllowed();
                if (allowedNamespaces != null) {
                    this._namespaceConstraints = new ArrayList(allowedNamespaces.length);
                    for (int i = 0; i < allowedNamespaces.length; ++i) {
                        String namespace = allowedNamespaces[i];
                        if (namespace != null && namespace.length() == 0) {
                            namespace = null;
                        }
                        this._namespaceConstraints.add(namespace);
                    }
                }
            }
        }
    }
}

