/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.ConstrainingFacet;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.common.ConstrainingFacetImpl;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleConstrainingFacet;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.xml.parser.schema.XSDConstrainingFacet;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;

public class OracleSimpleType
implements SimpleType {
    private static final String _KEY_SIMPLETYPE_VALIDATION_NAME = "SIMPLETYPE_VALIDATION_NAME";
    private static final String _KEY_SIMPLETYPE_VALIDATION_TYPE = "SIMPLETYPE_VALIDATION_TYPE";
    private static final String _KEY_SIMPLETYPE_VALIDATION_FACETS = "SIMPLETYPE_VALIDATION_FACETS";
    private static final String _KEY_SIMPLETYPE_VALIDATION_UNION_TYPES = "SIMPLETYPE_VALIDATION_UNION_TYPES";
    private static final String _KEY_SIMPLETYPE_TYPE_ANONYMOUS = "SIMPLETYPE_TYPE_ANONYMOUS";
    private static final String _KEY_SIMPLETYPE_TYPE_NAME = "SIMPLETYPE_TYPE_NAME";
    private static final String _KEY_SIMPLETYPE_TYPE_BASE = "SIMPLETYPE_TYPE_BASE";
    private static final String _KEY_SIMPLETYPE_TYPE_PRIMITIVE = "SIMPLETYPE_TYPE_PRIMITIVE";
    private static final String _KEY_SIMPLETYPE_FACET_LENGTH = "SIMPLETYPE_FACET_LENGTH";
    private static final String _KEY_SIMPLETYPE_FACET_MINLENGTH = "SIMPLETYPE_FACET_MINLENGTH";
    private static final String _KEY_SIMPLETYPE_FACET_MAXLENGTH = "SIMPLETYPE_FACET_MAXLENGTH";
    private static final String _KEY_SIMPLETYPE_FACET_PATTERN = "SIMPLETYPE_FACET_PATTERN";
    private static final String _KEY_SIMPLETYPE_FACET_ENUMERATION = "SIMPLETYPE_FACET_ENUMERATION";
    private static final String _KEY_SIMPLETYPE_FACET_MININCLUSIVE = "SIMPLETYPE_FACET_MININCLUSIVE";
    private static final String _KEY_SIMPLETYPE_FACET_MINEXCLUSIVE = "SIMPLETYPE_FACET_MINEXCLUSIVE";
    private static final String _KEY_SIMPLETYPE_FACET_MAXINCLUSIVE = "SIMPLETYPE_FACET_MAXINCLUSIVE";
    private static final String _KEY_SIMPLETYPE_FACET_MAXEXCLUSIVE = "SIMPLETYPE_FACET_MAXEXCLUSIVE";
    private static final String _KEY_SIMPLETYPE_FACET_TOTAL_DIGITS = "SIMPLETYPE_FACET_TOTAL_DIGITS";
    private static final String _KEY_SIMPLETYPE_FACET_FRACTION_DIGITS = "SIMPLETYPE_FACET_FRACTION_DIGITS";
    private static final Logger _LOGGER = Logger.getLogger(OracleSimpleType.class.getName());
    private OracleSchemaFactory _factory = null;
    private XSDSimpleType _xsdSimpleType = null;
    private OracleSimpleType _builtInType = null;
    private OracleSimpleType _primitiveType = null;
    private OracleSimpleType _listItemType = null;
    private List _unionMemberTypes = null;
    private Collection _constrainingFacets = null;
    private Annotation _annotation = null;

    public String getName() {
        String name = this._xsdSimpleType.getName();
        if (name != null && name.length() == 0) {
            name = null;
        }
        return name;
    }

    public String getTargetNamespace() {
        String tns = this._xsdSimpleType.getTargetNS();
        return tns == null ? "http://www.w3.org/2001/XMLSchema" : tns;
    }

    public SimpleType getBuiltInBaseType() {
        if (this._builtInType == null) {
            try {
                XSDSimpleType builtInType;
                String typeLocalName;
                XSDSimpleType testType;
                XSDSimpleType oldType = null;
                Hashtable builtInTypes = XSDSimpleType.getBuiltInDatatypes();
                for (testType = this._xsdSimpleType; testType != null && testType != oldType && ((typeLocalName = testType.getName()) == null || (builtInType = (XSDSimpleType)builtInTypes.get(typeLocalName)) == null || testType != builtInType); testType = testType.getBase()) {
                    oldType = testType;
                }
                if (testType != null) {
                    this._builtInType = this._factory.getSimpleTypeWrapper(testType);
                }
            }
            catch (Exception e) {
                this._builtInType = null;
            }
        }
        return this._builtInType;
    }

    public SimpleType getPrimitiveType() {
        if (this._primitiveType == null) {
            try {
                int primitiveIndex = this._xsdSimpleType.getBasicType();
                String primitiveTypeName = XSDTypeConstants.sTypes[primitiveIndex];
                Hashtable builtInTypes = XSDSimpleType.getBuiltInDatatypes();
                XSDSimpleType xsdPrimitiveType = (XSDSimpleType)builtInTypes.get(primitiveTypeName);
                this._primitiveType = this._factory.getSimpleTypeWrapper(xsdPrimitiveType);
            }
            catch (Exception e) {
                this._primitiveType = null;
            }
        }
        return this._primitiveType;
    }

    public int getVariety() {
        String xsdVariety = this._xsdSimpleType.getVariety();
        if ("atomic".equals(xsdVariety)) {
            return 0;
        }
        if ("list".equals(xsdVariety)) {
            return 1;
        }
        if ("union".equals(xsdVariety)) {
            return 2;
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getConstrainingFacets() {
        if (this._constrainingFacets == null) {
            OracleSimpleType oracleSimpleType = this;
            synchronized (oracleSimpleType) {
                if (this._constrainingFacets == null) {
                    List<Object> foundFacets = new ArrayList(3);
                    XSDConstrainingFacet[] xsdFacets = this._xsdSimpleType.getFacets();
                    if (xsdFacets != null) {
                        XSDConstrainingFacet wsFacet = null;
                        for (int i = 0; i < xsdFacets.length; ++i) {
                            XSDConstrainingFacet xsdFacet = xsdFacets[i];
                            if (xsdFacet == null) continue;
                            if (xsdFacet.getFacetId() == 12) {
                                wsFacet = xsdFacet;
                                continue;
                            }
                            foundFacets.add(new OracleConstrainingFacet(xsdFacet));
                        }
                        String bogusWSValue = this._xsdSimpleType.getWSFacetValue();
                        if (bogusWSValue == null || bogusWSValue.length() == 0) {
                            if (wsFacet != null) {
                                foundFacets.add(new OracleConstrainingFacet(wsFacet));
                            }
                        } else {
                            foundFacets.add(new ConstrainingFacetImpl("whitespace", 12, bogusWSValue, null));
                        }
                    }
                    if (foundFacets.isEmpty()) {
                        foundFacets = Collections.emptyList();
                    }
                    this._constrainingFacets = foundFacets;
                }
            }
        }
        return this._constrainingFacets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUnionMemberTypes() {
        if (this._unionMemberTypes == null) {
            OracleSimpleType oracleSimpleType = this;
            synchronized (oracleSimpleType) {
                if (this._unionMemberTypes == null) {
                    List<Object> foundMemberTypes = new ArrayList(2);
                    Vector xsdMembers = this._xsdSimpleType.getMemberTypes();
                    if (xsdMembers != null) {
                        int numMembers = xsdMembers.size();
                        for (int i = 0; i < numMembers; ++i) {
                            XSDSimpleType xsdMember = (XSDSimpleType)xsdMembers.get(i);
                            if (xsdMember == null) continue;
                            OracleSimpleType wrapper = this._factory.getSimpleTypeWrapper(xsdMember);
                            foundMemberTypes.add(wrapper);
                        }
                    }
                    if (foundMemberTypes.isEmpty()) {
                        foundMemberTypes = Collections.emptyList();
                    }
                    this._unionMemberTypes = foundMemberTypes;
                }
            }
        }
        return this._unionMemberTypes;
    }

    public SimpleType getListItemType() {
        XSDSimpleType xsdItemType;
        if (this._listItemType == null && (xsdItemType = this._xsdSimpleType.getItemType()) != null) {
            OracleSimpleType wrapper;
            this._listItemType = wrapper = this._factory.getSimpleTypeWrapper(xsdItemType);
        }
        return this._listItemType;
    }

    public void validateValue(String value) throws GrammarException {
        try {
            this._xsdSimpleType.validateValue(value);
        }
        catch (StringIndexOutOfBoundsException se) {
            LogRecord lr = new LogRecord(Level.WARNING, "Error validating value!");
            lr.setThrown(se);
            _LOGGER.log(lr);
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer();
            if ("http://www.w3.org/2001/XMLSchema".equals(this.getTargetNamespace()) && "Name".equals(this.getName())) {
                message.append(OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_NAME));
            } else if (this.getVariety() == 2) {
                message.append(this._getUnionMessage(this.getUnionMemberTypes()));
            } else {
                String fullList;
                Collection facets;
                SimpleType primitiveType;
                message.append(OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_TYPE));
                message.append("\n\n");
                message.append(OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_TYPE_NAME));
                message.append("  ");
                if (this.getName() != null) {
                    message.append(this.getName());
                } else {
                    message.append(OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_TYPE_ANONYMOUS));
                }
                SimpleType baseType = this.getBuiltInBaseType();
                if (baseType != null && baseType != this) {
                    message.append("\n");
                    message.append(OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_TYPE_BASE));
                    message.append("  ");
                    message.append(baseType.getName());
                }
                if ((primitiveType = this.getPrimitiveType()) != null) {
                    message.append("\n");
                    message.append(OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_TYPE_PRIMITIVE));
                    message.append("  ");
                    message.append(primitiveType.getName());
                }
                if (!(facets = this.getConstrainingFacets()).isEmpty() && (fullList = this._getFacetDescriptions(facets)) != null) {
                    message.append("\n\n");
                    message.append(OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_FACETS));
                    message.append("\n\n");
                    message.append(fullList);
                }
            }
            if (message.length() == 0) {
                message.append(e.getMessage());
            }
            throw new GrammarException(message.toString(), e);
        }
    }

    public Object convertToJavaType(String value) throws GrammarException {
        return JavaTypeManager.getInstance().convertToJavaType(value, this);
    }

    public Annotation getAnnotation() {
        if (this._annotation == null) {
            this._annotation = new OracleAnnotation((XSDNode)this._xsdSimpleType);
        }
        return this._annotation;
    }

    public String toString() {
        return this.getName();
    }

    OracleSimpleType(OracleSchemaFactory factory, XSDSimpleType xsdSimpleType) {
        this._factory = factory;
        this._xsdSimpleType = xsdSimpleType;
    }

    private String _getFacetDescriptions(Collection facets) {
        String message = "";
        for (ConstrainingFacet facet : facets) {
            String facetValue = this._getFacetErrorValue(facet);
            if (facetValue == null) continue;
            message = message + facetValue + "\n";
        }
        return "".equals(message) ? null : message;
    }

    private String _getUnionMessage(List types) {
        String message = OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_UNION_TYPES) + "\n";
        for (SimpleType type : types) {
            if ("unknownType".equals(type.getName())) continue;
            message = message + "\n" + type.getName();
            Collection facets = type.getConstrainingFacets();
            if (facets.isEmpty()) {
                message = message + "\n";
                continue;
            }
            String facetValues = this._getFacetDescriptions(facets);
            if (facetValues != null) {
                message = message + " " + OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_FACETS) + "\n" + facetValues;
                continue;
            }
            message = message + "\n";
        }
        return message;
    }

    private String _getFacetErrorValue(ConstrainingFacet facet) {
        switch (facet.getFacetID()) {
            case 7: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_LENGTH) + "  " + facet.getConstraintValue();
            }
            case 9: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_MINLENGTH) + "  " + facet.getConstraintValue();
            }
            case 8: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_MAXLENGTH) + "  " + facet.getConstraintValue();
            }
            case 11: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_PATTERN) + "  " + facet.getConstraintValue();
            }
            case 10: {
                Collection enu = facet.getEnumerationValues();
                String message = OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_ENUMERATION);
                Iterator i = enu.iterator();
                while (i.hasNext()) {
                    message = message + i.next() + " ";
                }
                return message;
            }
            case 1: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_MININCLUSIVE) + "  " + facet.getConstraintValue();
            }
            case 2: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_MINEXCLUSIVE) + "  " + facet.getConstraintValue();
            }
            case 3: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_MAXINCLUSIVE) + "  " + facet.getConstraintValue();
            }
            case 4: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_MAXEXCLUSIVE) + "  " + facet.getConstraintValue();
            }
            case 5: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_TOTAL_DIGITS) + "  " + facet.getConstraintValue();
            }
            case 6: {
                return OracleSimpleType._getTranslatedString(_KEY_SIMPLETYPE_FACET_FRACTION_DIGITS) + "  " + facet.getConstraintValue();
            }
        }
        return null;
    }

    private static String _getTranslatedString(String key) {
        try {
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.xml.grammar.schema.error.resource.ErrorBundle", Locale.getDefault());
            return b.getString(key);
        }
        catch (Exception e) {
            return "???" + key + "???";
        }
    }
}

