/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarIdentifier;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleAttributeDef;
import oracle.bali.xml.grammar.schema.OracleElementDef;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;

public class OracleSchema
implements Grammar {
    private OracleSchemaFactory _factory = null;
    private XMLSchemaNode _schemaNode = null;
    private URL _schemaLocation = null;
    private LinkedHashMap _elementMap = null;
    private LinkedHashMap _attributeMap = null;
    private LinkedHashMap _typeMap = null;
    private Annotation _annotation = null;
    private GrammarIdentifier _identifier = null;

    public String getName() {
        return this._schemaNode.getName();
    }

    public String getTargetNamespace() {
        return "".equals(this._schemaNode.getTargetNS()) ? null : this._schemaNode.getTargetNS();
    }

    public Collection getElementDefs() {
        return this._getElementMap().values();
    }

    public ElementDef getElementDefByName(String elementName) {
        return (ElementDef)this._getElementMap().get(elementName);
    }

    public Collection getAttributeDefs() {
        return this._getAttributeMap().values();
    }

    public AttributeDef getAttributeDefByName(String attributeName) {
        return (AttributeDef)this._getAttributeMap().get(attributeName);
    }

    public Collection getTypes() {
        return this._getTypeMap().values();
    }

    public Type getTypeByName(String typeName) {
        return (Type)this._getTypeMap().get(typeName);
    }

    public GrammarIdentifier getGrammarIdentifier() {
        return this._identifier;
    }

    public int getGrammarVariety() {
        return 0;
    }

    public URL getLocation() {
        return this._schemaLocation;
    }

    public Annotation getAnnotation() {
        if (this._annotation == null) {
            this._annotation = new OracleAnnotation((XSDNode)this._schemaNode);
        }
        return this._annotation;
    }

    public OracleSchemaFactory getFactory() {
        return this._factory;
    }

    OracleSchema(OracleSchemaFactory factory, XMLSchemaNode schemaNode, URL location) {
        this._factory = factory;
        this._schemaNode = schemaNode;
        this._schemaLocation = location;
        this._identifier = GrammarIdentifier.getGrammarIdentifier(this._schemaNode.getTargetNS(), null);
    }

    private synchronized LinkedHashMap _getElementMap() {
        if (this._elementMap == null) {
            this._elementMap = new LinkedHashMap(37);
            XSDNode[] schemaElements = this._schemaNode.getElementSet();
            if (schemaElements != null) {
                for (int iter = 0; iter < schemaElements.length; ++iter) {
                    XSDElement xsdElement = (XSDElement)schemaElements[iter];
                    OracleElementDef elementWrapper = this._factory.getElementWrapper(xsdElement);
                    if (elementWrapper.getName() == null) continue;
                    this._elementMap.put(elementWrapper.getName(), elementWrapper);
                }
            }
        }
        return this._elementMap;
    }

    private synchronized LinkedHashMap _getAttributeMap() {
        if (this._attributeMap == null) {
            this._attributeMap = new LinkedHashMap(17);
            XSDAttribute[] globalAttributes = this._schemaNode.getAttributeDeclarations();
            if (globalAttributes != null) {
                for (int i = 0; i < globalAttributes.length; ++i) {
                    OracleAttributeDef attributeWrapper;
                    String attributeName;
                    XSDAttribute anAttribute = globalAttributes[i];
                    if (anAttribute == null || (attributeName = (attributeWrapper = this._factory.getAttributeWrapper(anAttribute)).getName()) == null) continue;
                    this._attributeMap.put(attributeName, attributeWrapper);
                }
            }
        }
        return this._attributeMap;
    }

    private synchronized LinkedHashMap _getTypeMap() {
        if (this._typeMap == null) {
            Collection xsdTypes;
            this._typeMap = new LinkedHashMap(31);
            Hashtable typeTable = this._schemaNode.getTypeDefinitionTable();
            if (typeTable != null && (xsdTypes = typeTable.values()) != null) {
                for (XSDNode xsdType : xsdTypes) {
                    String typeName;
                    Type wrapper = this._factory.getTypeWrapper(xsdType);
                    if (wrapper == null || (typeName = wrapper.getName()) == null) continue;
                    this._typeMap.put(typeName, wrapper);
                }
            }
        }
        return this._typeMap;
    }
}

