/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.xml.grammar.ContextualFixedAttributeElementDefProvider;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDefProvider;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.GrammarProviderAdapter;
import oracle.bali.xml.grammar.GrammarProviderEvent;
import oracle.bali.xml.grammar.GrammarProviderListener;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarExtension;
import oracle.bali.xml.grammar.resolver.GrammarExtensionEvent;
import oracle.bali.xml.grammar.resolver.GrammarExtensionListener;
import oracle.bali.xml.grammar.resolver.GrammarResolverAdapter;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.grammar.resolver.GrammarResolverListener;
import org.w3c.dom.Element;

public class GrammarResolver {
    private ListenerManager _listeners;
    private GrammarProvider _provider = null;
    private GrammarProviderListener _providerListener = new ProviderChangedListener();
    private GrammarExtensionListener _extensionListener = new ExtensionChangedListener();
    private HashMap _grammarExtensions = new HashMap();

    public GrammarResolver(GrammarProvider provider) {
        this._provider = provider;
        this._provider.addGrammarProviderListener(this._providerListener);
    }

    public Grammar getGrammarForNamespace(String targetNamespace) {
        return this._provider.getGrammarForNamespace(targetNamespace);
    }

    public Collection getGrammars() {
        return this._provider.getGrammars();
    }

    public final boolean hasFixedAttributeElementDefs(ElementDef elementDef) {
        return this.getFixedAttributeElementDefProvider(elementDef) != null;
    }

    public final QualifiedName getFixedAttributeName(ElementDef elementDef) {
        FixedAttributeElementDefProvider provider;
        QualifiedName attrName = null;
        if (elementDef != null && (provider = this.getFixedAttributeElementDefProvider(elementDef)) != null) {
            attrName = provider.getFixedAttributeName();
        }
        return attrName;
    }

    public final Collection getFixedAttributeElementDefs(ElementDef elementDef) {
        FixedAttributeElementDefProvider provider;
        if (elementDef != null && (provider = this.getFixedAttributeElementDefProvider(elementDef)) != null) {
            return provider.getFixedAttributeElementDefs();
        }
        return Collections.EMPTY_LIST;
    }

    public final FixedAttributeElementDef getFixedAttributeElementDef(ElementDef elementDef, QualifiedName attrName, String attrValue) {
        return this.getFixedAttributeElementDef(null, elementDef, attrName, attrValue);
    }

    public final FixedAttributeElementDef getFixedAttributeElementDef(Element element, ElementDef elementDef, QualifiedName attrName, String attrValue) {
        FixedAttributeElementDefProvider provider;
        FixedAttributeElementDef faElementDef = null;
        if (elementDef != null && (provider = this.getFixedAttributeElementDefProvider(elementDef)) != null && provider.getFixedAttributeName().equals(attrName)) {
            if (provider instanceof ContextualFixedAttributeElementDefProvider) {
                ContextualFixedAttributeElementDefProvider contextualProvider = (ContextualFixedAttributeElementDefProvider)provider;
                faElementDef = contextualProvider.getFixedAttributeElementDef(element, attrValue);
            } else if (attrValue != null && attrValue.length() > 0) {
                faElementDef = provider.getFixedAttributeElementDef(attrValue);
            }
        }
        return faElementDef;
    }

    public final void addGrammarExtension(GrammarExtension extension) {
        String namespace = extension.getNamespace();
        LinkedHashSet<GrammarExtension> namespaceExtensions = (LinkedHashSet<GrammarExtension>)this._grammarExtensions.get(namespace);
        if (namespaceExtensions == null) {
            namespaceExtensions = new LinkedHashSet<GrammarExtension>(5);
            this._grammarExtensions.put(namespace, namespaceExtensions);
        }
        if (!namespaceExtensions.contains(extension)) {
            namespaceExtensions.add(extension);
            extension.addGrammarExtensionListener(this._extensionListener);
        }
    }

    public final void addGrammarResolverListener(GrammarResolverListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public final void removeGrammarResolverListener(GrammarResolverListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    protected final Set getGrammarExtensions(String namespace) {
        Set namespaceExtensions = (Set)this._grammarExtensions.get(namespace);
        if (namespaceExtensions != null) {
            return namespaceExtensions;
        }
        return Collections.EMPTY_SET;
    }

    protected FixedAttributeElementDefProvider getFixedAttributeElementDefProvider(ElementDef elementDef) {
        FixedAttributeElementDefProvider provider = null;
        if (elementDef != null) {
            Set grammarExtensions = this.getGrammarExtensions(elementDef.getQualifiedName().getNamespace());
            Iterator extensionIter = grammarExtensions.iterator();
            while (extensionIter.hasNext() && provider == null) {
                GrammarExtension extension = (GrammarExtension)extensionIter.next();
                provider = extension.getFixedAttributeElementDefProvider(elementDef);
            }
            if (provider == null && elementDef instanceof FixedAttributeElementDefProvider) {
                provider = (FixedAttributeElementDefProvider)((Object)elementDef);
            }
        }
        return provider;
    }

    protected void handleGrammarProviderChanged(GrammarProviderEvent e) {
        this.fireEvent(e.getGrammarsAdded(), e.getGrammarsRemoved(), e.getGrammarsChanged());
    }

    protected void handleGrammarExtensionChanged(GrammarExtensionEvent e) {
        GrammarExtension extension = e.getGrammarExtension();
        Grammar grammar = this.getGrammarForNamespace(extension.getNamespace());
        if (grammar != null) {
            this.fireGrammarChangedEvent(grammar);
        }
    }

    protected void fireEvent(GrammarResolverEvent event) {
        if (this._listeners != null && event != null) {
            GrammarResolverListener l;
            event.prepareForDelivery();
            Enumeration iter = this._listeners.getListeners();
            if (iter != null) {
                while (iter.hasMoreElements()) {
                    l = (GrammarResolverListener)iter.nextElement();
                    if (!(l instanceof GrammarResolverAdapter)) continue;
                    ((GrammarResolverAdapter)l).invalidate(event);
                }
            }
            if ((iter = this._listeners.getListeners()) != null) {
                while (iter.hasMoreElements()) {
                    l = (GrammarResolverListener)iter.nextElement();
                    l.grammarResolverChanged(event);
                }
            }
        }
    }

    protected void fireEvent(Set grammarsAdded, Set grammarsRemoved, Set grammarsChanged) {
        GrammarResolverEvent event = new GrammarResolverEvent(this, grammarsAdded, grammarsRemoved, grammarsChanged);
        this.fireEvent(event);
    }

    protected void fireGrammarChangedEvent(Grammar grammar) {
        GrammarResolverEvent event = new GrammarResolverEvent(this);
        event.notifyGrammarChanged(grammar);
        this.fireEvent(event);
    }

    protected ListenerManager getListenerManager() {
        return this._listeners;
    }

    private class ExtensionChangedListener
    implements GrammarExtensionListener {
        private ExtensionChangedListener() {
        }

        public void grammarExtensionChanged(GrammarExtensionEvent e) {
            GrammarResolver.this.handleGrammarExtensionChanged(e);
        }
    }

    private class ProviderChangedListener
    extends GrammarProviderAdapter {
        private ProviderChangedListener() {
        }

        public void grammarProviderChanged(GrammarProviderEvent e) {
            GrammarResolver.this.handleGrammarProviderChanged(e);
        }
    }
}

