/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.automata;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.WeakHashMap;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Particle;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.automata.ElementDefTransition;
import oracle.bali.xml.grammar.automata.FinalState;
import oracle.bali.xml.grammar.automata.LambdaTransition;
import oracle.bali.xml.grammar.automata.State;
import oracle.bali.xml.grammar.automata.Transition;
import oracle.bali.xml.grammar.automata.WildcardTransition;

public final class AutomataBuilder {
    private static final int _OCCURRENCE_THRESHOLD = 50;
    private static WeakHashMap _automataCache = new WeakHashMap(113);

    public static State buildAutomata(ContentGroup group) {
        State initialDFAState = null;
        SoftReference cacheRef = (SoftReference)_automataCache.get(group);
        if (cacheRef != null) {
            initialDFAState = (State)cacheRef.get();
        }
        if (initialDFAState == null) {
            State finalState = AutomataBuilder._createState(true);
            State initialNFAState = AutomataBuilder._processParticle(finalState, group);
            initialDFAState = AutomataBuilder._convertToDFA(initialNFAState);
            _automataCache.put(group, new SoftReference<State>(initialDFAState));
        }
        return initialDFAState;
    }

    private static State _processParticle(State S, Particle particle) {
        int maxOccurs = particle.getMaxOccurs();
        int minOccurs = particle.getMinOccurs();
        State n = S;
        if (maxOccurs == -1 || maxOccurs > 50) {
            State t = AutomataBuilder._createState();
            State b = AutomataBuilder._processTerm(t, particle);
            AutomataBuilder._createLambdaTransition(t, b);
            AutomataBuilder._createLambdaTransition(b, n);
            n = b;
        } else {
            int maxMinusMin = maxOccurs - minOccurs;
            for (int i = 0; i < maxMinusMin; ++i) {
                n = AutomataBuilder._processTerm(n, particle);
                AutomataBuilder._createLambdaTransition(n, S);
            }
        }
        for (int j = 0; j < minOccurs; ++j) {
            n = AutomataBuilder._processTerm(n, particle);
        }
        return n;
    }

    private static State _processTerm(State S, Particle particle) {
        State returnState = S;
        if (particle instanceof ElementDef) {
            returnState = AutomataBuilder._processElementDef(S, (ElementDef)particle);
        } else if (particle instanceof Wildcard) {
            returnState = AutomataBuilder._processWildcard(S, (Wildcard)particle);
        } else if (particle instanceof ContentGroup) {
            returnState = AutomataBuilder._processContentGroup(S, (ContentGroup)particle);
        }
        return returnState;
    }

    private static State _processContentGroup(State S, ContentGroup group) {
        State returnState = S;
        ArrayList particles = new ArrayList(group.getComponents());
        int variety = group.getVariety();
        switch (variety) {
            case 9: {
                returnState = AutomataBuilder._processSequence(S, particles);
                break;
            }
            case 8: {
                returnState = AutomataBuilder._processChoice(S, particles);
                break;
            }
            case 7: {
                returnState = AutomataBuilder._processAll(S, particles);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Group Variety:" + variety + " " + group.getClass());
            }
        }
        return returnState;
    }

    private static State _processSequence(State S, List particles) {
        State n = S;
        ListIterator reverseIter = particles.listIterator(particles.size());
        while (reverseIter.hasPrevious()) {
            Object particle = reverseIter.previous();
            if (!(particle instanceof Particle)) continue;
            n = AutomataBuilder._processParticle(n, (Particle)particle);
        }
        return n;
    }

    private static State _processChoice(State S, List particles) {
        State b = AutomataBuilder._createState();
        ListIterator iter = particles.listIterator();
        while (iter.hasNext()) {
            Object particle = iter.next();
            if (!(particle instanceof Particle)) continue;
            State n = AutomataBuilder._processParticle(S, (Particle)particle);
            AutomataBuilder._createLambdaTransition(b, n);
        }
        return b;
    }

    private static State _processAll(State S, List particles) {
        State t = AutomataBuilder._createState();
        State b = AutomataBuilder._processChoice(t, particles);
        AutomataBuilder._createLambdaTransition(t, b);
        AutomataBuilder._createLambdaTransition(b, S);
        return b;
    }

    private static State _processElementDef(State S, ElementDef elementDef) {
        State b = AutomataBuilder._createState();
        AutomataBuilder._createTransition(b, S, elementDef);
        return b;
    }

    private static State _processWildcard(State S, Wildcard wildcard) {
        State b = AutomataBuilder._createState();
        AutomataBuilder._createTransition(b, S, wildcard);
        return b;
    }

    private static Transition _createTransition(State fromState, State toState, ElementDef elementDef) {
        ElementDefTransition trans = new ElementDefTransition(fromState, toState, elementDef);
        fromState.addTransitionFromState(trans);
        toState.addTransitionToState(trans);
        return trans;
    }

    private static Transition _createTransition(State fromState, State toState, Wildcard wildcard) {
        WildcardTransition trans = new WildcardTransition(fromState, toState, wildcard);
        fromState.addTransitionFromState(trans);
        toState.addTransitionToState(trans);
        return trans;
    }

    private static final Transition _createLambdaTransition(State fromState, State toState) {
        LambdaTransition trans = new LambdaTransition(fromState, toState);
        fromState.addTransitionFromState(trans);
        toState.addTransitionToState(trans);
        return trans;
    }

    private static final State _createState() {
        return AutomataBuilder._createState(false);
    }

    private static final State _createState(boolean isFinalState) {
        if (isFinalState) {
            return new FinalState();
        }
        return new State();
    }

    private static final Transition _cloneTransition(Transition t, State fromState, State toState) {
        Transition newTransition = t.clone(fromState, toState);
        fromState.addTransitionFromState(newTransition);
        toState.addTransitionToState(newTransition);
        return newTransition;
    }

    private static State _convertToDFA(State initialNFAState) {
        Closure initialClosure = AutomataBuilder._computeClosure(initialNFAState);
        State initialDFAState = AutomataBuilder._createState(initialClosure.containsFinalState());
        HashMap<Closure, State> closureToDFAState = new HashMap<Closure, State>();
        HashMap<State, Closure> dfaStateToClosure = new HashMap<State, Closure>();
        closureToDFAState.put(initialClosure, initialDFAState);
        dfaStateToClosure.put(initialDFAState, initialClosure);
        LinkedList<State> unmarkedStates = new LinkedList<State>();
        unmarkedStates.addFirst(initialDFAState);
        while (!unmarkedStates.isEmpty()) {
            State dfaState = (State)unmarkedStates.removeFirst();
            Closure closure = (Closure)dfaStateToClosure.get(dfaState);
            for (Transition t : closure.getNonLambdaTransitions()) {
                Closure toStateClosure = AutomataBuilder._computeClosure(t.getToState());
                State nextDFAState = (State)closureToDFAState.get(toStateClosure);
                if (nextDFAState == null) {
                    nextDFAState = AutomataBuilder._createState(toStateClosure.containsFinalState());
                    closureToDFAState.put(toStateClosure, nextDFAState);
                    dfaStateToClosure.put(nextDFAState, toStateClosure);
                    unmarkedStates.addFirst(nextDFAState);
                }
                AutomataBuilder._cloneTransition(t, dfaState, nextDFAState);
            }
        }
        return initialDFAState;
    }

    private static Closure _computeClosure(State nfaState) {
        HashSet lambdaStates = new HashSet();
        ArrayList nonLambdaTransitions = new ArrayList();
        AutomataBuilder._fillClosureSet(lambdaStates, nonLambdaTransitions, nfaState);
        return new Closure(lambdaStates, nonLambdaTransitions);
    }

    private static void _fillClosureSet(Set lambdaStates, List nonLambdaTransitions, State nfaState) {
        if (!lambdaStates.contains(nfaState)) {
            lambdaStates.add(nfaState);
            List transFromState = nfaState.getTransitionsFromState();
            for (Transition t : transFromState) {
                if (t instanceof LambdaTransition) {
                    AutomataBuilder._fillClosureSet(lambdaStates, nonLambdaTransitions, t.getToState());
                    continue;
                }
                nonLambdaTransitions.add(t);
            }
        }
    }

    private static class Closure {
        private Set _lambdaStates = null;
        private List _nonLambdaTransitions = null;
        private int _hashcode = -1;

        public Closure(Set lambdaStates, List nonLambdaTransitions) {
            this._lambdaStates = Collections.unmodifiableSet(lambdaStates);
            this._nonLambdaTransitions = Collections.unmodifiableList(nonLambdaTransitions);
            this._hashcode = ((Object)this._lambdaStates).hashCode();
        }

        public Set getLambdaStates() {
            return this._lambdaStates;
        }

        public List getNonLambdaTransitions() {
            return this._nonLambdaTransitions;
        }

        public boolean containsFinalState() {
            for (State state : this._lambdaStates) {
                if (!state.isFinalState()) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this._hashcode;
        }

        public boolean equals(Object obj) {
            boolean objectsEqual = false;
            if (obj != null && obj instanceof Closure) {
                Closure test = (Closure)obj;
                if (this.hashCode() == test.hashCode()) {
                    objectsEqual = ((Object)this.getLambdaStates()).equals(test.getLambdaStates());
                }
            }
            return objectsEqual;
        }
    }
}

