/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.propertyTable;

import java.awt.event.MouseEvent;
import oracle.bali.dbUI.propertyTable.PropertyTable;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.HeaderMoveAdapter;
import oracle.bali.ewt.header.HeaderMoveListener;
import oracle.bali.ewt.header.NullInputHandler;
import oracle.bali.ewt.model.Sortable;

class SortHandler
extends NullInputHandler {
    private HeaderMoveAdapter _moveListener;
    private PropertyTable _parent;
    private Sortable _sortable;
    private boolean[] _decending;
    private boolean _armed;
    private int _item;
    private int _lastItemSorted;

    public SortHandler(PropertyTable parent, Sortable sortable) {
        this._parent = parent;
        this._sortable = sortable;
        this._lastItemSorted = -1;
        this._item = -1;
        this._moveListener = new ML();
    }

    public void sort(int item) {
        if (this._decending == null) {
            this._decending = new boolean[this._parent.getColumnHeader().getItemCount()];
        }
        if (this._lastItemSorted == item) {
            this._decending[item] = !this._decending[item];
        }
        this._sortable.sort(item, !this._decending[item]);
        this._lastItemSorted = item;
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
        header.addMoveListener((HeaderMoveListener)this._moveListener);
        this._armed = true;
        this._item = itemIndex;
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
        header.removeMoveListener((HeaderMoveListener)this._moveListener);
        if (!e.isPopupTrigger() && this._item == itemIndex && this._armed && this._pointInItem(header, itemIndex, e.getX(), e.getY()) && !this._parent.fireCancelablePropertyTableEvent(itemIndex)) {
            this._parent.getGrid().commitCellEdit();
            this.sort(itemIndex);
            e.consume();
            this._parent.firePropertyTableEvent(itemIndex);
        }
        this._item = -1;
        this._armed = false;
    }

    void cancelSort() {
        this._item = -1;
    }

    private boolean _pointInItem(Header h, int item, int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        return x <= h.getItemSize(item) && y <= h.getSize().height;
    }

    private class ML
    extends HeaderMoveAdapter {
        private ML() {
        }

        public void itemMoving(HeaderEvent e) {
            SortHandler.this.cancelSort();
        }
    }
}

