/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import oracle.bali.dbUI.graph.ChildNodeDataSource;
import oracle.bali.dbUI.graph.Data;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeComponent;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.hGrid.HTwoDModel;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;

class NodeDataSource
extends AbstractTwoDModel
implements HTwoDModel,
Sortable {
    private Node _node;
    private Data[] _hdata;
    private int _rowCount;
    private int _sortedColumn = -1;
    private boolean _ascending = false;
    private NodeComponent _component;
    private Listener _listener;
    private boolean _subNodesFound;

    public static final int getPortCount(Node n) {
        if (n == null) {
            return 0;
        }
        int portCount = 0;
        int count = n.getPortCount();
        for (int i = 0; i < count; ++i) {
            ++portCount;
            Port p = n.getPort(i);
            if (!(p instanceof Node)) continue;
            portCount += NodeDataSource.getPortCount((Node)p);
        }
        return portCount;
    }

    public NodeDataSource(NodeComponent component) {
        this._component = component;
        this._listener = new Listener();
    }

    public Locale getLocale() {
        return LocaleUtils.getDefaultableLocale((Component)((Object)this.getComponent()));
    }

    public void dispose() {
        if (this._node != null) {
            this._removePortListeners(this._node);
        }
        this._node = null;
        int count = this._hdata == null ? 0 : this._hdata.length;
        for (int i = 0; i < count; ++i) {
            this._hdata[i].dispose();
            this._hdata[i] = null;
        }
        this._hdata = null;
    }

    public NodeComponent getComponent() {
        return this._component;
    }

    public boolean isHGrid() {
        return this._subNodesFound;
    }

    public Node getNode() {
        return this._node;
    }

    public boolean isNodeExpanded(Node n) {
        int index = this.getPortIndex(n);
        if (index == -1) {
            return false;
        }
        ChildNodeDataSource cm = (ChildNodeDataSource)this._hdata[index];
        return cm.isExpanded();
    }

    public void setNodeExpanded(Node n, boolean expanded) {
        int index = this.getPortIndex(n);
        if (index != -1) {
            if (expanded) {
                this.expandRow(3, index);
            } else {
                this.collapseRow(3, index);
            }
        }
    }

    public int getPortIndex(Port p) {
        return NodeDataSource._getPortIndex(p, this._hdata, 0);
    }

    public void setNode(Node node) {
        if (this._node == node) {
            return;
        }
        int oldRowCount = this.getRowCount();
        if (oldRowCount != 0) {
            this.fireModelEvent(2005, 0, oldRowCount);
        }
        this.dispose();
        this._node = node;
        if (this._node != null) {
            this._addPortListeners(this._node);
        }
        int rowCount = NodeDataSource.getPortCount(this._node);
        this._hdata = new Data[rowCount];
        Object data = null;
        int portCount = node == null ? 0 : node.getPortCount();
        boolean nodeFound = false;
        int index = 0;
        Locale l = this.getLocale();
        int[] indicies = this.__calculateSortedIndicies(this.getNode());
        if (indicies == null) {
            for (int i = 0; i < portCount; ++i) {
                Port port = node.getPort(i);
                if (port instanceof Node) {
                    Node n = (Node)port;
                    index = this._addNode(n, this._hdata, index, 1, l);
                    nodeFound = true;
                    continue;
                }
                this._hdata[index] = new Data(port, l, 0);
                ++index;
            }
        } else {
            for (int i = 0; i < portCount; ++i) {
                int sortedIndex = indicies[i];
                Port port = node.getPort(sortedIndex);
                if (port instanceof Node) {
                    Node n = (Node)port;
                    index = this._addNode(n, this._hdata, index, 1, l);
                    nodeFound = true;
                    continue;
                }
                this._hdata[index] = new Data(port, l, 0);
                ++index;
            }
        }
        this._subNodesFound = nodeFound;
        this._rowCount = rowCount;
        if (rowCount != 0) {
            this.fireModelEvent(2004, 0, rowCount);
        }
    }

    public void sort(int column, boolean ascending) {
        this._sortedColumn = column;
        this._ascending = ascending;
        this._hdata = this._sortNode(this.getNode(), this._hdata);
        if (this._rowCount != 0) {
            this.fireModelEvent(2006, 0, this._rowCount);
        }
        this.getComponent().locationChanged();
        this.getComponent().__firePropertyChanged("sortedColumn", IntegerUtils.getInteger((int)-1), IntegerUtils.getInteger((int)column));
    }

    public void expandRow(int columnIndex, int rowIndex) {
        Data[] oldData = this._hdata;
        Data d = oldData[rowIndex];
        if (d.getClass() != ChildNodeDataSource.class) {
            return;
        }
        ChildNodeDataSource m = (ChildNodeDataSource)d;
        if (m.isExpanded()) {
            return;
        }
        int oldCount = oldData.length;
        Data[] children = m.getChildren();
        int childrenCount = children.length;
        int newCount = oldCount + childrenCount;
        Data[] newData = new Data[newCount];
        m.setExpanded(true, null);
        System.arraycopy(oldData, 0, newData, 0, rowIndex + 1);
        System.arraycopy(children, 0, newData, rowIndex + 1, childrenCount);
        int leftOver = oldCount - (rowIndex + 1);
        System.arraycopy(oldData, rowIndex + 1, newData, rowIndex + 1 + childrenCount, leftOver);
        this._hdata = newData;
        this._rowCount = this._hdata.length;
        Grid g = this.getComponent().getSpreadTable().getGrid();
        this.fireModelEvent(2004, rowIndex + 1, childrenCount);
        g.requestFocus(3, rowIndex, null);
        this.getComponent().__fireExpansionChanged(m.getNode(), true);
        this.getComponent().locationChanged();
    }

    public void collapseRow(int columnIndex, int rowIndex) {
        Data[] oldData = this._hdata;
        Data d = oldData[rowIndex];
        if (d.getClass() != ChildNodeDataSource.class) {
            return;
        }
        ChildNodeDataSource m = (ChildNodeDataSource)d;
        if (!m.isExpanded()) {
            return;
        }
        int rowRemovalStart = rowIndex + 1;
        int childrenCount = this._getChildCount(m, this._hdata, rowRemovalStart);
        Data[] children = new Data[childrenCount];
        System.arraycopy(this._hdata, rowRemovalStart, children, 0, childrenCount);
        m.setExpanded(false, children);
        int oldCount = oldData.length;
        int newCount = oldCount - childrenCount;
        Data[] newData = new Data[newCount];
        System.arraycopy(oldData, 0, newData, 0, rowIndex + 1);
        int leftOver = oldCount - rowRemovalStart - childrenCount;
        System.arraycopy(oldData, rowRemovalStart + childrenCount, newData, rowIndex + 1, leftOver);
        this._hdata = newData;
        this._rowCount = this._hdata.length;
        Grid g = this.getComponent().getSpreadTable().getGrid();
        this.fireModelEvent(2005, rowIndex + 1, childrenCount);
        g.requestFocus(3, rowIndex, null);
        this.getComponent().__fireExpansionChanged(m.getNode(), false);
        this.getComponent().locationChanged();
    }

    public int getColumnCount() {
        return 6;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public void setData(int column, int row, Object data) {
    }

    public Object getData(int column, int row) {
        if (this._node == null) {
            return null;
        }
        if (row >= this._rowCount) {
            return null;
        }
        Data d = this._hdata[row];
        Port port = d.getPort();
        switch (column) {
            case 0: {
                return port;
            }
            case 1: {
                return port.isTargetable() ? (this._isTargeted(port) ? this.getComponent().getTargetedImage(port) : this.getComponent().getTargetableImage(port)) : null;
            }
            case 2: {
                return port.isKey() ? this.getComponent().getKeyImage(port) : null;
            }
            case 3: {
                return d;
            }
            case 4: {
                return this.getComponent().getDataTypeImage(port, port.getDataType());
            }
            case 5: {
                return port.isSourceable() ? (this._isSourced(port) ? this.getComponent().getSourcedImage(port) : this.getComponent().getSourceableImage(port)) : null;
            }
        }
        return null;
    }

    void repaintRows(int start, int count) {
        if (count != 0) {
            this.fireModelEvent(2006, start, count);
        }
    }

    int[] __calculateSortedIndicies(Node n) {
        if (this._sortedColumn == -1 || n == null) {
            return null;
        }
        int portCount = n.getPortCount();
        Object[] ports = new Port[portCount];
        for (int i = 0; i < portCount; ++i) {
            ports[i] = n.getPort(i);
        }
        Comparator c = NodeComponent.__getComparator(this._sortedColumn, this._ascending, this.getLocale());
        return Sort.indirectQSort((Object[])ports, (int)portCount, (Comparator)c);
    }

    int[] __calculateSortedIndicies(Data[] array) {
        if (this._sortedColumn == -1) {
            int[] data = new int[array.length];
            for (int i = 0; i < data.length; ++i) {
                data[i] = i;
            }
            return data;
        }
        int count = array.length;
        Object[] ports = new Port[count];
        for (int i = 0; i < count; ++i) {
            ports[i] = array[i].getPort();
        }
        Comparator c = NodeComponent.__getComparator(this._sortedColumn, this._ascending, this.getLocale());
        return Sort.indirectQSort((Object[])ports, (int)count, (Comparator)c);
    }

    private static int _getPortIndex(Port p, Data[] array, int startIndex) {
        for (int i = startIndex; i < array.length; ++i) {
            if (!array[i].getPort().equals(p)) continue;
            return i;
        }
        return -1;
    }

    private void _updateBaseNode(int count, Port child) {
        int oldCount = this._hdata.length;
        this._hdata = this._getUpdatedArray(count, child, this._hdata, 0);
        int newCount = this._hdata.length;
        this._subNodesFound = this._findSubNode();
        this._rowCount += newCount - oldCount;
        if (newCount > oldCount) {
            int index = newCount - oldCount;
            this.fireModelEvent(2004, index, index);
        } else {
            this.fireModelEvent(2005, 0, oldCount - newCount);
        }
        this.getComponent().__updateUI();
    }

    private void _updateNode(Node node, int count, Port child) {
        if (node == this.getNode()) {
            this._updateBaseNode(count, child);
            return;
        }
        int index = this.getPortIndex(node);
        if (index != -1) {
            ChildNodeDataSource m = (ChildNodeDataSource)this._hdata[index];
            m.updatePortCount(count);
            if (m.isExpanded()) {
                int startIndex = index + 1;
                int arrayCount = this._getChildCount(m, this._hdata, startIndex);
                Data[] oldArray = new Data[arrayCount];
                System.arraycopy(this._hdata, startIndex, oldArray, 0, arrayCount);
                Data[] newArray = this._getUpdatedArray(count, child, oldArray, m.getDepth() + 1);
                int newCount = newArray.length;
                int oldCount = this._hdata.length;
                int diff = newCount - arrayCount;
                Data[] newHData = new Data[oldCount + diff];
                System.arraycopy(this._hdata, 0, newHData, 0, startIndex);
                System.arraycopy(newArray, 0, newHData, startIndex, newCount);
                System.arraycopy(this._hdata, startIndex + arrayCount, newHData, startIndex + newCount, oldCount - (startIndex + arrayCount));
                this._hdata = newHData;
                this._rowCount += diff;
                if (diff > 0) {
                    this.fireModelEvent(2004, index + arrayCount, diff);
                } else if (diff < 0) {
                    this.fireModelEvent(2005, index + arrayCount, -diff);
                }
            } else {
                Data[] oldArray = m.getChildren();
                Data[] newArray = this._getUpdatedArray(count, child, oldArray, m.getDepth() + 1);
                m.setExpanded(false, newArray);
            }
        }
    }

    private Data[] _getUpdatedArray(int count, Port child, Data[] array, int depth) {
        Data[] newData = null;
        if (count < 0) {
            int endIndex;
            int removalCount;
            int index = NodeDataSource._getPortIndex(child, array, 0);
            if (index == -1) {
                return array;
            }
            Data d = array[index];
            if (d.getClass() == ChildNodeDataSource.class) {
                ChildNodeDataSource m = (ChildNodeDataSource)d;
                removalCount = this._getChildCount(m, array, index + 1) + 1;
            } else {
                removalCount = 1;
            }
            d.dispose();
            int oldCount = array.length;
            newData = new Data[oldCount - removalCount];
            if (index != 0) {
                System.arraycopy(array, 0, newData, 0, index);
            }
            if ((endIndex = index + removalCount) != oldCount) {
                System.arraycopy(array, endIndex, newData, index, oldCount - endIndex);
            }
        } else if (count > 0) {
            if (child instanceof Node) {
                Node n = (Node)child;
                int portCount = NodeDataSource.getPortCount(n) + 1;
                Data[] children = new Data[portCount];
                int dummy = this._addNode(n, children, 0, depth, this.getLocale());
                int oldCount = array.length;
                newData = new Data[oldCount + portCount];
                System.arraycopy(array, 0, newData, 0, oldCount);
                System.arraycopy(children, 0, newData, oldCount, portCount);
            } else {
                Data d = new Data(child, this.getLocale(), depth);
                int oldCount = array.length;
                newData = new Data[oldCount + 1];
                System.arraycopy(array, 0, newData, 0, oldCount);
                newData[oldCount] = d;
            }
        }
        return newData;
    }

    private boolean _findSubNode() {
        for (int i = 0; i < this._hdata.length; ++i) {
            if (this._hdata[i].getClass() != ChildNodeDataSource.class) continue;
            return true;
        }
        return false;
    }

    private int _addNode(Node n, Data[] array, int index, int depth, Locale l) {
        ChildNodeDataSource model = new ChildNodeDataSource(this, n, depth);
        array[index] = model;
        ++index;
        int count = n.getPortCount();
        for (int i = 0; i < count; ++i) {
            Port p = model.getPort(i);
            if (p instanceof Node) {
                index = this._addNode((Node)p, array, index, depth + 1, l);
                continue;
            }
            array[index] = new Data(p, l, depth + 1);
            ++index;
        }
        return index;
    }

    private Data[] _sortNode(Node n, Data[] searchArray) {
        int childCount = n == null ? 0 : n.getPortCount();
        Data[] children = new Data[childCount];
        int rowCount = searchArray == null ? 0 : searchArray.length;
        Data[] sortedArray = new Data[rowCount];
        int childIndex = 0;
        for (int i = 0; i < rowCount; ++i) {
            children[childIndex++] = searchArray[i];
            if (searchArray[i].getClass() != ChildNodeDataSource.class) continue;
            ChildNodeDataSource m = (ChildNodeDataSource)searchArray[i];
            if (m.isExpanded()) {
                int portCount = this._getChildCount(m, searchArray, i + 1);
                Data[] childArray = new Data[portCount];
                System.arraycopy(searchArray, i + 1, childArray, 0, portCount);
                m.setSortedChildren(this._sortNode(m.getNode(), childArray));
                i += portCount;
                continue;
            }
            m.setSortedChildren(this._sortNode(m.getNode(), m.getChildren()));
        }
        int[] sortedIndex = this.__calculateSortedIndicies(children);
        int index = 0;
        for (int i = 0; i < childCount; ++i) {
            ChildNodeDataSource m;
            int realIndex = sortedIndex[i];
            Data child = children[realIndex];
            sortedArray[index++] = child;
            if (child.getClass() != ChildNodeDataSource.class || !(m = (ChildNodeDataSource)child).isExpanded()) continue;
            Data[] sortedChildren = m.getSortedChildren();
            for (int j = 0; j < sortedChildren.length; ++j) {
                sortedArray[index++] = sortedChildren[j];
            }
            m.setSortedChildren(null);
        }
        return sortedArray;
    }

    private int _getChildCount(ChildNodeDataSource m, Data[] array, int startIndex) {
        int count = 0;
        Node parent = m.getNode();
        for (int i = startIndex; i < array.length && this._isAncestor(parent, array[i].getPort()); ++i) {
            ++count;
        }
        return count;
    }

    private boolean _isAncestor(Node parent, Port child) {
        if (child == null) {
            return false;
        }
        if (child == parent) {
            return true;
        }
        return this._isAncestor(parent, child.getParent());
    }

    private void _addPortListeners(Port p) {
        p.addPropertyChangeListener(this._listener);
        if (p instanceof Node) {
            Node n = (Node)p;
            int count = n.getPortCount();
            for (int i = 0; i < count; ++i) {
                this._addPortListeners(n.getPort(i));
            }
        }
    }

    private void _removePortListeners(Port p) {
        p.removePropertyChangeListener(this._listener);
        if (p instanceof Node) {
            Node n = (Node)p;
            int count = n.getPortCount();
            for (int i = 0; i < count; ++i) {
                this._removePortListeners(n.getPort(i));
            }
        }
    }

    private boolean _isSourced(Port p) {
        return this.getComponent().getGraph() == null ? false : this.getComponent().getGraph().isSource(p);
    }

    private boolean _isTargeted(Port p) {
        return this.getComponent().getGraph() == null ? false : this.getComponent().getGraph().isTarget(p);
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Port p;
            if (NodeDataSource.this._component.isCreateMode()) {
                return;
            }
            String name = e.getPropertyName();
            Object oldValue = e.getOldValue();
            Object newValue = e.getNewValue();
            if ("portCount".equals(name)) {
                Port child;
                int diff;
                if (oldValue == null) {
                    NodeDataSource.this._addPortListeners((Port)newValue);
                } else if (newValue == null) {
                    NodeDataSource.this._removePortListeners((Port)oldValue);
                }
                if (oldValue == null) {
                    diff = 1;
                    child = (Port)newValue;
                } else {
                    diff = -1;
                    child = (Port)oldValue;
                }
                if (diff < 0) {
                    NodeDataSource.this.getComponent().__portRemoved(child);
                }
                Node n = (Node)e.getSource();
                NodeDataSource.this._updateNode(n, diff, child);
                NodeDataSource.this.getComponent().__invalidate();
            } else if (("targetable".equals(name) || "sourceable".equals(name) || "key".equals(name) || "dataType".equals(name) || "displayName".equals(name)) && (p = (Port)e.getSource()) != NodeDataSource.this._node) {
                int index = NodeDataSource.this.getPortIndex(p);
                if ("displayName".equals(name)) {
                    Data d = NodeDataSource.this._hdata[index];
                    d.updateData(NodeDataSource.this.getLocale());
                }
                NodeDataSource.this.repaintRows(index, 1);
            }
        }
    }
}

