/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.Port;

public class EdgeImpl
implements Edge {
    private Port _source;
    private Port _target;
    private String _tooltipText;
    private PropertyChangeSupport _propertyChangeSupport;

    public EdgeImpl(Port sourcePort, Port targetPort) {
        this(sourcePort, targetPort, null);
    }

    public EdgeImpl(Port sourcePort, Port targetPort, String tooltipText) {
        if (sourcePort == null || targetPort == null) {
            throw new IllegalArgumentException();
        }
        this._source = sourcePort;
        this._target = targetPort;
        this._tooltipText = tooltipText;
    }

    public int getSourcePortCount() {
        return 1;
    }

    public Port getSourcePort(int index) {
        return this._source;
    }

    public Port getTargetPort(int index) {
        return this._target;
    }

    public String getToolTipText() {
        return this._tooltipText;
    }

    public void setToolTipText(String text) {
        if (this._tooltipText != text) {
            String oldValue = this._tooltipText;
            this._tooltipText = text;
            this.firePropertyChange("toolTipText", oldValue, this._tooltipText);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
        }
    }
}

