/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerCacheSettings;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerEnvironmentSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerProcedureSettings;
import oracle.dbtools.listener.model.ListenerReportData;
import oracle.dbtools.listener.model.ListenerReportMessage;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.listener.model.ListenerURLMappings;
import oracle.dbtools.listener.utils.ListenerZipFileReader;
import oracle.javatools.dialogs.MessageDialog;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ListenerImportAdmin {
    private static ListenerImportAdmin _instance;
    private ListenerZipFileReader _zipRdr;
    private ListenerModel _model;
    private HashMap<String, String> _attributes;
    private Properties _globalProps;
    private HashMap<String, Properties> _dbSettingsProps;
    private HashMap<String, Properties> _restProps;
    private HashMap<String, ListenerURLMappings> _urlMaps;
    private boolean _isAdmin = false;

    public static synchronized ListenerImportAdmin getInstance() {
        if (_instance == null) {
            _instance = new ListenerImportAdmin();
        }
        return _instance;
    }

    public boolean importAdministration(File file, boolean bl) {
        return this.importAdministration(file.getAbsolutePath(), bl);
    }

    public boolean importAdministration(String string, boolean bl) {
        this._isAdmin = bl;
        boolean bl2 = false;
        if (this.initReader(string)) {
            bl2 = this.importAdministration();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importAdministration() {
        boolean bl = false;
        this._model = new ListenerModel();
        this.initialize();
        try {
            this.buildURLMappings();
            this.loadGlobalSettings();
            this.loadDBSettings();
            bl = true;
        }
        catch (Exception exception) {
            try {
                String string = ListenerArb.format("ADMIN_LOAD_ERROR", this._zipRdr.getName());
                MessageDialog.error(null, (Object)string, (String)ListenerArb.getString("ADMIN_LOAD_ERROR_TITLE"), null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            this.closeImport();
        }
        return bl;
    }

    public ListenerModel getModel() {
        return this._model;
    }

    public Properties getGlobalSettingsProperties() {
        return this._globalProps;
    }

    public Properties getDBSettingsProperties(String string) {
        return this._dbSettingsProps == null ? null : this._dbSettingsProps.get(string);
    }

    public Properties getRESTSettingsProperties(String string) {
        return this._restProps == null ? null : this._restProps.get(string);
    }

    private void loadGlobalSettings() throws InvalidPropertiesFormatException, IOException {
        InputStream inputStream = this._zipRdr.getInputStream(this._zipRdr.getGlobalSettingsZipEntry());
        this._globalProps = new Properties();
        this._globalProps.loadFromXML(inputStream);
        if (!this._globalProps.containsKey("sqldev.name")) {
            this._globalProps.setProperty("sqldev.name", ListenerArb.getString("ADMINISTRATION_DEFAULT_NAME"));
        }
        this.loadSettings(this._globalProps, this._model);
    }

    private void loadDBSettings() throws Exception {
        ArrayList<ZipEntry> arrayList = this._zipRdr.getDBSettingsZipEntryList();
        ArrayList<ListenerModel> arrayList2 = new ArrayList<ListenerModel>();
        for (ZipEntry zipEntry : arrayList) {
            InputStream inputStream = this._zipRdr.getInputStream(zipEntry);
            if (this._dbSettingsProps == null) {
                this._dbSettingsProps = new HashMap();
            }
            String string = zipEntry.getName();
            Properties properties = new Properties();
            properties.loadFromXML(inputStream);
            properties.setProperty("sqldev.name", this.getNameFromZipEntry(zipEntry.getName()));
            this._dbSettingsProps.put(string, properties);
            ListenerModel listenerModel = new ListenerModel();
            listenerModel = this._model.clone();
            this.loadSettings(properties, listenerModel);
            this.loadRESTUsers(listenerModel, "conf/" + listenerModel.getName());
            this.loadURLMappings(listenerModel);
            arrayList2.add(listenerModel);
        }
        if (!arrayList2.isEmpty()) {
            this._model.setChildren(arrayList2);
        }
    }

    private String getNameFromZipEntry(String string) {
        int n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        String string2 = string.substring(n + 1, string.lastIndexOf("."));
        return string2;
    }

    private void loadSettings(Properties properties, ListenerModel listenerModel) {
        if (properties.containsKey("sqldev.name")) {
            listenerModel.setName(properties.getProperty("sqldev.name"));
        }
        if (properties.containsKey("sqldev.description")) {
            listenerModel.setDescription(properties.getProperty("sqldev.description"));
        }
        this.loadConnectionSettings(properties, listenerModel);
        this.loadSecuritySettings(properties, listenerModel);
        this.loadCacheSettings(properties, listenerModel);
        this.loadProcedureSettings(properties, listenerModel);
        this.loadEnvironmentSettings(properties, listenerModel);
        this.loadReportSettings(properties, listenerModel);
    }

    private void loadConnectionSettings(Properties properties, ListenerModel listenerModel) {
        Enum enum_;
        String string;
        ListenerConnectionSettings listenerConnectionSettings = listenerModel.getConnectionSettings();
        if (properties.containsKey("db.username")) {
            listenerConnectionSettings.setUserName(properties.getProperty("db.username"));
        } else {
            listenerConnectionSettings.setUserName(null);
        }
        if (properties.containsKey("db.password")) {
            string = properties.getProperty("db.password");
            listenerConnectionSettings.setPassword(this.getPassword(string));
        }
        if (properties.containsKey("db.connectionType")) {
            string = properties.getProperty("db.connectionType");
            enum_ = ListenerConnectionSettings.CONNECTION_TYPES.BASIC;
            if (string.equals("tns")) {
                enum_ = ListenerConnectionSettings.CONNECTION_TYPES.TNS;
            } else if (string.equals("customurl")) {
                enum_ = ListenerConnectionSettings.CONNECTION_TYPES.ADVANCED;
            }
            listenerConnectionSettings.setConnectionType((ListenerConnectionSettings.CONNECTION_TYPES)enum_);
        }
        if (properties.containsKey("db.hostname")) {
            listenerConnectionSettings.setHost(properties.getProperty("db.hostname"));
        }
        if (properties.containsKey("db.port")) {
            listenerConnectionSettings.setPort(properties.getProperty("db.port"));
        }
        if (properties.containsKey("db.sid")) {
            listenerConnectionSettings.setSid(properties.getProperty("db.sid"));
        }
        if (properties.containsKey("db.servicename")) {
            listenerConnectionSettings.setServiceName(properties.getProperty("db.servicename"));
        }
        if (properties.containsKey("db.tnsAliasName")) {
            listenerConnectionSettings.setTNSAliasName(properties.getProperty("db.tnsAliasName"));
        }
        if (properties.containsKey("db.tnsDirectory")) {
            listenerConnectionSettings.setTNSAliasName(properties.getProperty("db.tnsDirectory"));
        }
        if (properties.containsKey("db.customURL")) {
            listenerConnectionSettings.setCustomJDBCURL(properties.getProperty("db.customURL"));
        }
        if (properties.containsKey("jdbc.DriverType")) {
            string = properties.getProperty("jdbc.DriverType");
            enum_ = ListenerConnectionSettings.JDBC_DRIVER_TYPES.THIN;
            if (string.equals("oci8")) {
                enum_ = ListenerConnectionSettings.JDBC_DRIVER_TYPES.OCI;
            }
            listenerConnectionSettings.setJDBCDriver((ListenerConnectionSettings.JDBC_DRIVER_TYPES)enum_);
        }
        if (properties.containsKey("jdbc.InitialLimit")) {
            listenerConnectionSettings.setInitialPoolSize(Integer.parseInt(properties.getProperty("jdbc.InitialLimit")));
        }
        if (properties.containsKey("jdbc.MinLimit")) {
            listenerConnectionSettings.setMinimumConnections(Integer.parseInt(properties.getProperty("jdbc.MinLimit")));
        }
        if (properties.containsKey("jdbc.MaxLimit")) {
            listenerConnectionSettings.setMaximumConnections(Integer.parseInt(properties.getProperty("jdbc.MaxLimit")));
        }
        if (properties.containsKey("jdbc.MaxStatementsLimit")) {
            listenerConnectionSettings.setMaximumStatements(Integer.parseInt(properties.getProperty("jdbc.MaxStatementsLimit")));
        }
        if (properties.containsKey("jdbc.InactivityTimeout")) {
            listenerConnectionSettings.setInactivityTimeout(Integer.parseInt(properties.getProperty("jdbc.InactivityTimeout")));
        }
        if (properties.containsKey("jdbc.statementTimeout")) {
            listenerConnectionSettings.setAbandonedConnectionTimeout(Integer.parseInt(properties.getProperty("jdbc.statementTimeout")));
        } else if (properties.containsKey("jdbc.AbandonedConnectionTimeout")) {
            listenerConnectionSettings.setAbandonedConnectionTimeout(Integer.parseInt(properties.getProperty("jdbc.AbandonedConnectionTimeout")));
        }
    }

    private void loadSecuritySettings(Properties properties, ListenerModel listenerModel) {
        ArrayList<String> arrayList;
        Object object;
        String string;
        ListenerSecuritySettings listenerSecuritySettings = listenerModel.getSecuritySettings();
        if (properties.containsKey("security.inclusionList") && (string = properties.getProperty("security.inclusionList")) != null) {
            object = string.split(",");
            arrayList = this.createList((String[])object);
            listenerSecuritySettings.setAllowedProcedures(arrayList);
        }
        if (properties.containsKey("security.exclusionList") && (string = properties.getProperty("security.exclusionList")) != null) {
            object = string.split(",");
            arrayList = this.createList((String[])object);
            listenerSecuritySettings.setBlockedProcedures(arrayList);
        }
        if (properties.containsKey("security.disableDefaultExclusionList")) {
            listenerSecuritySettings.setDisableExclusionList(Boolean.parseBoolean(properties.getProperty("security.disableDefaultExclusionList")));
        }
        if (properties.containsKey("security.validationFunctionType")) {
            string = properties.getProperty("security.validationFunctionType");
            object = ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE.PL_SQL;
            if (string.equals("javascript")) {
                object = ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE.JAVASCRIPT;
            }
            listenerSecuritySettings.setValidationFunctionType((ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE)((Object)object));
        }
        if (properties.containsKey("security.requestValidationFunction")) {
            listenerSecuritySettings.setValidationFunction(properties.getProperty("security.requestValidationFunction"));
        }
        if (properties.containsKey("security.verifySSL")) {
            listenerSecuritySettings.setVerifySSLRequests(Boolean.parseBoolean(properties.getProperty("security.verifySSL")));
        }
        if (properties.containsKey("icap.server")) {
            listenerSecuritySettings.setICAPServer(properties.getProperty("icap.server"));
        }
        if (properties.containsKey("icap.port")) {
            listenerSecuritySettings.setICAPPort(properties.getProperty("icap.port"));
        }
        if (properties.containsKey("security.maxEntries")) {
            listenerSecuritySettings.setMaximumCacheEntries(Integer.parseInt(properties.getProperty("security.maxEntries")));
        }
        if (properties.containsKey("security.totalEntries")) {
            listenerSecuritySettings.setTotalCacheEntries(Integer.parseInt(properties.getProperty("security.totalEntries")));
        }
    }

    private void loadCacheSettings(Properties properties, ListenerModel listenerModel) {
        Object object;
        String string;
        ListenerCacheSettings listenerCacheSettings = listenerModel.getCacheSettings();
        if (properties.containsKey("cache.procedureNameList") && (string = properties.getProperty("cache.procedureNameList")) != null) {
            object = string.split(",");
            ArrayList<String> arrayList = this.createList((String[])object);
            listenerCacheSettings.setCacheProcedures(arrayList);
        }
        if (properties.containsKey("cache.type")) {
            string = properties.getProperty("cache.type");
            object = ListenerCacheSettings.CACHE_TYPE.LRU;
            if (string.equals("expire")) {
                object = ListenerCacheSettings.CACHE_TYPE.EXPIRATION;
            }
            listenerCacheSettings.setCacheType((ListenerCacheSettings.CACHE_TYPE)((Object)object));
        }
        if (properties.containsKey("cache.expiration")) {
            listenerCacheSettings.setExpiration(Integer.parseInt(properties.getProperty("cache.expiration")));
        }
        if (properties.containsKey("cache.duration")) {
            string = properties.getProperty("cache.duration");
            object = ListenerCacheSettings.DURATION.DAYS;
            if (string.equals("hours")) {
                object = ListenerCacheSettings.DURATION.HOURS;
            } else if (string.equals("minutes")) {
                object = ListenerCacheSettings.DURATION.MINUTES;
            }
            listenerCacheSettings.setDuration((ListenerCacheSettings.DURATION)((Object)object));
        }
        if (properties.containsKey("cache.maxEntries")) {
            listenerCacheSettings.setMaxCacheEntries(Integer.parseInt(properties.getProperty("cache.maxEntries")));
        }
        if (properties.containsKey("cache.totalEntries")) {
            listenerCacheSettings.setTotalCacheEntries(Integer.parseInt(properties.getProperty("cache.totalEntries")));
        }
        if (properties.containsKey("cache.directory")) {
            listenerCacheSettings.setDirectory(properties.getProperty("cache.directory"));
        }
        if (properties.containsKey("cache.caching")) {
            listenerCacheSettings.setCaching(Boolean.parseBoolean(properties.getProperty("cache.caching")));
        }
    }

    private void loadProcedureSettings(Properties properties, ListenerModel listenerModel) {
        ArrayList<String> arrayList;
        String[] stringArray;
        String string;
        ListenerProcedureSettings listenerProcedureSettings = listenerModel.getProcedureSettings();
        if (properties.containsKey("procedure.preProcess") && (string = properties.getProperty("procedure.preProcess")) != null) {
            stringArray = string.split(",");
            arrayList = this.createList(stringArray);
            listenerProcedureSettings.setPreProcessProcedures(arrayList);
        }
        if (properties.containsKey("procedure.postProcess") && (string = properties.getProperty("procedure.postProcess")) != null) {
            stringArray = string.split(",");
            arrayList = this.createList(stringArray);
            listenerProcedureSettings.setPostProcessProcedures(arrayList);
        }
    }

    private void loadEnvironmentSettings(Properties properties, ListenerModel listenerModel) {
        ListenerEnvironmentSettings listenerEnvironmentSettings = listenerModel.getEnvironmentSettings();
        if (properties.containsKey("misc.defaultPage")) {
            listenerEnvironmentSettings.setDefaultWebPage(properties.getProperty("misc.defaultPage"));
        }
        if (properties.containsKey("apex.docTable")) {
            listenerEnvironmentSettings.setDocTable(properties.getProperty("apex.docTable"));
        }
        if (properties.containsKey("apex.extensions")) {
            listenerEnvironmentSettings.setExtensionClasses(properties.getProperty("apex.extensions"));
        }
    }

    private void loadReportSettings(Properties properties, ListenerModel listenerModel) {
        ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
        if (properties.containsKey("apex.excel2collection")) {
            listenerReportSettings.setCreateCollectionFromExcelFile(Boolean.parseBoolean(properties.getProperty("apex.excel2collection")));
        }
        if (properties.containsKey("apex.excel2collection.onecollection")) {
            listenerReportSettings.setPutWorkSheetsInOneCollection(Boolean.parseBoolean(properties.getProperty("apex.excel2collection.onecollection")));
        }
        if (properties.containsKey("apex.excel2collection.useSheetName")) {
            listenerReportSettings.setUseWorkSheetNameAsCollectionName(Boolean.parseBoolean(properties.getProperty("apex.excel2collection.useSheetName")));
        }
        if (properties.containsKey("apex.excel2collection.name")) {
            listenerReportSettings.setCollectionName(properties.getProperty("apex.excel2collection.name"));
        }
        if (properties.containsKey("debug.debugger")) {
            listenerReportSettings.setDebugging(Boolean.parseBoolean(properties.getProperty("debug.debugger")));
        }
        if (properties.containsKey("debug.printDebugToScreen")) {
            listenerReportSettings.setDisplayErrorMessages(Boolean.parseBoolean(properties.getProperty("debug.printDebugToScreen")));
        }
        if (properties.containsKey("log.logging")) {
            listenerReportSettings.setLogging(Boolean.parseBoolean(properties.getProperty("log.logging")));
        }
        if (properties.containsKey("log.maxEntries")) {
            listenerReportSettings.setMaxLogEntries(Integer.parseInt(properties.getProperty("log.maxEntries")));
        }
        if (properties.containsKey("log.totalEntries")) {
            listenerReportSettings.setTotalLogEntries(Integer.parseInt(properties.getProperty("log.totalEntries")));
        }
    }

    private void loadRESTUsers(ListenerModel listenerModel, String string) throws IOException {
        String string2;
        ListenerConnectionSettings listenerConnectionSettings = listenerModel.getConnectionSettings();
        String string3 = string + "_rt.xml";
        Properties properties = this.getRESTProperties(string3);
        if (properties != null) {
            if (this._restProps == null) {
                this._restProps = new HashMap();
            }
            this._restProps.put(string3, properties);
        }
        if (properties != null && properties.containsKey("db.password")) {
            string2 = properties.getProperty("db.password");
            listenerConnectionSettings.setRestPassword(this.getPassword(string2));
        }
        if ((properties = this.getRESTProperties(string2 = string + "_al.xml")) != null) {
            if (this._restProps == null) {
                this._restProps = new HashMap();
            }
            this._restProps.put(string2, properties);
        }
        if (properties != null && properties.containsKey("db.password")) {
            String string4 = properties.getProperty("db.password");
            listenerConnectionSettings.setListenerPassword(this.getPassword(string4));
        }
    }

    private Properties getRESTProperties(String string) throws IOException {
        ZipEntry zipEntry = this._zipRdr.getRESTUserZipEntry(string);
        if (zipEntry != null) {
            InputStream inputStream = this._zipRdr.getInputStream(zipEntry);
            Properties properties = new Properties();
            properties.loadFromXML(inputStream);
            return properties;
        }
        return null;
    }

    private void loadURLMappings(ListenerModel listenerModel) {
        ListenerURLMappings listenerURLMappings;
        if (this._urlMaps != null && !this._urlMaps.isEmpty() && (listenerURLMappings = this._urlMaps.get(listenerModel.getName())) != null) {
            listenerModel.setUrlMappings(listenerURLMappings);
        }
    }

    private void buildURLMappings() throws Exception {
        ZipEntry zipEntry = this._zipRdr.getURLMappingsZipEntry();
        if (zipEntry == null) {
            return;
        }
        this._attributes = new HashMap();
        this._urlMaps = new HashMap();
        SAXParser sAXParser = new SAXParser();
        ListenerURLMapReaderHandler listenerURLMapReaderHandler = new ListenerURLMapReaderHandler();
        sAXParser.setContentHandler((ContentHandler)listenerURLMapReaderHandler);
        sAXParser.setErrorHandler((ErrorHandler)listenerURLMapReaderHandler);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this._zipRdr.getInputStream(zipEntry)));
        sAXParser.parse(new InputSource(bufferedReader));
        if (bufferedReader != null) {
            bufferedReader.close();
        }
    }

    private String getPassword(String string) {
        String string2 = string;
        String string3 = "";
        if (!string2.isEmpty()) {
            if (string2.indexOf("!") == 0 && string2.length() > 1) {
                string3 = string2.substring(1);
            } else if (string2.indexOf("@") == 0 && string2.length() > 1) {
                string2 = string2.substring(1);
                string3 = Passwords.comingIn((String)string2);
            } else {
                string3 = string2;
            }
        }
        return string3;
    }

    private ArrayList<String> createList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean initReader(String string) {
        this._zipRdr = new ListenerZipFileReader();
        try {
            this._zipRdr.setEntriesFromZip(string);
            return true;
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            if (this._zipRdr != null) {
                try {
                    this._zipRdr.closeFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public void initialize() {
        this._globalProps = null;
        this._dbSettingsProps = null;
        this._restProps = null;
        this._urlMaps = null;
    }

    private void closeImport() {
        try {
            this._zipRdr.closeFile();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void setReportData(ListenerReportData listenerReportData) {
        if (this._model != null) {
            this._model.setReportData(listenerReportData);
        }
    }

    public void setErrorReport(List<ListenerReportMessage> list) {
        if (this._model != null) {
            this._model.getReportData().setErrors(list);
        }
    }

    public void setLogReport(List<ListenerReportMessage> list) {
        if (this._model != null) {
            this._model.getReportData().setLogs(list);
        }
    }

    class ListenerURLMapReaderHandler
    extends DefaultHandler {
        ListenerURLMapReaderHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!ListenerImportAdmin.this._attributes.isEmpty()) {
                ListenerImportAdmin.this._attributes.clear();
            }
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                ListenerImportAdmin.this._attributes.put(attributes.getLocalName(i), attributes.getValue(i));
            }
            if (string2.equals("pool")) {
                String string4 = (String)ListenerImportAdmin.this._attributes.get("name");
                String string5 = (String)ListenerImportAdmin.this._attributes.get("base-path");
                String string6 = (String)ListenerImportAdmin.this._attributes.get("base-url");
                String string7 = (String)ListenerImportAdmin.this._attributes.get("uri-pattern");
                String string8 = (String)ListenerImportAdmin.this._attributes.get("workspace-id");
                ListenerURLMappings.ROUTING_RULE_TYPE rOUTING_RULE_TYPE = null;
                String string9 = null;
                if (string5 != null) {
                    rOUTING_RULE_TYPE = ListenerURLMappings.ROUTING_RULE_TYPE.BASE_PATH;
                    string9 = string5;
                } else if (string6 != null) {
                    rOUTING_RULE_TYPE = ListenerURLMappings.ROUTING_RULE_TYPE.BASE_URL;
                    string9 = string6;
                } else if (string7 != null) {
                    rOUTING_RULE_TYPE = ListenerURLMappings.ROUTING_RULE_TYPE.REG_EXPR;
                    string9 = string7;
                }
                if (string9 != null) {
                    String string10 = string8 == null ? "" : string8;
                    ListenerURLMappings listenerURLMappings = (ListenerURLMappings)ListenerImportAdmin.this._urlMaps.get(string4);
                    if (listenerURLMappings == null) {
                        listenerURLMappings = new ListenerURLMappings();
                    }
                    listenerURLMappings.addURLPattern(rOUTING_RULE_TYPE, string9, string10);
                    ListenerImportAdmin.this._urlMaps.put(string4, listenerURLMappings);
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
        }
    }
}

