/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ListenerZipFileReader {
    private ZipFile _zipFile;
    private ZipEntry _globalSettingsZipEntry;
    private ZipEntry _urlMappingsZipEntry;
    private ZipEntry _reportsZipEntry;
    private ArrayList<ZipEntry> _dbSettingsZipEntryList = new ArrayList();
    private HashMap<String, ZipEntry> _restUsersZipEntryList = new HashMap();
    private ArrayList<String> _entries = new ArrayList();
    private int _totalZipEntries = 0;

    public void setEntriesFromZip(String string) throws IOException {
        this._zipFile = new ZipFile(string);
        this._totalZipEntries = 0;
        Enumeration<? extends ZipEntry> enumeration = this._zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry == null) continue;
            this.assignEntry(zipEntry);
        }
    }

    private void assignEntry(ZipEntry zipEntry) {
        if (zipEntry.getName().equals("defaults.xml")) {
            this.setGlobalSettingsZipEntry(zipEntry);
            this._entries.add(zipEntry.getName());
            ++this._totalZipEntries;
        } else if (zipEntry.getName().equals("url-mapping.xml")) {
            this.setURLMappingsZipEntry(zipEntry);
            this._entries.add(zipEntry.getName());
            ++this._totalZipEntries;
        } else if (zipEntry.getName().endsWith("listener_report.xml")) {
            this.setReportsZipEntry(zipEntry);
            this._entries.add(zipEntry.getName());
            ++this._totalZipEntries;
        } else if (zipEntry.getName().endsWith("_rt.xml") || zipEntry.getName().endsWith("_al.xml")) {
            this.addRESTUserZipEntry(zipEntry);
            this._entries.add(zipEntry.getName());
            ++this._totalZipEntries;
        } else if (zipEntry.getName().endsWith(".xml")) {
            this.addDBSettingsZipEntry(zipEntry);
            this._entries.add(zipEntry.getName());
            ++this._totalZipEntries;
        }
    }

    private void setGlobalSettingsZipEntry(ZipEntry zipEntry) {
        this._globalSettingsZipEntry = zipEntry;
    }

    public ZipEntry getGlobalSettingsZipEntry() {
        return this._globalSettingsZipEntry;
    }

    private void addDBSettingsZipEntry(ZipEntry zipEntry) {
        this._dbSettingsZipEntryList.add(zipEntry);
    }

    public ArrayList<ZipEntry> getDBSettingsZipEntryList() {
        return this._dbSettingsZipEntryList;
    }

    private void setURLMappingsZipEntry(ZipEntry zipEntry) {
        this._urlMappingsZipEntry = zipEntry;
    }

    public ZipEntry getURLMappingsZipEntry() {
        return this._urlMappingsZipEntry;
    }

    private void setReportsZipEntry(ZipEntry zipEntry) {
        this._reportsZipEntry = zipEntry;
    }

    public ZipEntry getReportsZipEntry() {
        return this._reportsZipEntry;
    }

    private void addRESTUserZipEntry(ZipEntry zipEntry) {
        if (this._restUsersZipEntryList == null) {
            this._restUsersZipEntryList = new HashMap();
        }
        this._restUsersZipEntryList.put(zipEntry.getName(), zipEntry);
    }

    public HashMap<String, ZipEntry> getRESTUserZipEntryList() {
        return this._restUsersZipEntryList;
    }

    public ZipEntry getRESTUserZipEntry(String string) {
        ZipEntry zipEntry = null;
        for (String string2 : this._restUsersZipEntryList.keySet()) {
            if (!string2.endsWith(string)) continue;
            zipEntry = this._restUsersZipEntryList.get(string2);
            return zipEntry;
        }
        return null;
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (this._zipFile != null) {
            return this._zipFile.getInputStream(zipEntry);
        }
        return null;
    }

    public void closeFile() throws IOException {
        if (this._zipFile != null) {
            this._zipFile.close();
        }
    }

    public String getName() throws IOException {
        String string = "";
        if (this._zipFile != null) {
            string = this._zipFile.getName();
        }
        return string;
    }

    public int getTotalZipEntries() {
        return this._totalZipEntries;
    }
}

