/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.listener.model.ListenerReportData;
import oracle.dbtools.listener.model.ListenerReportMessage;
import oracle.dbtools.raptor.cloud.connection.JSONUtils;
import oracle.dbtools.rt.json.JSONArray;
import oracle.dbtools.rt.json.JSONObject;
import oracle.dbtools.rt.json.JSONValue;

public class ListenerReportsUtils {
    public ListenerReportData getReportData(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        ListenerReportData listenerReportData = new ListenerReportData();
        try {
            listenerReportData.addValue("report_time", JSONUtils.getValue((JSONObject)jSONObject, (String)"report_time"));
            listenerReportData.addValue("uptime", JSONUtils.getValue((JSONObject)jSONObject, (String)"uptime"));
            listenerReportData.addValue("pages_served", JSONUtils.getValue((JSONObject)jSONObject, (String)"pages_served"));
            listenerReportData.addValue("bytes_sent", JSONUtils.getValue((JSONObject)jSONObject, (String)"bytes_sent"));
            listenerReportData.addValue("total_errors", JSONUtils.getValue((JSONObject)jSONObject, (String)"total_errors"));
            listenerReportData.addValue("total_files", JSONUtils.getValue((JSONObject)jSONObject, (String)"total_files"));
            listenerReportData.addValue("security_cache_size", JSONUtils.getValue((JSONObject)jSONObject, (String)"security_cache_size"));
            listenerReportData.addValue("security_cache_max_entries", JSONUtils.getValue((JSONObject)jSONObject, (String)"security_cache_max_entries"));
            listenerReportData.addValue("cache_size", JSONUtils.getValue((JSONObject)jSONObject, (String)"cache_size"));
            listenerReportData.addValue("cache_max_entries", JSONUtils.getValue((JSONObject)jSONObject, (String)"cache_max_entries"));
            listenerReportData.addValue("active_requests", JSONUtils.getValue((JSONObject)jSONObject, (String)"active_requests"));
            JSONObject jSONObject2 = (JSONObject)JSONUtils.getValue((JSONObject)jSONObject, (String)"total_times");
            HashMap<String, Object> hashMap = this.getTimes("total_times", jSONObject2);
            listenerReportData.addTimings("total_times", hashMap);
            jSONObject2 = (JSONObject)JSONUtils.getValue((JSONObject)jSONObject, (String)"db_times");
            hashMap = this.getTimes("db_times", jSONObject2);
            listenerReportData.addTimings("db_times", hashMap);
            return listenerReportData;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private HashMap<String, Object> getTimes(String string, JSONObject jSONObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("total", (Long)JSONUtils.getValue((JSONObject)jSONObject, (String)"total"));
        long l = ((Double)JSONUtils.getValue((JSONObject)jSONObject, (String)"minimum")).longValue();
        hashMap.put("minimum", new Long(l));
        l = ((Double)JSONUtils.getValue((JSONObject)jSONObject, (String)"average")).longValue();
        hashMap.put("average", new Long(l));
        l = ((Double)JSONUtils.getValue((JSONObject)jSONObject, (String)"median")).longValue();
        hashMap.put("median", new Long(l));
        l = ((Double)JSONUtils.getValue((JSONObject)jSONObject, (String)"maximum")).longValue();
        hashMap.put("maximum", new Long(l));
        return hashMap;
    }

    public List<ListenerReportMessage> getErrorReport(JSONObject jSONObject) {
        ArrayList<ListenerReportMessage> arrayList = new ArrayList<ListenerReportMessage>();
        JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
        for (JSONValue jSONValue : jSONArray.values()) {
            JSONObject jSONObject2 = (JSONObject)jSONValue.value();
            ListenerReportMessage listenerReportMessage = new ListenerReportMessage((String)JSONUtils.getValue((JSONObject)jSONObject2, (String)"time_stamp"), (String)JSONUtils.getValue((JSONObject)jSONObject2, (String)"message"));
            arrayList.add(listenerReportMessage);
        }
        return arrayList;
    }

    public List<ListenerReportMessage> getLogReport(JSONObject jSONObject) {
        ArrayList<ListenerReportMessage> arrayList = new ArrayList<ListenerReportMessage>();
        JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
        for (JSONValue jSONValue : jSONArray.values()) {
            JSONObject jSONObject2 = (JSONObject)jSONValue.value();
            ListenerReportMessage listenerReportMessage = new ListenerReportMessage((String)JSONUtils.getValue((JSONObject)jSONObject2, (String)"message"));
            arrayList.add(listenerReportMessage);
        }
        return arrayList;
    }
}

