/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.dbtools.listener.ui.ListenerUIUtils;

public class ListenerTextHandler
implements DocumentListener {
    private JTextComponent _textComponent;
    private Color _origBGColor;
    private Color _globalBGColor;
    private String _globalValue;
    private boolean _isGlobalDisplay = true;

    public ListenerTextHandler(JTextComponent jTextComponent, String string) {
        this._textComponent = jTextComponent;
        this._origBGColor = new Color(jTextComponent.getBackground().getRGB());
        this._globalBGColor = ListenerUIUtils.getHighlightBackgroundColor();
        this._globalValue = string;
        this.updateTextField(this._textComponent.getText());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        try {
            if (this.checkHighlighter(documentEvent)) {
                this.updateTextField(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        try {
            if (this.checkHighlighter(documentEvent)) {
                this.updateTextField(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        try {
            if (this.checkHighlighter(documentEvent)) {
                this.updateTextField(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
        }
    }

    public void updateGlobalValue(String string) {
        if (this._globalValue != string || !this._globalValue.equals(string)) {
            this._globalValue = string;
            this.updateTextField(this._textComponent.getText());
            this._textComponent.revalidate();
            this._textComponent.repaint();
        }
    }

    private void updateTextField(String string) {
        if (this.compareEmptyValue(string) || string == this._globalValue || string.equals(this._globalValue)) {
            this._textComponent.setBackground(this._globalBGColor);
            this._isGlobalDisplay = true;
        } else if (this._isGlobalDisplay) {
            this._textComponent.setBackground(this._origBGColor);
            this._isGlobalDisplay = false;
        }
    }

    private boolean compareEmptyValue(String string) {
        return !(string != null && !string.isEmpty() || this._globalValue != null && !this._globalValue.isEmpty());
    }

    private boolean checkHighlighter(DocumentEvent documentEvent) {
        try {
            if (this._isGlobalDisplay || this._globalValue != null && documentEvent.getDocument().getLength() == this._globalValue.length() || this.compareEmptyValue(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()))) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
        }
        return false;
    }
}

