/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.dbtools.listener.ListenerController;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerTreePanel;
import oracle.ide.controls.Toolbar;

public class ListenerPanel
extends JPanel {
    private static ListenerPanel _instance;
    private Toolbar _toolbar;
    private ListenerTreePanel _treePanel;
    private boolean _init = false;

    public ListenerPanel() {
        super(new GridBagLayout());
    }

    public static synchronized ListenerPanel getInstance() {
        if (_instance == null) {
            _instance = new ListenerPanel();
        }
        return _instance;
    }

    public void init() {
        if (!this._init) {
            this._init = true;
            this._toolbar = new Toolbar();
            ListenerController.getInstance().installToolbar(this.getToolbar());
            this._treePanel = new ListenerTreePanel();
            ListenerController.getInstance().attachTreeToMouseListener(this._treePanel.getTree());
            this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._treePanel, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        }
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void updateToolbar() {
        this._toolbar.revalidate();
        this._toolbar.repaint();
    }

    public void newAdministration(ListenerModel listenerModel) {
        if (this._treePanel != null) {
            this._treePanel.newAdministration(listenerModel);
        }
    }

    public void loadAdministration(ListenerModel listenerModel, boolean bl) {
        if (this._treePanel != null) {
            this._treePanel.loadAdministration(listenerModel, bl);
        }
    }

    public void loadReports(ListenerModel listenerModel) {
        if (this._treePanel != null) {
            this._treePanel.loadReports(listenerModel);
        }
    }

    public void newDBSettings(ListenerModel listenerModel) {
        if (this._treePanel != null) {
            this._treePanel.newDBSettings(listenerModel, false);
        }
    }

    public void removeDBSettings(int n) {
        if (this._treePanel != null) {
            this._treePanel.removeDBSettings(n);
        }
    }

    public ListenerModel updateGlobalSettingsValues() {
        if (this._treePanel != null) {
            return this._treePanel.getGlobalSettingsUIValues();
        }
        return null;
    }

    public ListenerModel updateGlobalSettingsValues(String string) {
        if (this._treePanel != null) {
            return this._treePanel.getGlobalSettingsUIValues(string);
        }
        return null;
    }

    public ArrayList<String> getSettingNames() {
        if (this._treePanel != null) {
            return this._treePanel.getSettingNames();
        }
        return null;
    }

    public ListenerModel getAllSettingsValues() {
        if (this._treePanel != null) {
            return this._treePanel.getAllSettingsValues();
        }
        return null;
    }

    public boolean validateName() {
        if (this._treePanel != null) {
            return this._treePanel.validateName();
        }
        return false;
    }
}

