/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import oracle.dbtools.listener.ui.ListenerUIUtils;

public class ListenerCheckBoxHandler
implements ItemListener {
    private JCheckBox _cb;
    private Color _origBGColor;
    private Color _globalBGColor;
    private boolean _globalSelected;

    ListenerCheckBoxHandler(JCheckBox jCheckBox, boolean bl) {
        this._cb = jCheckBox;
        this._origBGColor = new Color(this._cb.getBackground().getRGB());
        this._globalBGColor = ListenerUIUtils.getHighlightBackgroundColor();
        this._globalSelected = bl;
        this.updateCheckBox(this._cb.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateCheckBox(this._cb.isSelected());
    }

    public void updateGlobalValue(boolean bl) {
        if (this._globalSelected != bl) {
            this._globalSelected = bl;
            this.updateCheckBox(this._cb.isSelected());
            this._cb.revalidate();
            this._cb.repaint();
        }
    }

    private void updateCheckBox(boolean bl) {
        if (bl == this._globalSelected) {
            this._cb.setBackground(this._globalBGColor);
        } else {
            this._cb.setBackground(this._origBGColor);
        }
    }
}

