/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerNewAdminDialog;
import oracle.dbtools.listener.ui.ListenerNewDBSettingsDialog;
import oracle.dbtools.listener.ui.ListenerNodeInfo;
import oracle.dbtools.listener.ui.ListenerPanel;
import oracle.dbtools.listener.ui.ListenerValidateDialog;
import oracle.dbtools.listener.utils.ListenerConnection;
import oracle.dbtools.listener.utils.ListenerValidator;
import oracle.dbtools.listener.xml.ListenerExportAdmin;
import oracle.dbtools.listener.xml.ListenerImportAdmin;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class ListenerController
implements Controller,
ActionListener {
    public static final WildcardURLFilter ZIP_FILTER = new WildcardURLFilter(ListenerArb.getString("ZIP_FILTER_MASK"), URLFileSystem.isLocalFileSystemCaseSensitive(), ListenerArb.getString("ZIP_FILTER_NAME"));
    public static final String UPLOAD_FILENAME = "confs.zip";
    public static int CONNECT_ACTION = Ide.findOrCreateCmdID((String)"listener_connect");
    public static int DISCONNECT_ACTION = Ide.findOrCreateCmdID((String)"listener_disconnect");
    public static int OPEN_FILE_ACTION = Ide.findOrCreateCmdID((String)"listener_fileopen");
    public static int SAVE_FILE_ACTION = Ide.findOrCreateCmdID((String)"listener_filesave");
    public static int NEW_ADMIN_ACTION = Ide.findOrCreateCmdID((String)"listener_newadmin");
    public static int RETRIEVE_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_retrieve");
    public static int UPLOAD_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_upload");
    public static int TEST_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_test");
    public static int NEW_DB_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_newdbsettings");
    public static int DEL_DB_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_deldbsettings");
    public static int LAUNCH_URL_ACTION = Ide.findOrCreateCmdID((String)"listener_launchurl");
    public static int REPORT_REFRESH_ACTION = Ide.findOrCreateCmdID((String)"listener_rptrefresh");
    private static ListenerController _instance;
    private IdeAction _connectAction;
    private IdeAction _disconnectAction;
    private IdeAction _newConnectAction;
    private IdeAction _editConnectionAction;
    private IdeAction _openAction;
    private IdeAction _saveAction;
    private IdeAction _newAdminAction;
    private IdeAction _retrieveAction;
    private IdeAction _uploadAction;
    private IdeAction _testAction;
    private IdeAction _newDBSettingsAction;
    private IdeAction _delDBSettingsAction;
    private IdeAction _launchURLAction;
    private IdeAction _rptRefreshAction;
    private boolean _isLoaded = false;
    private boolean _isConnected = false;
    private boolean _isPreserveSettings = false;
    private ListenerModel _model = null;
    private ListenerNodeInfo _lastSelectedNode;
    private File _lastUrl;
    private JLabel _connName;

    private ListenerController() {
        this.createActions();
    }

    public static synchronized ListenerController getInstance() {
        if (_instance == null) {
            _instance = new ListenerController();
        }
        return _instance;
    }

    private void createActions() {
        this._connectAction = this.getAction(CONNECT_ACTION, ListenerArb.getString("CONNECT_MENU_ITEM"), OracleIcons.getIcon((String)"apps_conn.png"), true);
        this._disconnectAction = this.getAction(DISCONNECT_ACTION, ListenerArb.getString("DISCONNECT_MENU_ITEM"), OracleIcons.getIcon((String)"apps_conn.png"), false);
        this._openAction = this.getAction(OPEN_FILE_ACTION, ListenerArb.getString("OPEN_FILE_LABEL"), OracleIcons.getIcon((String)"open.png"), true);
        this._saveAction = this.getAction(SAVE_FILE_ACTION, ListenerArb.getString("SAVE_FILE_LABEL"), OracleIcons.getIcon((String)"filesave.png"), false);
        this._newAdminAction = this.getAction(NEW_ADMIN_ACTION, ListenerArb.getString("NEW_ADMIN_LABEL"), OracleIcons.getIcon((String)"new.png"), true);
        this._retrieveAction = this.getAction(RETRIEVE_SETTINGS_ACTION, ListenerArb.getString("RETRIEVE_SETTINGS_LABEL"), RaptorImage.getIcon((String)"filedownload.png"), false);
        this._uploadAction = this.getAction(UPLOAD_SETTINGS_ACTION, ListenerArb.getString("UPLOAD_SETTINGS_LABEL"), OracleIcons.getIcon((String)"file_upload.png"), false);
        this._testAction = this.getAction(TEST_SETTINGS_ACTION, ListenerArb.getString("TEST_SETTINGS_LABEL"), RaptorImage.getIcon((String)"test_report.png"), false);
        this._newDBSettingsAction = this.getAction(NEW_DB_SETTINGS_ACTION, ListenerArb.getString("NEW_DB_SETTINGS_MENU_ITEM"), OracleIcons.getIcon((String)"new.png"), true);
        this._delDBSettingsAction = this.getAction(DEL_DB_SETTINGS_ACTION, ListenerArb.getString("DEL_DB_SETTINGS_MENU_ITEM"), OracleIcons.getIcon((String)"delete.png"), true);
        this._launchURLAction = this.getAction(LAUNCH_URL_ACTION, ListenerArb.getString("LAUNCH_URL_LABEL"), RaptorImage.getIcon((String)"externalurl.png"), false);
        this._rptRefreshAction = this.getAction(REPORT_REFRESH_ACTION, ListenerArb.getString("REFRESH_REPORT_MENU_ITEM"), OracleIcons.getIcon((String)"refresh.png"), false);
    }

    private IdeAction getAction(int n, String string, Icon icon, boolean bl) {
        IdeAction ideAction = IdeAction.get((int)n, null, (String)string, null, null, (Icon)icon, null, (boolean)bl);
        ideAction.addController((Controller)this);
        return ideAction;
    }

    private String getDirectory() {
        String string = DBConfig.getInstance().getString("EXPORTDIR") + File.separator;
        if (string == null || string.isEmpty()) {
            string = System.getProperty("user.home");
        }
        return string;
    }

    public void installToolbar(Toolbar toolbar) {
        JComponent jComponent = (JComponent)this._newAdminAction.getValue("BUTTON");
        jComponent = toolbar.add((ToggleAction)this._newAdminAction);
        jComponent.setName(this._newAdminAction.getValue("Name").toString());
        this._newAdminAction.putValue("BUTTON", (Object)jComponent);
        toolbar.addSeparator();
        JComponent jComponent2 = (JComponent)this._openAction.getValue("BUTTON");
        jComponent2 = toolbar.add((ToggleAction)this._openAction);
        jComponent2.setName(this._openAction.getValue("Name").toString());
        this._openAction.putValue("BUTTON", (Object)jComponent2);
        JComponent jComponent3 = (JComponent)this._saveAction.getValue("BUTTON");
        jComponent3 = toolbar.add((ToggleAction)this._saveAction);
        jComponent3.setName(this._saveAction.getValue("Name").toString());
        this._saveAction.putValue("BUTTON", (Object)jComponent3);
        toolbar.addSeparator();
        JComponent jComponent4 = (JComponent)this._retrieveAction.getValue("BUTTON");
        jComponent4 = toolbar.add((ToggleAction)this._retrieveAction);
        jComponent4.setName(this._retrieveAction.getValue("Name").toString());
        this._retrieveAction.putValue("BUTTON", (Object)jComponent4);
        JComponent jComponent5 = (JComponent)this._uploadAction.getValue("BUTTON");
        jComponent5 = toolbar.add((ToggleAction)this._uploadAction);
        jComponent5.setName(this._uploadAction.getValue("Name").toString());
        this._uploadAction.putValue("BUTTON", (Object)jComponent5);
        toolbar.addSeparator();
        JComponent jComponent6 = (JComponent)this._testAction.getValue("BUTTON");
        jComponent6 = toolbar.add((ToggleAction)this._testAction);
        jComponent6.setName(this._testAction.getValue("Name").toString());
        this._testAction.putValue("BUTTON", (Object)jComponent6);
        toolbar.addSeparator();
        JComponent jComponent7 = (JComponent)this._launchURLAction.getValue("BUTTON");
        jComponent7 = toolbar.add((ToggleAction)this._launchURLAction);
        jComponent7.setName(this._launchURLAction.getValue("Name").toString());
        this._launchURLAction.putValue("BUTTON", (Object)jComponent7);
        toolbar.addSeparator();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        int n = 0;
        int n2 = 0;
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        this._connName = new JLabel();
        this._connName.setOpaque(false);
        this._connName.setText(ListenerArb.getString("NOT_CONNECTED"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._connName, (String)ListenerArb.getString("CONNECTION_LABEL"));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(n2, n, 1, 1, 1.0, 1.0, 25, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 25, 0, new Insets(0, 6, 0, 8), 0, 0));
        jPanel.add((Component)this._connName, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 25, 0, new Insets(0, 0, 0, 16), 0, 0));
        toolbar.add((Component)jPanel);
    }

    public void toggleActions() {
        this._connectAction.setEnabled(!this._isConnected);
        this._disconnectAction.setEnabled(this._isConnected);
        this._retrieveAction.setEnabled(this._isConnected);
        this._saveAction.setEnabled(this._isLoaded);
        this._testAction.setEnabled(this._isLoaded);
        this._uploadAction.setEnabled(this._isConnected && this._isLoaded);
        this._launchURLAction.setEnabled(this._isConnected && Desktop.isDesktopSupported());
        this._rptRefreshAction.setEnabled(this._isConnected && this._isLoaded);
        if (this._launchURLAction.isEnabled()) {
            this._launchURLAction.setName(ListenerArb.format("LAUNCH_URL_PATH", ListenerConnection.getInstance().getURI().toString()));
        } else {
            this._launchURLAction.setName(ListenerArb.getString("LAUNCH_URL_LABEL"));
        }
    }

    public void attachTreeToMouseListener(JTree jTree) {
        jTree.addMouseListener(new CustomTreeMouseListener());
    }

    public void listenerConnect() {
        this._isConnected = ListenerConnection.getInstance().connectToListener();
        if (this._isConnected) {
            this._connName.setText(ListenerConnection.getInstance().getConnectionName());
            boolean bl = true;
            if (this._model != null && this._isLoaded) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ListenerArb.getString("ADMIN_SETTINGS_CONNECT_RETRIEVE")).append(System.getProperty("line.separator")).append(ListenerArb.getString("ADMIN_SETTINGS_CONTINUE"));
                bl = MessageDialog.confirm(null, (Object)stringBuffer, (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
            }
            if (bl) {
                this.retrieveSettings();
            }
        }
        this.toggleActions();
    }

    public void listenerDisconnect() {
        ListenerConnection.getInstance().disconnectFromListener();
        this._isConnected = false;
        this._connName.setText(ListenerArb.getString("NOT_CONNECTED"));
        this.toggleActions();
    }

    public void openFileDialog() {
        int n;
        CharSequence charSequence;
        if (this._model != null && this._isLoaded) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(ListenerArb.getString("ADMIN_SETTINGS_OPEN")).append(System.getProperty("line.separator")).append(ListenerArb.getString("ADMIN_SETTINGS_CONTINUE"));
            n = MessageDialog.confirm(null, (Object)charSequence, (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
            if (n == 0) {
                return;
            }
        }
        if (this._lastUrl == null) {
            charSequence = DBConfig.getInstance().getString("IMPORTDIR") + File.separator;
            if (charSequence == null || ((String)charSequence).equals("")) {
                charSequence = System.getProperty("user.home");
            }
            this._lastUrl = new File((String)charSequence);
        }
        charSequence = new URLFileChooser(this._lastUrl);
        charSequence.clearChooseableURLFilters();
        charSequence.setURLFilter((URLFilter)ZIP_FILTER);
        charSequence.setSelectionScope(2);
        charSequence.setSelectionMode(0);
        charSequence.setShowJarsAsDirs(false);
        n = charSequence.showOpenDialog((Component)Ide.getMainWindow(), ListenerArb.getString("OPEN_ADMINISTRATION"));
        if (n == 0) {
            int n2;
            String string = charSequence.getSelectedFile().toString();
            String string2 = string.substring(n2 = string.lastIndexOf(File.separator));
            this._lastUrl = string2.lastIndexOf(".") > -1 ? charSequence.getSelectedFile() : new File(charSequence.getSelectedFile().toString() + ".zip");
            ListenerImportAdmin listenerImportAdmin = ListenerImportAdmin.getInstance();
            boolean bl = listenerImportAdmin.importAdministration(this._lastUrl, ListenerConnection.getInstance().isAdminRole());
            if (bl) {
                this._model = listenerImportAdmin.getModel();
                if (ListenerConnection.getInstance().isAdminRole()) {
                    ListenerPanel.getInstance().loadAdministration(this._model, ListenerConnection.getInstance().isAdminRole());
                } else {
                    ListenerPanel.getInstance().loadReports(this._model);
                }
                this._isLoaded = true;
                this._isPreserveSettings = true;
                this.toggleActions();
            }
        }
    }

    public void saveAdministrationDialog() {
        if (!ListenerPanel.getInstance().validateName()) {
            return;
        }
        if (this._lastUrl == null) {
            this._lastUrl = new File(this.getDirectory());
        }
        URLFileChooser uRLFileChooser = new URLFileChooser(this._lastUrl);
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setURLFilter((URLFilter)ZIP_FILTER);
        uRLFileChooser.setSelectionScope(2);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setShowJarsAsDirs(false);
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), ListenerArb.getString("SAVE_ADMINISTRATION"));
        if (n == 0) {
            int n2;
            String string = uRLFileChooser.getSelectedFile().toString();
            String string2 = string.substring(n2 = string.lastIndexOf(File.separator));
            this._lastUrl = string2.lastIndexOf(".") > -1 ? uRLFileChooser.getSelectedFile() : new File(uRLFileChooser.getSelectedFile().toString() + ".zip");
            this._model = ListenerPanel.getInstance().getAllSettingsValues();
            ListenerExportAdmin listenerExportAdmin = new ListenerExportAdmin(this._model);
            listenerExportAdmin.exportAdministration(this._lastUrl, null, this._isPreserveSettings);
        }
    }

    public void newAdministrationDialog() {
        Object object;
        if (this._model != null && this._isLoaded) {
            object = new StringBuffer();
            ((StringBuffer)object).append(ListenerArb.getString("ADMIN_SETTINGS_NEW")).append(System.getProperty("line.separator")).append(ListenerArb.getString("ADMIN_SETTINGS_CONTINUE"));
            boolean bl = MessageDialog.confirm(null, (Object)object, (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
            if (!bl) {
                return;
            }
        }
        if (((ListenerNewAdminDialog)(object = new ListenerNewAdminDialog(ListenerArb.getString("CREATE_ADMIN_SETTING")))).runDialog()) {
            this._model = new ListenerModel();
            ((ListenerNewAdminDialog)object).assignValues(this._model);
            ListenerPanel.getInstance().newAdministration(this._model);
            this._isLoaded = true;
            this._isPreserveSettings = false;
            this.toggleActions();
        }
    }

    public void retrieveSettingsDialog() {
        if (ListenerConnection.getInstance().isConnectionOpen()) {
            if (this._model != null && this._isLoaded) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ListenerArb.getString("ADMIN_SETTINGS_RETRIEVE")).append(System.getProperty("line.separator")).append(ListenerArb.getString("ADMIN_SETTINGS_CONTINUE"));
                boolean bl = MessageDialog.confirm(null, (Object)stringBuffer, (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
                if (!bl) {
                    return;
                }
            }
            this.retrieveSettings();
        }
    }

    private void retrieveSettings() {
        if (ListenerConnection.getInstance().retrieveSettings()) {
            this._model = ListenerImportAdmin.getInstance().getModel();
            ListenerConnection.getInstance().retrieveReports();
            ListenerPanel.getInstance().loadAdministration(this._model, ListenerConnection.getInstance().isAdminRole());
            this._isLoaded = true;
            this._isPreserveSettings = true;
            this.toggleActions();
        } else {
            this._isLoaded = false;
        }
    }

    public void uploadSettingsDialog() {
        if (this._model != null && ListenerConnection.getInstance().isConnectionOpen()) {
            boolean bl = MessageDialog.confirm(null, (Object)ListenerArb.getString("ADMIN_SETTINGS_UPLOAD"), (String)ListenerArb.getString("ADMIN_UPLOAD_TITLE"), null);
            if (!bl) {
                return;
            }
            this._model = ListenerPanel.getInstance().getAllSettingsValues();
            ListenerValidator listenerValidator = new ListenerValidator(this._model);
            if (listenerValidator.isValidDBSettings()) {
                URL uRL = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.sqldeveloper.listener");
                URL uRL2 = null;
                try {
                    uRL2 = URLFileSystem.createTempFile((String)"upload", (String)".zip", (URL)uRL);
                }
                catch (Exception exception) {
                    MessageDialog.error(null, (Object)exception.getLocalizedMessage(), (String)ListenerArb.getString("ADMIN_UPLOAD_TITLE"), null);
                    return;
                }
                ListenerExportAdmin listenerExportAdmin = new ListenerExportAdmin(this._model);
                listenerExportAdmin.exportAdministration(uRL2.getPath(), null, this._isPreserveSettings);
                boolean bl2 = ListenerConnection.getInstance().uploadSettings(uRL2);
                if (bl2) {
                    MessageDialog.information(null, (Object)ListenerArb.getString("UPLOAD_SUCCESSFUL"), (String)ListenerArb.getString("ADMIN_UPLOAD_TITLE"), null);
                }
                if (URLFileSystem.exists((URL)uRL2)) {
                    URLFileSystem.delete((URL)uRL2);
                }
            } else {
                MessageDialog.error(null, (Object)ListenerArb.getString("VALIDATE_DB_SETTINGS"), (String)ListenerArb.getString("ADMIN_UPLOAD_TITLE"), null);
            }
        }
    }

    public void testSettingsDialog() {
        this._model = ListenerPanel.getInstance().getAllSettingsValues();
        new ListenerValidateDialog(this._model);
    }

    public void newDBSettingsDialog() {
        this._model = ListenerPanel.getInstance().updateGlobalSettingsValues();
        ListenerNewDBSettingsDialog listenerNewDBSettingsDialog = new ListenerNewDBSettingsDialog(this._model);
        if (listenerNewDBSettingsDialog.runDialog()) {
            ListenerModel listenerModel = listenerNewDBSettingsDialog.getModel();
            ListenerPanel.getInstance().newDBSettings(listenerModel);
        }
    }

    public void removeDBSettingsDialog() {
        if (this._lastSelectedNode != null) {
            String string = this._lastSelectedNode.getName();
            String string2 = ListenerArb.format("DELETE_SETTINGS_CONFIRM", string);
            boolean bl = MessageDialog.confirm(null, (Object)string2, (String)ListenerArb.getString("DELETE_SETTINGS_TITLE"), null);
            if (bl) {
                ListenerPanel.getInstance().removeDBSettings(this._lastSelectedNode.getKey());
            }
        }
    }

    public void launchURL() {
        URI uRI = null;
        try {
            uRI = ListenerConnection.getInstance().getURI();
            if (uRI != null) {
                Desktop.getDesktop().browse(uRI);
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ListenerArb.format("LAUNCH_ERRORED", uRI.getPath()));
            stringBuffer.append(System.getProperty("line.separator")).append(exception.getLocalizedMessage());
            MessageDialog.error(null, (Object)stringBuffer.toString(), (String)ListenerArb.getString("LAUNCH_ERROR_TITLE"), null);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void refreshReports() {
        if (ListenerConnection.getInstance().isConnectionOpen()) {
            if (ListenerConnection.getInstance().retrieveReports()) {
                this._model = ListenerImportAdmin.getInstance().getModel();
                ListenerPanel.getInstance().loadReports(this._model);
                this._isLoaded = true;
                this._isPreserveSettings = true;
                this.toggleActions();
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ListenerArb.getString("ERROR_RETRIEVE_REPORTS")).append(System.getProperty("line.separator")).append(ListenerConnection.getInstance().getErrorMessage());
                MessageDialog.error(null, (Object)stringBuffer.toString(), (String)ListenerArb.getString("REPORTS_TITLE"), null);
                this._isLoaded = false;
            }
        }
    }

    public ListenerModel getGlobalSettingsValues() {
        this._model = ListenerPanel.getInstance().updateGlobalSettingsValues();
        return this._model;
    }

    public ListenerModel getGlobalSettingsValues(String string) {
        this._model = ListenerPanel.getInstance().updateGlobalSettingsValues(string);
        return this._model;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == CONNECT_ACTION) {
            this.listenerConnect();
            return true;
        }
        if (ideAction.getCommandId() == DISCONNECT_ACTION) {
            this.listenerDisconnect();
            return true;
        }
        if (ideAction.getCommandId() == NEW_ADMIN_ACTION) {
            this.newAdministrationDialog();
            return true;
        }
        if (ideAction.getCommandId() == OPEN_FILE_ACTION) {
            this.openFileDialog();
            return true;
        }
        if (ideAction.getCommandId() == SAVE_FILE_ACTION) {
            this.saveAdministrationDialog();
            return true;
        }
        if (ideAction.getCommandId() == RETRIEVE_SETTINGS_ACTION) {
            this.retrieveSettingsDialog();
            return true;
        }
        if (ideAction.getCommandId() == UPLOAD_SETTINGS_ACTION) {
            this.uploadSettingsDialog();
            return true;
        }
        if (ideAction.getCommandId() == TEST_SETTINGS_ACTION) {
            this.testSettingsDialog();
            return true;
        }
        if (ideAction.getCommandId() == NEW_DB_SETTINGS_ACTION) {
            this.newDBSettingsDialog();
            return true;
        }
        if (ideAction.getCommandId() == DEL_DB_SETTINGS_ACTION) {
            this.removeDBSettingsDialog();
            return true;
        }
        if (ideAction.getCommandId() == LAUNCH_URL_ACTION) {
            this.launchURL();
            return true;
        }
        return ideAction.getCommandId() == REPORT_REFRESH_ACTION;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private final class CustomTreeMouseListener
    extends MouseAdapter
    implements ContextMenuListener {
        private ContextMenu _contextMenu;
        private JMenuItem _connectMenuItem;
        private JMenuItem _disconnectMenuItem;
        private JMenuItem _newConnectMenuItem;
        private JMenuItem _editConnectMenuItem;
        private JMenuItem _newAdminMenuItem;
        private JMenuItem _openMenuItem;
        private JMenuItem _saveMenuItem;
        private JMenuItem _retrieveMenuItem;
        private JMenuItem _uploadMenuItem;
        private JMenuItem _testMenuItem;
        private JMenuItem _newDBSettingsMenuItem;
        private JMenuItem _delDBSettingsMenuItem;
        private JMenuItem _rptRefreshMenuItem;
        private String _nodeType;

        private CustomTreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                JTree jTree = null;
                if (!(mouseEvent.getSource() instanceof JTree)) {
                    return;
                }
                jTree = (JTree)mouseEvent.getSource();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                ListenerController.this._lastSelectedNode = (ListenerNodeInfo)defaultMutableTreeNode.getUserObject();
                this._nodeType = ListenerController.this._lastSelectedNode.getType();
                if (this._contextMenu == null) {
                    this._contextMenu = new ContextMenu();
                    this._contextMenu.addContextMenuListener((ContextMenuListener)this);
                    this._connectMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._connectAction);
                    this._disconnectMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._disconnectAction);
                    this._newConnectMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._newConnectAction);
                    this._editConnectMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._editConnectionAction);
                    this._newAdminMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._newAdminAction);
                    this._openMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._openAction);
                    this._saveMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._saveAction);
                    this._retrieveMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._retrieveAction);
                    this._uploadMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._uploadAction);
                    this._testMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._testAction);
                    this._newDBSettingsMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._newDBSettingsAction);
                    this._delDBSettingsMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._delDBSettingsAction);
                    this._rptRefreshMenuItem = this._contextMenu.createMenuItem((ToggleAction)ListenerController.this._rptRefreshAction);
                }
                Context context = Context.newIdeContext();
                context.setEvent((EventObject)mouseEvent);
                this._contextMenu.show(context);
            }
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (this._nodeType == null) {
                return;
            }
            contextMenu.removeAll();
            if (this._nodeType.equals("Listener")) {
                contextMenu.add((Component)this._newConnectMenuItem);
                contextMenu.add((Component)this._connectMenuItem);
                contextMenu.add((Component)this._disconnectMenuItem);
                contextMenu.add((Component)this._editConnectMenuItem);
                contextMenu.add((Component)this._newAdminMenuItem);
                contextMenu.add((Component)this._openMenuItem);
                contextMenu.add((Component)this._saveMenuItem);
                contextMenu.add((Component)this._retrieveMenuItem);
                contextMenu.add((Component)this._uploadMenuItem);
                contextMenu.add((Component)this._testMenuItem);
            } else if (this._nodeType.equals("DBSettings")) {
                contextMenu.add((Component)this._newDBSettingsMenuItem);
            } else if (this._nodeType.equals("DBSettingsName")) {
                contextMenu.add((Component)this._delDBSettingsMenuItem);
            } else if (this._nodeType.equals("Reports")) {
                contextMenu.add((Component)this._rptRefreshMenuItem);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }
    }
}

