/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.text.MessageFormat;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.plsql.TriggerDeclarator;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;

public class TriggerValidator
extends AbstractSchemaObjectValidator {
    private String m_errors = "";
    private boolean m_creatingTrigger;

    public TriggerValidator(DBObjectProvider prov) {
        super(prov);
    }

    public void validateObject(DBObject original, DBObject updated) throws ValidationException {
        this.m_creatingTrigger = original == null;
        super.validateObject(original, updated);
        if (updated instanceof Trigger) {
            this.validateTrigger((Trigger)updated);
        }
    }

    protected void validateTrigger(Trigger trg) throws ValidationException {
        Trigger.BaseType baseType = trg.getBaseType();
        DBObjectID[] columnIDs = trg.getColumnIDs();
        String[] events = trg.getEvents();
        Trigger.Timing timing = trg.getTiming();
        boolean statementLevel = trg.isStatementLevel();
        this.m_errors = "";
        TriggerDeclarator td = new TriggerDeclarator(this.getProvider());
        try {
            td.validateReferences(trg);
        }
        catch (ValidationException e) {
            this.throwOrLog(trg, e.getMessage());
        }
        if (baseType == null) {
            this.throwOrLog(trg, DBArb.getString((int)343));
        }
        block2: for (int i = 0; i < columnIDs.length; ++i) {
            for (int j = i + 1; j < columnIDs.length; ++j) {
                if (!columnIDs[i].equals(columnIDs[j])) continue;
                this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)352), DBUtil.getDBObjectName((DBObjectID)columnIDs[i])));
                continue block2;
            }
        }
        if (baseType == Trigger.BaseType.VIEW && timing != Trigger.Timing.INSTEAD_OF || baseType != Trigger.BaseType.VIEW && timing != Trigger.Timing.BEFORE && timing != Trigger.Timing.AFTER) {
            this.throwOrLog(trg, DBArb.getString((int)345));
        }
        if (!(statementLevel || baseType != Trigger.BaseType.DATABASE && baseType != Trigger.BaseType.SCHEMA)) {
            this.throwOrLog(trg, DBArb.getString((int)346));
        }
        String code = trg.getCode();
        String source = trg.getSource();
        code = code == null ? "" : code.trim();
        String string = source = source == null ? "" : source.trim();
        if (!source.endsWith(code)) {
            if (!this.m_creatingTrigger) {
                trg.setCode("");
                trg.setSource(trg.getSource());
            } else {
                this.throwOrLog(trg, DBArb.getString((int)353));
            }
        }
        if (events.length == 0) {
            this.throwOrLog(trg, DBArb.getString((int)350));
        }
        for (int i = 0; i < events.length; ++i) {
            boolean duplicate = false;
            for (int j = i + 1; j < events.length; ++j) {
                if (!events[i].equalsIgnoreCase(events[j])) continue;
                this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)349), events[i]));
                duplicate = true;
                break;
            }
            if (baseType == null || duplicate || Trigger.getEvents((Trigger.BaseType)baseType, (Trigger.Timing)timing).contains(events[i])) continue;
            this.throwOrLog(trg, MessageFormat.format(DBArb.getString((int)348), events[i]));
        }
        if (!this.m_errors.equals("")) {
            throw new ValidationException((DBObject)trg, this.m_errors);
        }
    }

    private void throwOrLog(Trigger trg, String message) throws ValidationException {
        if (this.m_creatingTrigger) {
            throw new ValidationException((DBObject)trg, message);
        }
        this.m_errors = this.m_errors + message + "\n";
    }
}

