/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.db.validators.RelationValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableValidator<T extends Table>
extends RelationValidator<T> {
    public TableValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={"indexes"})
    public void validateIndexes(Table original, Table updated) throws ValidationException {
        Index[] originalIndexes = null == original ? null : original.getIndexes();
        Index[] indexes = updated.getIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            DBObjectID id = DBUtil.getOriginalID((DBObject)indexes[i]);
            Index originalIndex = null;
            if (null != id && null != originalIndexes) {
                for (int j = 0; j < originalIndexes.length; ++j) {
                    if (!ModelUtil.areEqual((Object)id, (Object)originalIndexes[j].getID())) continue;
                    originalIndex = originalIndexes[j];
                    break;
                }
            }
            if (null == originalIndex) {
                this.getProvider().validateObject((DBObject)indexes[i]);
                continue;
            }
            this.getProvider().validateObject(originalIndex, (DBObject)indexes[i]);
        }
    }

    @AbstractValidator.PropertyValidator(value={"properties", "TableType"}, path=true)
    public void validateTableType(T original, T updated) throws ValidationException {
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType != Table.TableType.NORMAL) {
            throw new ValidationException(updated, DBArb.format((int)423, (Object)(tableType == null ? "" : tableType.toString())));
        }
    }
}

