/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationValidator<T extends Relation>
extends AbstractSchemaObjectValidator<T> {
    private static Map<String, String> s_postfixes = new HashMap<String, String>();

    public RelationValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={"constraints"})
    public void validateConstraints(T original, T updated) throws ValidationException {
        Constraint[] originalConstraints = null == original ? null : original.getConstraints();
        Constraint[] cons = updated.getConstraints();
        ConstraintValidator.validateOnePK(cons);
        for (int i = 0; i < cons.length; ++i) {
            Constraint con = cons[i];
            String cname = con.getName();
            if (cname == null) {
                if (this.createConstraintNameIfNone()) {
                    String newName = this.makeConstraintName(con, (Relation)updated);
                    newName = this.enforceChildNameUniqueInSchema((DBObject)con) ? this.getProvider().getUniqueName(con.getConstraintType(), (DBObject)DBUtil.getSchema((DBObject)con), newName) : this.getProvider().getUniqueName(con.getConstraintType(), (DBObject)con.getRelation(), newName);
                    con.setName(newName);
                } else {
                    throw new NameInUseException((DBObject)con);
                }
            }
            DBObjectID id = cons[i].getID();
            while (id != null && id instanceof TemporaryObjectID) {
                try {
                    DBObject originalObject = ((TemporaryObjectID)id).resolveOriginalID();
                    id = originalObject == null ? null : originalObject.getID();
                }
                catch (Exception e) {
                    DBLog.logStackTrace((Throwable)e);
                }
            }
            Constraint originalConstraint = null;
            if (null != id && null != originalConstraints) {
                for (int j = 0; j < originalConstraints.length; ++j) {
                    if (!ModelUtil.areEqual((Object)id, (Object)originalConstraints[j].getID())) continue;
                    originalConstraint = originalConstraints[j];
                    break;
                }
            }
            if (null == originalConstraint) {
                this.getProvider().validateObject((DBObject)con);
                continue;
            }
            this.getProvider().validateObject(originalConstraint, (DBObject)con);
        }
        if (original != null) {
            this.validateReferences();
        }
    }

    protected void validateReferences() throws ValidationException {
    }

    protected String makeConstraintName(Constraint con, Relation parent) {
        String base = parent.getName();
        String consType = con.getConstraintType();
        String postfix = s_postfixes.get(consType);
        int maxlen = 30 - postfix.length() - 2;
        if (base.length() > maxlen) {
            base = base.substring(0, maxlen);
        }
        return base + postfix;
    }

    private void addConstraintNames(Set names, Relation rel) throws ValidationException {
        Constraint[] cs = rel.getConstraints();
        for (int k = 0; k < cs.length; ++k) {
            this.addConstraintName(names, cs[k]);
        }
    }

    private void addConstraintName(Set names, Constraint con) throws ValidationException {
        String name = con.getName();
        if (name != null) {
            if (names.contains(name)) {
                throw new InvalidNameException((DBObject)con, DBArb.format((int)76, (Object)name, (Object)"CONSTRAINT"));
            }
            names.add(name);
        }
    }

    protected boolean createConstraintNameIfNone() {
        return true;
    }

    @AbstractValidator.PropertyValidator(value={"columns"})
    public void validateColumns(T original, T updated) throws ValidationException {
        Object[] cols = updated.getColumns();
        if (this.enforceOneColumnExists(original == null) && !ModelUtil.hasNonNullElement((Object[])cols)) {
            throw new ValidationException(updated, DBArb.format((int)225, (Object)updated.getName()), DBArb.getString((int)226));
        }
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i] instanceof ViewColumn && ((ViewColumn)cols[i]).isAsterisk()) continue;
            Column origCol = null;
            DBObjectID id = cols[i].getID();
            if (id instanceof TemporaryObjectID) {
                try {
                    origCol = (Column)((TemporaryObjectID)id).resolveOriginalID();
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            this.getProvider().validateObject((DBObject)origCol, (DBObject)cols[i]);
        }
        RelationValidator.validateUniqueNames((DBObject[])cols);
    }

    protected boolean enforceOneColumnExists(boolean creating) {
        return this.getProvider() instanceof Database;
    }

    static {
        s_postfixes.put("PKConstraint", "_PK");
        s_postfixes.put("UniqueConstraint", "_UK");
        s_postfixes.put("FKConstraint", "_FK");
        s_postfixes.put("CheckConstraint", "_CHK");
    }
}

