/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.MissingValidatorException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidator<T extends DBObject>
implements DBObjectValidator<T> {
    private DBObjectProvider m_provider;
    private Map<String, Method> m_propMap;

    protected AbstractValidator(DBObjectProvider pro) {
        this.m_provider = pro;
    }

    public final void validateObject(T object) throws ValidationException {
        if (object instanceof SchemaObject && !(object instanceof Index) && this.findExistingObject(object) != null) {
            throw new NameInUseException(object);
        }
        this.validateObject(null, object);
    }

    public final void validateObjectProperty(T object, String property) throws ValidationException {
        this.validateObjectProperty(this.findExistingObject(object), object, property);
    }

    public void validateObject(T original, T updated) throws ValidationException {
        for (Method m : this.getPropertyMethodMap().values()) {
            this.invokePropertyMethod(m, original, updated);
        }
    }

    public void validateObjectProperty(T original, T updated, String property) throws ValidationException {
        Method validationMethod = this.findValidationPropertyMethod(property = this.upgradeLegacyProperty(property));
        if (validationMethod != null) {
            this.invokePropertyMethod(validationMethod, original, updated);
        } else {
            boolean done = false;
            PropertyHelper propHelper = new PropertyHelper();
            String[] chunks = Property.getProperties((String)property);
            for (int i = 0; i < chunks.length; ++i) {
                String remainingPropPath;
                String[] chunksBefore = new String[i + 1];
                System.arraycopy(chunks, 0, chunksBefore, 0, i + 1);
                String pathToObject = Property.createPath((String[])chunksBefore);
                Object o = propHelper.getPropertyValue(updated, pathToObject);
                if (o == null) {
                    return;
                }
                if (!(o instanceof DBObject)) continue;
                DBObject originalChild = original == null ? null : (DBObject)propHelper.getPropertyValue(updated, pathToObject);
                DBObject updatedChild = (DBObject)o;
                if (i < chunks.length - 1) {
                    String[] chunksAfter = new String[chunks.length - i - 1];
                    System.arraycopy(chunks, i + 1, chunksAfter, 0, chunks.length - i - 1);
                    remainingPropPath = Property.createPath((String[])chunksAfter);
                } else {
                    remainingPropPath = null;
                }
                try {
                    done = true;
                    this.getProvider().validateObjectProperty(originalChild, updatedChild, remainingPropPath);
                }
                catch (MissingValidatorException mve) {
                    done = false;
                }
                break;
            }
            if (!done) {
                throw new MissingValidatorException(updated, property);
            }
        }
    }

    private final String upgradeLegacyProperty(String prop) {
        if ("COLUMN".equals(prop)) {
            return "columns";
        }
        if ("CONSTRAINT".equals(prop)) {
            return "constraints";
        }
        if ("INDEX".equals(prop)) {
            return "indexes";
        }
        return prop;
    }

    private void invokePropertyMethod(Method m, T original, T updated) throws ValidationException {
        try {
            m.invoke((Object)this, original, updated);
        }
        catch (IllegalArgumentException e) {
            this.processPropException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof ValidationException) {
                throw (ValidationException)t;
            }
            this.processPropException(t == null ? e : t);
        }
        catch (IllegalAccessException e) {
            this.processPropException(e);
        }
    }

    private void processPropException(Throwable t) {
        DBLog.getLogger().log(Level.SEVERE, "Error calling property validation", t);
    }

    private Method findValidationPropertyMethod(String property) {
        Method retval = null;
        if (ModelUtil.hasLength((String)property)) {
            retval = this.getPropertyMethodMap().get(property);
        }
        return retval;
    }

    private synchronized Map<String, Method> getPropertyMethodMap() {
        if (this.m_propMap == null) {
            this.m_propMap = new TreeMap<String, Method>();
            Class<?> c = this.getClass();
            for (Method m : c.getMethods()) {
                PropertyValidator v = m.getAnnotation(PropertyValidator.class);
                if (v == null) continue;
                String[] value = v.value();
                if (v.path()) {
                    this.putPropertyMethod(m, Property.createPath((String[])value));
                    continue;
                }
                for (String p : v.value()) {
                    this.putPropertyMethod(m, p);
                }
            }
        }
        return this.m_propMap;
    }

    private void putPropertyMethod(Method m, String p) {
        if (!ModelUtil.hasLength((String)p)) {
            throw new IllegalArgumentException("Must have a property name");
        }
        if (this.m_propMap.containsKey(p)) {
            throw new IllegalStateException("Cannot have two methods validating " + p);
        }
        this.m_propMap.put(p, m);
    }

    private String toString(Property ... p) {
        StringBuilder buff = new StringBuilder();
        for (Property prop : p) {
            if (buff.length() > 0) {
                buff.append(".");
            }
            buff.append(prop.toString());
        }
        return buff.toString();
    }

    @PropertyValidator(value={"type"})
    public final void validateType(T original, T updated) throws ValidationException {
        if (original != null && ModelUtil.areDifferent((Object)original.getType(), (Object)updated.getType())) {
            throw new ValidationException(updated, DBArb.getString((int)69));
        }
    }

    @PropertyValidator(value={"name"})
    @PropertyDependency(value={"schema"})
    public final void validateName(T original, T updated) throws ValidationException {
        this.validateName(updated);
        if (original == null) {
            this.validateNameInUse(updated);
        } else if (ModelUtil.areDifferent((Object)original.getName(), (Object)updated.getName())) {
            if (this.canRename()) {
                this.validateNameInUse(updated);
            } else {
                throw new ValidationException(updated, DBArb.getString((int)68));
            }
        }
    }

    protected final boolean isChildOfPendingObject(DBObject obj) {
        boolean childOfPendingObject = false;
        DBObject so = obj;
        while (so.getParent() != null) {
            so = so.getParent();
            childOfPendingObject = true;
        }
        if (so instanceof SchemaObject && !this.isPendingObject((SchemaObject)so)) {
            childOfPendingObject = false;
        }
        return childOfPendingObject;
    }

    protected final boolean isPendingObject(SchemaObject obj) {
        return TemplateExpander.isPendingObject((DBObject)obj);
    }

    protected void validateName(T obj) throws InvalidNameException {
        String name = obj.getName();
        if (!ModelUtil.hasLength((String)name) && !this.canHaveEmptyName()) {
            throw new InvalidNameException(obj, DBArb.getString((int)70));
        }
        if (this.m_provider != null && ModelUtil.hasLength((String)name)) {
            try {
                String extName = this.m_provider.getExternalName(name);
                this.m_provider.validateName(obj.getType(), extName);
            }
            catch (InvalidNameException ine) {
                String reason = ine.getMessage();
                throw new InvalidNameException(obj, DBArb.format((int)71, (Object)name, (Object)reason));
            }
        }
    }

    protected boolean canHaveEmptyName() {
        return false;
    }

    protected boolean canRename() {
        return true;
    }

    protected DBObjectProvider getProvider() {
        return this.m_provider;
    }

    protected void validateNameInUse(T object) throws NameInUseException {
        if (this.m_provider != null) {
            Schema schema = DBUtil.getSchema(object);
            String type = object.getType();
            String name = object.getName();
            this.m_provider.validateUniqueName(type, (DBObject)schema, name);
        }
    }

    protected T findExistingObject(T object) throws ValidationException {
        DBObjectID id = object.getID();
        DBObject existing = null;
        if (id != null) {
            try {
                if (id instanceof TemporaryObjectID) {
                    existing = this.getOriginal((TemporaryObjectID)id);
                    if (ModelUtil.areEqual(object, (Object)existing)) {
                        existing = null;
                    }
                } else {
                    existing = id.resolveID();
                }
            }
            catch (DBException dbe) {
                throw new ValidationException(object, dbe.getMessage());
            }
            if (existing != null && !existing.getType().equals(object.getType())) {
                throw new ValidationException(object, MessageFormat.format(DBArb.getString((int)77), object.getName()));
            }
        }
        if (existing == null && object instanceof SchemaObject && (id == null || id instanceof TemporaryObjectID)) {
            try {
                existing = DBUtil.getProviderDefinition((DBObject)((SchemaObject)object), (DBObjectProvider)this.getProvider());
            }
            catch (DBException dbe) {
                DBLog.logStackTrace((Throwable)dbe);
            }
        }
        return (T)existing;
    }

    private DBObject getOriginal(TemporaryObjectID tid) throws DBException {
        DBObjectID id;
        DBObject obj = tid.resolveOriginalID();
        DBObjectID dBObjectID = id = obj == null ? null : obj.getID();
        if (id instanceof TemporaryObjectID) {
            return this.getOriginal((TemporaryObjectID)id);
        }
        return obj;
    }

    protected boolean enforceChildNameUniqueInSchema(DBObject child) {
        return false;
    }

    @PropertyValidator(value={"Comment"})
    public void validateComment(T original, T update) throws ValidationException {
        String comment = (String)update.getProperty("Comment");
        if (comment != null) {
            DatabaseDescriptor dd = this.getProvider().getDescriptor();
            try {
                dd.validateEncoding(comment, (Object)"Comment");
            }
            catch (ValidationException ve) {
                throw new ValidationException(update, ve.getMessage());
            }
        }
    }

    public Collection<String[]> getDependencies(String path) {
        PropertyDependency pd;
        ArrayList<String[]> retval = null;
        Method m = this.findValidationPropertyMethod(path);
        if (m != null && (pd = m.getAnnotation(PropertyDependency.class)) != null) {
            for (String prop : pd.value()) {
                if (retval == null) {
                    retval = new ArrayList<String[]>();
                }
                retval.add(new String[]{prop});
            }
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    public static void validateUniqueNames(DBObject[] objs) throws ValidationException {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] instanceof ViewColumn && ((ViewColumn)objs[i]).isAsterisk()) continue;
            String name = objs[i].getName();
            if (!ModelUtil.hasLength((String)name)) {
                if (objs[i] instanceof ViewColumn) {
                    ViewColumn col = (ViewColumn)objs[i];
                    SelectObject sel = null;
                    if (col.getSelectObjectID() != null) {
                        try {
                            sel = (SelectObject)col.getSelectObjectID().resolveID();
                        }
                        catch (DBException e) {
                            // empty catch block
                        }
                    }
                    if (sel == null) {
                        throw new ValidationException(objs[i], DBArb.format((int)78, (Object)(col.getParent() == null ? "" : col.getParent().getName())));
                    }
                }
                throw new InvalidNameException(objs[i], DBArb.getString((int)70));
            }
            if (names.contains(name)) {
                throw new InvalidNameException(objs[i], DBArb.format((int)76, (Object)name, (Object)objs[i].getType()));
            }
            names.add(name);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface PropertyDependency {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface PropertyValidator {
        public String[] value();

        public boolean path() default false;
    }
}

