/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.timesten;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.timesten.TimesTen11gDatabaseImpl;
import oracle.javatools.db.timesten.TimesTen7DatabaseDescriptor;
import oracle.javatools.db.timesten.TimesTen7DatabaseImpl;
import oracle.javatools.db.timesten.TimesTenDatabaseDescriptor;
import oracle.javatools.db.timesten.TimesTenDatabaseImpl;

public class TimesTenDatabaseFactory
extends BaseDatabaseCreator {
    private Map<String, DatabaseDescriptor> m_descriptors = new HashMap<String, DatabaseDescriptor>();

    public TimesTenDatabaseFactory() {
        this.registerProviderClass(TimesTenDatabaseImpl.class, 398, (DataTypeRegistry.Registerer)new TimesTenDatabaseImpl.Registerer());
        this.registerProviderClass(TimesTen7DatabaseImpl.class, DBArb.getString((int)426), (DataTypeRegistry.Registerer)new TimesTen7DatabaseImpl.Registerer());
        this.registerProviderClass(TimesTen11gDatabaseImpl.class, DBArb.getString((int)431), (DataTypeRegistry.Registerer)new TimesTen11gDatabaseImpl.Registerer());
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getTimesTenConnectionVersion(conn);
        switch (t) {
            case 0: {
                return null;
            }
            case 11: {
                return new TimesTen11gDatabaseImpl(connStore, connName, conn);
            }
            case 7: {
                return new TimesTen7DatabaseImpl(connStore, connName, conn);
            }
        }
        return new TimesTenDatabaseImpl(connStore, connName, conn);
    }

    protected int getTimesTenConnectionVersion(Connection conn) {
        int majorVer = 0;
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (dbName.startsWith("TimesTen")) {
                    try {
                        majorVer = dmd.getDatabaseMajorVersion();
                    }
                    catch (Throwable t) {}
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return majorVer;
    }

    protected boolean isTimesTenConnection(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                return dbName.startsWith("TimesTen");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        TimesTenDatabaseDescriptor descriptor = null;
        if (TimesTen11gDatabaseImpl.class.isAssignableFrom(providerClass) && (descriptor = this.m_descriptors.get(providerClass.getName())) == null) {
            descriptor = new TimesTen7DatabaseDescriptor(providerClass);
            this.m_descriptors.put(providerClass.getName(), descriptor);
        }
        if (TimesTen7DatabaseImpl.class.isAssignableFrom(providerClass)) {
            descriptor = this.m_descriptors.get(providerClass.getName());
            if (descriptor == null) {
                descriptor = new TimesTen7DatabaseDescriptor(providerClass);
                this.m_descriptors.put(providerClass.getName(), descriptor);
            }
        } else if (TimesTenDatabaseImpl.class.isAssignableFrom(providerClass) && (descriptor = this.m_descriptors.get(providerClass.getName())) == null) {
            descriptor = new TimesTenDatabaseDescriptor(providerClass);
            this.m_descriptors.put(providerClass.getName(), descriptor);
        }
        return descriptor;
    }
}

