/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public final class JdbcDriverTester {
    private static final String URL_KEY = "url";
    private static final String DRIVER_KEY = "driver";
    private static final String SCHEMA_KEY = "owner_schema";
    private String _url;
    private Driver _driver;
    private Properties _props;
    private String _schema;
    private Connection _conn;
    private DatabaseMetaData _dmd;

    private static void printUsage() {
        System.err.println("JdbcDriverTester will attempt to connect to a database");
        System.err.println("and execute a number of JDBC calls. The output of these");
        System.err.println("calls will provide details about the JDBC implementation");
        System.err.println("of the specified driver.");
        System.err.println();
        System.err.println("To invoke JdbcDriverTester, specify the path to a properties");
        System.err.println("file containing the connection information. The following");
        System.err.println("properties are supported:");
        System.err.println("  user - indicates the username used for the connection");
        System.err.println("  password - indicates the password used for the connection");
        System.err.println("  driver - indicates the JDBC driver class used for the connection.");
        System.err.println("           This class must be available on the classpath.");
        System.err.println("  url - the URL used for the connection");
        System.err.println("  owner_schema - indicates the schema to use when querying for");
        System.err.println("                 tables and views");
        System.err.println();
        System.err.println("JdbcDriverTester requires that the driver and url be specified; the");
        System.err.println("driver class determines whether the user and password are required.");
        System.err.println("Any additional properties specified in the file will be passed to");
        System.err.println("the driver when the connection is created.");
    }

    private static void handleUsageError(String msg) {
        System.err.println("Usage error: " + msg);
        System.err.println();
        JdbcDriverTester.printUsage();
        System.exit(-1);
    }

    private static void printError(String call, SQLException ex) {
        System.err.println("SQLException encountered when calling " + call + ":");
        System.err.println("  " + ex.getLocalizedMessage());
    }

    private static Properties loadPropertiesFromFile(String fName) throws IOException {
        FileInputStream is = new FileInputStream(fName);
        Properties props = new Properties();
        props.load(is);
        return props;
    }

    private static String quoteValue(String value) {
        return value != null ? "\"" + value + "\"" : "null";
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            JdbcDriverTester.handleUsageError("Properties file not specified");
        }
        try {
            Properties propFile = JdbcDriverTester.loadPropertiesFromFile(args[0]);
            Properties connProps = new Properties();
            String url = null;
            Driver driver = null;
            String schema = null;
            Enumeration<Object> e = propFile.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = propFile.getProperty(key);
                if (DRIVER_KEY.equals(key)) {
                    Class<?> c = Class.forName(value);
                    driver = (Driver)c.newInstance();
                    continue;
                }
                if (URL_KEY.equals(key)) {
                    url = value;
                    continue;
                }
                if (SCHEMA_KEY.equals(key)) {
                    schema = value;
                    continue;
                }
                connProps.setProperty(key, value);
            }
            JdbcDriverTester tester = new JdbcDriverTester(url, driver, connProps, schema);
            tester.test();
            tester.close();
        }
        catch (Exception ex) {
            JdbcDriverTester.handleUsageError(ex.getLocalizedMessage());
        }
    }

    private JdbcDriverTester(String url, Driver driver, Properties props, String schema) throws SQLException {
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("URL must be specified");
        }
        if (driver == null) {
            throw new IllegalArgumentException("JDBC driver class must be specified");
        }
        this._url = url;
        this._driver = driver;
        this._props = props;
        this._schema = schema;
        this.resetConnection();
    }

    private void test() throws SQLException {
        boolean useSchemas;
        String catalog = this.fetchCatalog();
        this.fetchDriverInfo();
        Set schemas = this.fetchSchemas();
        boolean bl = useSchemas = schemas != null;
        if (useSchemas && this._schema == null) {
            try {
                this._schema = this._dmd.getUserName();
            }
            catch (SQLException ex) {
                JdbcDriverTester.printError("getUserName()", ex);
                this.resetConnection();
            }
        }
        Set types = this.fetchTableTypes();
        for (String type : types) {
            this.fetchTables(catalog, type, this._schema);
            if (type.trim().equals(type)) continue;
            this.fetchTables(catalog, type.trim(), this._schema);
        }
    }

    private void close() {
        if (this._conn != null) {
            try {
                this._conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._conn = null;
        }
    }

    private void resetConnection() throws SQLException {
        this.close();
        this._conn = this._driver.connect(this._url, this._props);
        this._dmd = this._conn.getMetaData();
    }

    private String fetchCatalog() throws SQLException {
        String catalog = null;
        try {
            System.out.println("Fetching catalog...");
            catalog = this._conn.getCatalog();
            System.out.print("  Connection.getCatalog() returned ");
            System.out.println(JdbcDriverTester.quoteValue(catalog));
        }
        catch (SQLException ex) {
            JdbcDriverTester.printError("getCatalog()", ex);
            this.resetConnection();
        }
        return catalog;
    }

    private void fetchDriverInfo() throws SQLException {
        String cmd = null;
        try {
            cmd = "getDriverName()";
            System.out.println("Fetching driver name...");
            String value = this._dmd.getDriverName();
            System.out.println("  " + cmd + " returned " + value);
            cmd = "getDriverVersion()";
            System.out.println("Fetching driver version...");
            value = this._dmd.getDriverVersion();
            System.out.println("  " + cmd + " returned " + value);
        }
        catch (SQLException ex) {
            JdbcDriverTester.printError(cmd, ex);
            this.resetConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set fetchSchemas() throws SQLException {
        ResultSet rs = null;
        HashSet<String> schemas = null;
        try {
            System.out.println("Fetching schema list...");
            rs = this._dmd.getSchemas();
            schemas = new HashSet<String>();
            while (rs.next()) {
                String schema = rs.getString(1);
                System.out.println("  Found schema " + JdbcDriverTester.quoteValue(schema));
                schemas.add(schema);
            }
        }
        catch (SQLException ex) {
            JdbcDriverTester.printError("getSchemas()", ex);
            this.resetConnection();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set fetchTableTypes() throws SQLException {
        ResultSet rs = null;
        HashSet<String> result = new HashSet<String>();
        try {
            System.out.println("Fetching Table Types...");
            rs = this._dmd.getTableTypes();
            while (rs.next()) {
                String type = rs.getString(1);
                System.out.println("  Found table type " + JdbcDriverTester.quoteValue(type));
                result.add(type);
            }
        }
        catch (SQLException ex) {
            JdbcDriverTester.printError("getTableTypes()", ex);
            this.resetConnection();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchTables(String catalog, String tableType, String schema) throws SQLException {
        ResultSet rs = null;
        String cmd = null;
        try {
            HashSet<Table> tables = new HashSet<Table>();
            cmd = "getTables()";
            System.out.println("Fetching tables of type " + JdbcDriverTester.quoteValue(tableType) + "for schema " + JdbcDriverTester.quoteValue(schema) + " using catalog " + JdbcDriverTester.quoteValue(catalog));
            rs = this._dmd.getTables(catalog, schema, "%", new String[]{tableType});
            while (rs.next()) {
                tables.add(new Table(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
            rs.close();
            cmd = "getColumns";
            for (Table tbl : tables) {
                System.out.println("Fetching table data for " + tbl);
                rs = this._dmd.getColumns(tbl._cat, tbl._schema, tbl._name, "%");
                while (rs.next()) {
                    System.out.println("  Found column " + rs.getString(4));
                }
                rs.close();
            }
        }
        catch (SQLException ex) {
            JdbcDriverTester.printError(cmd, ex);
            this.resetConnection();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private static final class Table {
        String _cat;
        String _schema;
        String _name;

        Table(String cat, String schema, String name) {
            this._cat = cat;
            this._schema = schema;
            this._name = name;
        }

        public String toString() {
            return JdbcDriverTester.quoteValue(this._cat) + ":" + JdbcDriverTester.quoteValue(this._schema) + ":" + JdbcDriverTester.quoteValue(this._name);
        }
    }
}

