/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.sybase.AdaptiveServerColumnValidator;
import oracle.javatools.db.sybase.AdaptiveServerDDLGenerator;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptiveServerEnterpriseDescriptor<T extends AdaptiveServerEnterpriseDatabase>
extends JdbcDatabaseDescriptor<T> {
    private static final String YEN = "00a5";
    private static List s_compatibleTypesLists;
    public static final int MAX_NAME_LENGTH = 30;
    public static final int MAX_TEMP_NAME_LENGTH = 13;
    public static final Set RESERVED_WORDS;

    public AdaptiveServerEnterpriseDescriptor(Class<T> clz) {
        super(clz);
    }

    @Override
    public int getCasePolicy() {
        return 3;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String type) {
        return 30;
    }

    protected Set getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        boolean isValid = true;
        String reason = "";
        try {
            AdaptiveServerEnterpriseDescriptor.validateIdentifier((String)name, (char)'\"', (int)30, (String)"_#@?$00a5", (boolean)false, (Set)this.getReservedWords(), (int)this.getCasePolicy());
        }
        catch (InvalidNameException ine) {
            isValid = false;
            reason = ine.getMessage();
        }
        if (isValid) {
            char firstChar = name.charAt(0);
            if (firstChar == '\"') {
                if (name.length() > 30) {
                    throw new InvalidNameException(null, DBArb.getString((int)6));
                }
                if (name.charAt(1) == '#') {
                    throw new InvalidNameException(null, DBArb.getString((int)9));
                }
            } else {
                if (!Character.isLetter(firstChar) && firstChar != '_' && firstChar != '#' && firstChar != '@' || name.startsWith("@@")) {
                    throw new InvalidNameException(null, DBArb.getString((int)9));
                }
                if (firstChar == '#') {
                    if (name.length() < 2) {
                        throw new InvalidNameException(null, DBArb.getString((int)5));
                    }
                    if (name.length() > 13) {
                        throw new InvalidNameException(null, DBArb.getString((int)6));
                    }
                }
            }
        }
        if (!isValid) {
            throw new InvalidNameException(null, reason);
        }
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("COLUMN", new AdaptiveServerColumnValidator(pro));
        return v;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new AdaptiveServerDDLGenerator(pro);
    }

    private static void initialiseCompatibleTypes() {
        s_compatibleTypesLists = new ArrayList();
        String[] chars = new String[]{"CHAR", "NCHAR", "VARCHAR", "NVARCHAR"};
        String[] unichars = new String[]{"UNICHAR", "UNIVARCHAR"};
        s_compatibleTypesLists.add(new ArrayList<String>(Arrays.asList(chars)));
        s_compatibleTypesLists.add(new ArrayList<String>(Arrays.asList(unichars)));
    }

    protected boolean isValidFKDataTypeImpl(DataType fktype, DataType reftype) {
        boolean isValid = super.isValidFKDataTypeImpl(fktype, reftype);
        if (!isValid) {
            if (s_compatibleTypesLists == null) {
                AdaptiveServerEnterpriseDescriptor.initialiseCompatibleTypes();
            }
            for (List compatibleTypes : s_compatibleTypesLists) {
                if (compatibleTypes == null || !compatibleTypes.contains(fktype.getName()) || !compatibleTypes.contains(reftype.getName())) continue;
                isValid = true;
            }
        }
        return isValid;
    }

    @Override
    public int getDatabaseVersion() {
        return 12;
    }

    static {
        RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "ARITH_OVERFLOW", "AS", "ASC", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHAR_CONVERT", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COMMIT", "COMPUTE", "CONFIRM", "CONNECT", "CONSTRAINT", "CONTINUE", "CONTROLROW", "CONVERT", "COUNT", "CREATE", "CURRENT", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DESC", "DETERMINISTIC", "DISK", "DISTINCT", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "END", "ENDTRAN", "ERRLVL", "ERRORDATA", "ERROREXIT", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXP_ROW_SIZE", "EXTERNAL", "FETCH", "FILLFACTOR", "FOR", "FOREIGN", "FROM", "FUNC", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_GAP", "IDENTITY_INSERT", "IDENTITY_START", "IF", "IN", "INDEX", "INOUT", "INSERT", "INSTALL", "INTERSECT", "INTO", "IS", "ISOLATION", "JAR", "JOIN", "KEY", "KILL", "LEVEL", "LIKE", "LINENO", "LOAD", "LOCK", "MAX", "MAX_ROWS_PER_PAGE", "MIN", "MIRROR", "MIRROREXIT", "MODIFY", "NATIONAL", "NOHOLDLOCK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "NUMERIC_TRUNCATION", "OF", "OFF", "OFFSETS", "ON", "ONCE", "ONLINE", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUT", "OUTPUT", "OVER", "PARTITION", "PERCENT", "PERM", "PERMANENT", "PLAN", "PRECISION", "PREPARE", "PRIMARY", "PRINT", "PRIVILEGES", "PROC", "PROCEDURE", "PROCESSEXIT", "PROXY_TABLE", "PUBLIC", "QUIESCE", "RAISERROR", "READ", "READPAST", "READTEXT", "RECONFIGURE", "REFERENCES", "REMOVE", "REORG", "REPLACE", "REPLICATION", "RESERVEPAGEGAP", "RETURN", "RETURNS", "REVOKE", "ROLE", "ROLLBACK", "ROWCOUNT", "ROWS", "RULE", "SAVE", "SCHEMA", "SELECT", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "STRINGSIZE", "STRIPE", "SUM", "SYB_IDENTITY", "SYB_RESTREE", "SYB_TERMINATE", "TABLE", "TEMP", "TEMPORARY", "TEXTSIZE", "TO", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UNPARTITION", "UPDATE", "USE", "USER", "USER_OPTION", "USING", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WORK", "WRITETEXT"));
    }
}

