/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.sqlite.SQLiteDatabase;
import oracle.javatools.db.sqlite.SQLiteDatabaseDescriptor;
import oracle.javatools.db.sqlite.SQLiteDatabaseImpl;

public class SQLiteDatabaseFactory
extends BaseDatabaseCreator {
    private Map<String, DatabaseDescriptor> m_descriptors = new HashMap<String, DatabaseDescriptor>();

    public SQLiteDatabaseFactory() {
        this.registerProviderClass(SQLiteDatabaseImpl.class, DBArb.getString((int)430), (DataTypeRegistry.Registerer)new SQLiteDatabaseImpl.Registerer());
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getSQLiteConnectionVersion(conn);
        switch (t) {
            case 0: {
                return null;
            }
        }
        return new SQLiteDatabaseImpl(connStore, connName, conn);
    }

    protected int getSQLiteConnectionVersion(Connection conn) {
        int majorVer = 0;
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String databaseName = dmd.getDatabaseProductName();
                if ("SQLite".equals(databaseName)) {
                    majorVer = dmd.getDatabaseMajorVersion();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return majorVer;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (SQLiteDatabase.class.isAssignableFrom(providerClass)) {
            SQLiteDatabaseDescriptor descriptor = this.m_descriptors.get(providerClass.getName());
            if (descriptor == null) {
                descriptor = new SQLiteDatabaseDescriptor(providerClass);
                this.m_descriptors.put(providerClass.getName(), descriptor);
            }
            return descriptor;
        }
        return null;
    }
}

