/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTypeColumnPropertiesValidator
extends AbstractValidator<XMLTypeColumnProperties> {
    public XMLTypeColumnPropertiesValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={"elementID"})
    public void validateElement(XMLTypeColumnProperties original, XMLTypeColumnProperties props) throws ValidationException {
        this.checkXMLSchemaAndElement(props);
        this.checkXMLSchemaAndAllowAny(props);
        this.checkXMLSchemaAndAllowNon(props);
    }

    @AbstractValidator.PropertyValidator(value={"allowAnySchema"})
    public void validateAllowAnySchema(XMLTypeColumnProperties original, XMLTypeColumnProperties props) throws ValidationException {
        this.checkXMLSchemaAndAllowAny(props);
    }

    @AbstractValidator.PropertyValidator(value={"allowNonSchema"})
    public void validateAllowNonSchema(XMLTypeColumnProperties original, XMLTypeColumnProperties props) throws ValidationException {
        this.checkXMLSchemaAndAllowNon(props);
    }

    private void checkXMLSchemaAndElement(XMLTypeColumnProperties props) throws ValidationException {
        if (props.getStoreAs() == XMLTypeColumnProperties.StoreAs.OBJECT_RELATIONAL && props.getElementID() == null) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)416));
        }
        this.validateElementID(props);
    }

    private void checkXMLSchemaAndAllowAny(XMLTypeColumnProperties props) throws ValidationException {
        if (props.getElementID() != null && props.isAllowAnySchema()) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)414));
        }
        this.validateElementID(props);
    }

    private void checkXMLSchemaAndAllowNon(XMLTypeColumnProperties props) throws ValidationException {
        if (props.getStoreAs() == XMLTypeColumnProperties.StoreAs.BINARY_XML && props.getElementID() == null && !props.isAllowAnySchema() && !props.isAllowNonSchema()) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)415));
        }
        this.validateElementID(props);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    private void validateElementID(XMLTypeColumnProperties props) throws ValidationException {
        DBObjectID elementID = props.getElementID();
        if (elementID != null) {
            if (elementID.getParent() == null) {
                throw new ValidationException((DBObject)props, DBArb.getString((int)417));
            }
            if (elementID.getParent() instanceof BaseObjectID && !ModelUtil.hasLength((String)((BaseObjectID)elementID.getParent()).getSchemaName())) {
                throw new ValidationException((DBObject)props, DBArb.getString((int)417));
            }
        }
    }
}

