/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePartitionValidator
extends AbstractValidator<TablePartition> {
    public TablePartitionValidator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    @Override
    public void validateObject(TablePartition original, TablePartition tp) throws ValidationException {
        String name = tp.getName();
        OracleTablePartitions.ObjectType objectType = tp.getObjectType();
        if (name == null && objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            throw new ValidationException((DBObject)tp, DBArb.getString((int)336));
        }
        OracleTablePartitions partitions = (OracleTablePartitions)tp.getParent();
        if (partitions == null) {
            throw new ValidationException((DBObject)tp, "A Table Partition must have a valid parent partition model.");
        }
        super.validateObject(original, tp);
    }

    @AbstractValidator.PropertyValidator(value={"values"})
    public void validateValues(TablePartition original, TablePartition tp) throws ValidationException {
        this.validateTypes(tp);
        OracleTablePartitions.PartitionType partitionType = tp.getPartitionType();
        if (partitionType == OracleTablePartitions.PartitionType.RANGE) {
            this.validateRangeValues(tp);
        } else if (partitionType == OracleTablePartitions.PartitionType.LIST) {
            this.validateListValues(tp);
        } else if (partitionType == OracleTablePartitions.PartitionType.HASH && tp.getValues().length > 0) {
            throw new ValidationException((DBObject)tp, DBArb.getString((int)316));
        }
    }

    @AbstractValidator.PropertyValidator(value={"partitionLevelSubpartitions"})
    public void validatePartitionLevelSubpartitions(TablePartition original, TablePartition tp) throws ValidationException {
        this.validateTypes(tp);
        OracleTablePartitions partitionLevelSubpartitions = tp.getPartitionLevelSubpartitions();
        if (partitionLevelSubpartitions != null) {
            if (tp.getPartitionType() != OracleTablePartitions.PartitionType.RANGE) {
                throw new ValidationException((DBObject)tp, DBArb.getString((int)319));
            }
            this.getProvider().validateObject((DBObject)partitionLevelSubpartitions);
        }
    }

    @AbstractValidator.PropertyValidator(value={"compression"})
    public void validateCompression(TablePartition original, TablePartition tp) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = tp.getPartitionType();
        OracleTablePartitions.ObjectType objectType = tp.getObjectType();
        String compression = tp.getCompression();
        if ("COMPRESS".equals(compression) && (objectType != OracleTablePartitions.ObjectType.PARTITION || partitionType == OracleTablePartitions.PartitionType.HASH && objectType == OracleTablePartitions.ObjectType.PARTITION)) {
            throw new ValidationException((DBObject)tp, DBArb.format((int)321, (Object)"COMPRESS"));
        }
        if (compression != null && !compression.equalsIgnoreCase("COMPRESS") && !compression.equalsIgnoreCase("NOCOMPRESS")) {
            throw new ValidationException((DBObject)tp, DBArb.format((int)322, (Object)compression));
        }
    }

    @AbstractValidator.PropertyValidator(value={"segmentAttributes"})
    public void validateSegmentAttributes(TablePartition original, TablePartition tp) throws ValidationException {
        OracleStorageProperties segmentAttributes = tp.getSegmentAttributes();
        if (segmentAttributes != null) {
            this.getProvider().validateObject((DBObject)segmentAttributes);
        }
    }

    @AbstractValidator.PropertyValidator(value={"LOBDescriptors"})
    public void validateLOBDescriptors(TablePartition original, TablePartition tp) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = tp.getPartitionType();
        OracleTablePartitions.ObjectType objectType = tp.getObjectType();
        LOBDescriptor[] lobDescriptors = tp.getLOBDescriptors();
        for (int i = 0; i < lobDescriptors.length; ++i) {
            this.getProvider().validateObject((DBObject)lobDescriptors[i]);
        }
    }

    private void validateTypes(TablePartition tp) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = tp.getPartitionType();
        if (partitionType == null) {
            throw new ValidationException((DBObject)tp, DBArb.getString((int)303));
        }
        OracleTablePartitions.ObjectType objectType = tp.getObjectType();
        if (objectType == null) {
            throw new ValidationException((DBObject)tp, DBArb.getString((int)304));
        }
    }

    private void validateRangeValues(TablePartition tp) throws ValidationException {
        Object[] values = tp.getValues();
        int columnCount = 0;
        OracleTablePartitions partitions = (OracleTablePartitions)tp.getParent();
        if (partitions != null) {
            DBObjectID[] columns = partitions.getPartitionColumns();
            columnCount = columns.length;
        }
        int valueCount = 0;
        for (Object value : values) {
            valueCount += value instanceof String ? TablePartition.splitValues((String)((String)value)).size() : 1;
        }
        if (valueCount == 0 || columnCount != valueCount) {
            throw new ValidationException((DBObject)tp, DBArb.getString((int)320));
        }
    }

    private void validateListValues(TablePartition tp) throws ValidationException {
        Object[] values = tp.getValues();
        if (values.length < 1) {
            throw new ValidationException((DBObject)tp, DBArb.getString((int)314));
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i] != TablePartition.ListValue.DEFAULT || values.length <= 1) continue;
            throw new ValidationException((DBObject)tp, DBArb.getString((int)311));
        }
    }
}

