/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.MissingValidatorException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.validators.ExternalTablePropsValidator;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.db.validators.TableValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTableValidator<T extends Table>
extends TableValidator<T> {
    public OracleTableValidator(DBObjectProvider prov) {
        super(prov);
    }

    @Override
    protected boolean enforceChildNameUniqueInSchema(DBObject obj) {
        return (obj instanceof Constraint || obj instanceof Index) && !this.isChildOfPendingObject(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AbstractValidator.PropertyValidator(value={"properties"})
    public void validateProperties(T original, T updated) throws ValidationException {
        OracleTablePartitions partitions;
        OracleStorageProperties storageProperties;
        OracleExternalTableProperties properties;
        boolean isPartitioned = updated.getProperty("PARTITIONED TABLE") == Boolean.TRUE;
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.INDEX_ORGANIZED) {
            if (this.getPK((Table)updated) == null) {
                throw new ValidationException(updated, DBArb.getString((int)264));
            }
            if (!this.getPK((Table)updated).isEnabled()) {
                throw new ValidationException(updated, DBArb.getString((int)265));
            }
            properties = (OracleIndexOrganizedTableProperties)updated.getProperty("OracleIndexOrganizedTableProperties");
            if (properties != null) {
                try {
                    this.getProvider().validateObject((DBObject)properties);
                }
                catch (MissingValidatorException mve) {
                    throw new ValidationException(updated, DBArb.getString((int)271));
                }
            }
        } else if (tableType == Table.TableType.EXTERNAL) {
            properties = (OracleExternalTableProperties)updated.getProperty("OracleExternalTableProperties");
            if (properties == null) throw new ValidationException(updated, DBArb.getString((int)293));
            this.getProvider().validateObject((DBObject)properties);
        } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
            if (isPartitioned) {
                throw new ValidationException(updated, DBArb.format((int)254, (Object)DBArb.getString((int)1), (Object)DBArb.getString((int)257)));
            }
            for (Constraint constraint : updated.getConstraints()) {
                if (!(constraint instanceof FKConstraint)) continue;
                throw new ValidationException(updated, DBArb.format((int)254, (Object)DBArb.getString((int)1), (Object)DBArb.getString((int)258)));
            }
            for (Constraint constraint : updated.getColumns()) {
                OracleColumnProperties ocp = (OracleColumnProperties)constraint.getProperty("OracleColumnProperties");
                if (ocp == null || ocp.getNestedTableProperties() == null) continue;
                throw new ValidationException((DBObject)constraint, DBArb.format((int)254, (Object)DBArb.getString((int)1), (Object)DBArb.getString((int)263)), DBArb.format((int)227, (Object)constraint.getName()));
            }
        }
        if ((storageProperties = (OracleStorageProperties)updated.getProperty("OracleStorageProperties")) != null) {
            this.getProvider().validateObject((DBObject)storageProperties);
        }
        if (!isPartitioned || (partitions = (OracleTablePartitions)updated.getProperty("OracleTablePartitions")) == null) return;
        try {
            this.getProvider().validateObject((DBObject)partitions);
            return;
        }
        catch (MissingValidatorException mve) {
            throw new ValidationException(updated, DBArb.getString((int)339));
        }
    }

    @Override
    @AbstractValidator.PropertyValidator(value={"properties", "TableType"}, path=true)
    public void validateTableType(T original, T updated) throws ValidationException {
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.EXTERNAL) {
            ExternalTablePropsValidator.validateTable(updated);
        } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
            this.validateProperties(original, updated);
        }
    }

    private PKConstraint getPK(Table table) {
        if (table != null) {
            for (Constraint constraint : table.getConstraints()) {
                if (!(constraint instanceof PKConstraint)) continue;
                return (PKConstraint)constraint;
            }
        }
        return null;
    }

    @Override
    @AbstractValidator.PropertyValidator(value={"columns"})
    public void validateColumns(T original, T updated) throws ValidationException {
        super.validateColumns(original, updated);
    }
}

