/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Arrays;
import java.util.HashSet;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.db.diff.IndexObjectComparator;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleSQLQueryBuilder;
import oracle.javatools.db.ora.resource.OracleTypesBundle;
import oracle.javatools.db.ora.validators.OracleIndexAndConstraintValidator;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.db.validators.IndexValidator;

public class OracleIndexValidator
extends IndexValidator {
    private static final HashSet INVALID_INDEX_DATATYPES = new HashSet<String>(Arrays.asList("LONG", "LONG RAW", "LOB", "BLOB", "CLOB", "NCLOB", "BFILE", "REF"));
    private static final HashSet VALID_TEXT_INDEX_DATATYPES = new HashSet<String>(Arrays.asList(OracleTypesBundle.get("TYPE_XMLTYPE_NAME"), OracleTypesBundle.get("TYPE_URITYPE_NAME"), "BLOB", "BFILE"));

    public OracleIndexValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected void validateNameInUse(Index object) throws NameInUseException {
        super.validateNameInUse(object);
        if (object instanceof Index && this.enforceChildNameUniqueInSchema((DBObject)object)) {
            Table parent = (Table)object.getParent();
            try {
                this.getProvider().validateUniqueName("CONSTRAINT", (DBObject)parent.getSchema(), object.getName());
            }
            catch (NameInUseException e) {
                if (e.getUserName().equals(parent.getName()) && e.getUserType().equals(parent.getType())) {
                    if (!(this.getProvider() instanceof Database)) {
                        OracleIndexAndConstraintValidator.validateIndex(object);
                    }
                }
                throw e;
            }
        }
    }

    @AbstractValidator.PropertyValidator(value={"columnExpressions"})
    public void validateExpressions(Index original, Index index) throws ValidationException {
        super.validateExpressions(original, index);
        Index.IndexType type = index.getIndexType();
        IndexObject[] ios = index.getColumnExpressions();
        if (type == Index.IndexType.DOMAIN) {
            if (ios.length != 1) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)135));
            }
        } else if (type == Index.IndexType.BITMAP) {
            if (ios.length > 30) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)129));
            }
        } else if (ios.length > 32) {
            throw new ValidationException((DBObject)index, DBArb.getString((int)128));
        }
        this.checkInvalidFunctions(index);
        if (!(this.getProvider() instanceof Database)) {
            OracleIndexAndConstraintValidator.validateIndex(index);
        }
    }

    @AbstractValidator.PropertyValidator(value={"keyCompression"})
    public void validateKeyCompression(Index original, Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        Integer keyComp = index.getKeyCompression();
        if (keyComp != null) {
            if (keyComp < 0) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)142));
            }
            if (index.getIndexType() == Index.IndexType.DOMAIN) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)143));
            }
            if (index.getIndexType() == Index.IndexType.UNIQUE && keyComp > ios.length - 1) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)144));
            }
            if (index.getIndexType() == Index.IndexType.NORMAL && keyComp > ios.length) {
                throw new ValidationException((DBObject)index, DBArb.getString((int)145));
            }
        }
    }

    protected void validateColumnType(Index index, Column col) throws ValidationException {
        super.validateColumnType(index, col);
        int err = -1;
        DataType dt = null;
        try {
            DataTypeUsage dtu = col.getDataTypeUsage();
            if (dtu != null) {
                dt = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                err = this.isValidDatatype(index, dt);
            }
        }
        catch (DBException dbe) {
            err = 134;
        }
        if (err >= 0) {
            throw new ValidationException((DBObject)col, DBArb.format((int)err, (Object)index.getName(), (Object)col.getName(), (Object)(dt == null ? "<none>" : dt.getName())));
        }
    }

    private int isValidDatatype(Index index, DataType dt) {
        String dtName = dt.getName();
        int retval = -1;
        if (index.getIndexType() == Index.IndexType.DOMAIN) {
            BaseObjectID id;
            boolean textIndex = false;
            if (index.getDomainIndextype() instanceof BaseObjectID && "CTXSYS".equals((id = (BaseObjectID)index.getDomainIndextype()).getSchemaName()) && "CONTEXT".equals(id.getName())) {
                textIndex = true;
            }
            if (textIndex && !(dt instanceof CharacterDataType) && !VALID_TEXT_INDEX_DATATYPES.contains(dtName)) {
                retval = 137;
            }
        } else if (dt instanceof PredefinedDataTypeUsage || INVALID_INDEX_DATATYPES.contains(dtName)) {
            retval = 134;
        }
        return retval;
    }

    protected void checkColumnExpressions(Index index) throws ValidationException {
        boolean bitMapped = false;
        IndexObject[] ios = index.getColumnExpressions();
        Table t = index.getTable();
        HashSet<String> columnNames = new HashSet<String>();
        for (int i = 0; i < ios.length; ++i) {
            String columnName;
            SQLFragment expression = ios[i].getExpression();
            if (expression instanceof ColumnUsage) {
                ((ColumnUsage)expression).setProvider(this.getProvider());
            }
            if (t.getColumn(columnName = this.getProvider().getInternalName(expression.getSQLText())) != null && (bitMapped || ios[i].getOrder() != "DESC")) {
                if (columnNames.contains(columnName)) {
                    throw new ValidationException((DBObject)index, DBArb.getString((int)133));
                }
                columnNames.add(columnName);
            }
            this.validateColumnExpression(index, expression);
        }
    }

    private void validateColumnExpression(Index index, SQLFragment columnExpression) throws ValidationException {
        boolean noColumns;
        Table t = index.getTable();
        boolean bl = noColumns = t instanceof MaterializedView && t.getColumns().length == 0;
        if (!noColumns) {
            try {
                for (String[] nameComponents : ParserUtils.getColumnNames((String)columnExpression.getSQLText(), (ParserUtils.ExpressionType)ParserUtils.ExpressionType.ARITHMETIC)) {
                    String columnName = this.getProvider().getInternalName(nameComponents[0]);
                    Column col = t.getColumn(columnName);
                    if (col == null) {
                        throw new ValidationException((DBObject)index, DBArb.format((int)127, (Object)columnName, (Object)t.getName()));
                    }
                    this.validateColumnType(index, col);
                }
            }
            catch (SQLQueryException e) {
                throw new ValidationException((DBObject)index, DBArb.format((int)131, (Object[])new Object[]{index.getName(), columnExpression}));
            }
        }
    }

    protected void checkDefinitionIsUnique(Index index) throws ValidationException {
        IndexObjectComparator indexObjComparator = new IndexObjectComparator();
        super.checkDefinitionIsUnique(index);
        IndexObject[] idxColExpressions = index.getColumnExpressions();
        Table owningTable = index.getTable();
        Constraint[] cons = owningTable.getConstraints();
        for (int i = 0; i < cons.length; ++i) {
            Column[] coniCols;
            if (!(cons[i] instanceof UniqueConstraint) || idxColExpressions.length != (coniCols = ((UniqueConstraint)cons[i]).getColumns()).length || !cons[i].isEnabled() && index.getIndexType() == Index.IndexType.UNIQUE || this.getProvider() instanceof Database && cons[i].getName().equals(index.getName()) || !OracleIndexAndConstraintValidator.contraintAndIndexColumnsMatch(this.getProvider(), owningTable, coniCols, idxColExpressions)) continue;
            throw new ValidationException((DBObject)index, DBArb.format((int)124, (Object)index.getName(), (Object)cons[i].getName()));
        }
    }

    @AbstractValidator.PropertyValidator(value={"domainIndextype"})
    public void validateDomainIndextype(Index original, Index index) throws ValidationException {
        if (index.getIndexType() != Index.IndexType.DOMAIN) {
            return;
        }
        DBObjectID indextypeID = index.getDomainIndextype();
        if (indextypeID == null) {
            throw new ValidationException((DBObject)index, DBArb.format((int)138, (Object)index.getName()));
        }
        String schemaName = null;
        if (indextypeID instanceof ReferenceID) {
            schemaName = ((ReferenceID)indextypeID).getSchemaName();
        } else {
            try {
                DBObject indextype;
                DBObject dBObject = indextype = indextypeID != null ? indextypeID.resolveID() : null;
                if (!(indextype instanceof Indextype)) {
                    throw new ValidationException((DBObject)index, DBArb.format((int)138, (Object)index));
                }
                Schema schema = ((Indextype)indextype).getSchema();
                schemaName = schema != null ? schema.getName() : null;
            }
            catch (DBException e) {
                DBLog.getLogger((Object)this).warning("Couldn't resolve indextype for index validation: " + e.getMessage());
            }
        }
    }

    protected void checkInvalidFunctions(Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder(this.getProvider(), index.getSchema());
        for (int i = 0; i < ios.length; ++i) {
            String exprText = ios[i].getExpression().getSQLText();
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append(exprText);
            sb.append(" AS X FROM (SELECT ");
            String comma = "";
            for (Column col : ((Relation)index.getParent()).getColumns()) {
                sb.append(comma);
                sb.append("1 AS ");
                sb.append(col.getName());
                comma = ",";
            }
            sb.append(" FROM DUAL)");
            try {
                builder.buildQuery(sb.toString());
                SelectObject so = builder.getSelectObject("X");
                this.checkInavildFunctionsInFragment(so.getExpression(), ios[i]);
                continue;
            }
            catch (SQLQueryException e) {
                // empty catch block
            }
        }
    }

    private void checkInavildFunctionsInFragment(SQLFragment frag, IndexObject io) throws ValidationException {
        if (frag instanceof Function && ((Function)frag).isGrouping()) {
            throw new ValidationException((DBObject)io, DBArb.format((int)139, (Object)io.getSQLText()));
        }
        if (frag instanceof Operation) {
            SQLFragment[] args = ((Operation)frag).getArguments();
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                this.checkInavildFunctionsInFragment(args[i], io);
            }
        }
        String fnName = frag.getSQLText();
        if (frag instanceof Function) {
            fnName = ((Function)frag).getFunction();
        }
        if ("USER".equalsIgnoreCase(fnName) || "ROWNUM".equalsIgnoreCase(fnName) || "SYSDATE".equalsIgnoreCase(fnName) || "SYSTIMESTAMP".equalsIgnoreCase(fnName) || "CURRENT_DATE".equalsIgnoreCase(fnName) || "CURRENT_TIMESTAMP".equalsIgnoreCase(fnName)) {
            throw new ValidationException((DBObject)io, DBArb.format((int)139, (Object)io.getSQLText()));
        }
    }

    @AbstractValidator.PropertyValidator(value={"indexType"})
    public void validateIndexType(Index original, Index index) throws ValidationException {
        OracleIndexOrganizedTableProperties oiotProps;
        Table table;
        if (!(Index.IndexType.BITMAP != index.getIndexType() || Table.TableType.INDEX_ORGANIZED != (table = index.getTable()).getProperty("TableType") || (oiotProps = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties")) != null && oiotProps.isMapped())) {
            throw new ValidationException((DBObject)index, DBArb.format((int)141, (Object)table, (Object)index));
        }
    }

    @AbstractValidator.PropertyValidator(value={"OracleIndexPartitions"})
    public void validateIndexPartitions(Index original, Index index) throws ValidationException {
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oip != null) {
            this.getProvider().validateObject((DBObject)oip);
        }
    }
}

