/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.validators.OracleTableValidator;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.validators.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewValidator
extends OracleTableValidator<MaterializedView> {
    public MaterializedViewValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={"SQLQuery"})
    public void validateQuery(MaterializedView original, MaterializedView mview) throws ValidationException {
        block3: {
            SQLQuery query = mview.getSQLQuery();
            if (query == null) {
                throw new ValidationException((DBObject)mview, "Materialized View must have a SQL Query");
            }
            try {
                SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.getProvider(), (Schema)mview.getSchema());
                builder.buildQuery(query);
            }
            catch (SQLQueryException sqe) {
                if (!(query instanceof DeclarativeSQLQuery) && !(sqe instanceof SQLParseException)) break block3;
                throw new ValidationException((DBObject)mview, sqe.getMessage());
            }
        }
    }
}

