/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.OpaqueFormatSpec;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTablePropsValidator
extends AbstractValidator<OracleExternalTableProperties> {
    public ExternalTablePropsValidator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    protected boolean canHaveEmptyName() {
        return true;
    }

    @Override
    public void validateObject(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        Table table = (Table)props.getParent();
        if (table == null) {
            throw new ValidationException((DBObject)props, "External table properties must be set on a table.");
        }
        super.validateObject(original, props);
        ExternalTablePropsValidator.validateTable(table);
    }

    static void validateTable(Table table) throws ValidationException {
        if (table != null) {
            boolean isNestedTable;
            boolean isPartitionedTable = table.getProperty("PARTITIONED TABLE") == Boolean.TRUE;
            boolean bl = isNestedTable = table.getProperty("NESTED TABLE") == Boolean.TRUE;
            if (isPartitionedTable || isNestedTable) {
                throw new ValidationException((DBObject)table, DBArb.format((int)253, (Object)DBArb.getString((int)0), (Object)(isPartitionedTable ? DBArb.getString((int)3) : DBArb.getString((int)4))));
            }
            if (table.getConstraints().length != 0) {
                throw new ValidationException((DBObject)table, DBArb.format((int)254, (Object)DBArb.getString((int)0), (Object)DBArb.getString((int)255)));
            }
            if (table.getIndexes().length != 0) {
                throw new ValidationException((DBObject)table, DBArb.format((int)254, (Object)DBArb.getString((int)0), (Object)DBArb.getString((int)256)));
            }
            if (table.getProperty("Comment") != null) {
                throw new ValidationException((DBObject)table, DBArb.format((int)254, (Object)DBArb.getString((int)0), (Object)DBArb.getString((int)259)));
            }
            for (Column column : table.getColumns()) {
                if (column.getProperty("AUTO_GENERATED_SEQUENCE") != null) {
                    throw new ValidationException((DBObject)column, DBArb.format((int)254, (Object)DBArb.getString((int)0), (Object)DBArb.getString((int)260)), DBArb.format((int)227, (Object)column.getName()));
                }
                DataType dataType = null;
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (dataType == null || !(dataType instanceof ComplexType) && !dataType.getName().startsWith("LONG")) continue;
                throw new ValidationException((DBObject)column, DBArb.getString((int)299), DBArb.format((int)227, (Object)column.getName()));
            }
        }
    }

    @AbstractValidator.PropertyValidator(value={"projectColumn"})
    public void validateProjectColumn(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        OracleExternalTableProperties.ProjectColumn projectColumn = props.getProjectColumn();
        if (projectColumn != null && projectColumn != OracleExternalTableProperties.ProjectColumn.ALL && projectColumn != OracleExternalTableProperties.ProjectColumn.REFERENCED) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)298));
        }
    }

    @AbstractValidator.PropertyValidator(value={"defaultDirectory"})
    public void validateDefaultDirectory(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        DBObjectID defDir = props.getDefaultDirectory();
        Directory dir = null;
        try {
            dir = defDir != null ? (Directory)defDir.resolveID() : null;
        }
        catch (DBException dbe) {
            throw new ValidationException((DBObject)props, dbe.getMessage());
        }
        String dirName = null;
        if (dir != null) {
            dirName = dir.getName();
        } else if (defDir instanceof ReferenceID) {
            dirName = ((ReferenceID)defDir).getName();
        }
        if (!ModelUtil.hasLength((String)dirName)) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)301));
        }
    }

    @AbstractValidator.PropertyValidator(value={"locationSpecifiers"})
    public void validateLocationSpecifiers(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        OracleExternalTableProperties.LocationSpecifier[] locSpecs = props.getLocationSpecifiers();
        if (locSpecs.length == 0) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)300));
        }
    }

    @AbstractValidator.PropertyValidator(value={"accessDriverType"})
    public void validateAccessDriverType(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        String accessDriverType = props.getAccessDriverType();
        if (accessDriverType != null && !accessDriverType.equals("ORACLE_LOADER") && !accessDriverType.equals("ORACLE_DATAPUMP")) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)294));
        }
    }

    @AbstractValidator.PropertyValidator(value={"accessParameters"})
    public void validateAccessParameters(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        String val = null;
        Object accessParams = props.getAccessParameters();
        if (accessParams != null) {
            if (accessParams instanceof OpaqueFormatSpec) {
                if (props.isAccessUsingClob()) {
                    throw new ValidationException((DBObject)props, DBArb.getString((int)295));
                }
                OpaqueFormatSpec spec = (OpaqueFormatSpec)accessParams;
                val = spec.getSpec();
            } else if (accessParams instanceof SQLQuery) {
                SQLQuery subquery = (SQLQuery)accessParams;
                val = subquery.getSQLText();
            } else {
                val = accessParams.toString();
            }
        }
        if (props.isAccessUsingClob() && !ModelUtil.hasLength(val)) {
            throw new ValidationException((DBObject)props, DBArb.getString((int)295));
        }
    }

    @AbstractValidator.PropertyValidator(value={"rejectLimit"})
    public void validateRejectLimit(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        String rl = props.getRejectLimit();
        if (rl != null && !rl.equalsIgnoreCase("UNLIMITED")) {
            try {
                Integer rejectLimit = new Integer(rl);
                if (rejectLimit == null || rejectLimit < 0 || rejectLimit > 100000) {
                    throw new ValidationException((DBObject)props, DBArb.getString((int)297));
                }
            }
            catch (NumberFormatException x) {
                throw new ValidationException((DBObject)props, DBArb.getString((int)297));
            }
        }
    }
}

