/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryValidator
extends AbstractSchemaObjectValidator<Directory> {
    public DirectoryValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={"path"})
    public void validatePath(Directory original, Directory updated) throws ValidationException {
        String path = updated.getPath();
        if (!ModelUtil.hasLength((String)path)) {
            throw new ValidationException((DBObject)updated, "Directory must have a valid path.");
        }
    }

    @Override
    @AbstractValidator.PropertyValidator(value={"schema"})
    public void validateSchema(Directory original, Directory updated) throws ValidationException {
        super.validateSchema(original, updated);
        Schema s = updated.getSchema();
        if (s != null && ModelUtil.areDifferent((Object)s.getName(), (Object)"SYS")) {
            throw new ValidationException((DBObject)updated, "Directory must be in SYS schema.");
        }
    }
}

