/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.validators.AbstractSchemaObjectValidator;
import oracle.javatools.db.validators.AbstractValidator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseLinkValidator
extends AbstractSchemaObjectValidator<DatabaseLink> {
    public DatabaseLinkValidator(DBObjectProvider prov) {
        super(prov);
    }

    @AbstractValidator.PropertyValidator(value={"host"})
    public void validateHost(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
    }

    @AbstractValidator.PropertyValidator(value={"public"})
    public void validatePublic(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
    }

    @AbstractValidator.PropertyValidator(value={"username"})
    public void validateUsername(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
        String uname;
        if (!dblink.isCurrentUser() && !ModelUtil.hasLength((String)(uname = dblink.getUsername()))) {
            throw new ValidationException((DBObject)dblink, DBArb.getString((int)410));
        }
    }

    @AbstractValidator.PropertyValidator(value={"password"})
    public void validatePassword(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
        if (original == null) {
            this.checkPassword(dblink);
        } else {
            DatabaseLink copy = (DatabaseLink)dblink.copyTo(null);
            copy.setPassword(original.getPassword());
            if (ModelUtil.areEqual((Object)original, (Object)copy)) {
                return;
            }
            this.checkPassword(dblink);
        }
    }

    private void checkPassword(DatabaseLink dblink) throws ValidationException {
        String upwd;
        String uname = dblink.getUsername();
        if (!dblink.isCurrentUser() && ModelUtil.hasLength((String)uname) && !ModelUtil.hasLength((String)(upwd = dblink.getPassword()))) {
            throw new ValidationException((DBObject)dblink, DBArb.getString((int)411));
        }
    }

    @AbstractValidator.PropertyValidator(value={"authentificationPassword"})
    public void validateAuthentificationPassword(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
        String apwd;
        if (dblink.isShared() && !ModelUtil.hasLength((String)(apwd = dblink.getAuthentificationPassword()))) {
            throw new ValidationException((DBObject)dblink, DBArb.getString((int)413));
        }
    }

    @AbstractValidator.PropertyValidator(value={"authentificationUsername"})
    public void validateAuthentificationUsername(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
        String auname;
        if (dblink.isShared() && !ModelUtil.hasLength((String)(auname = dblink.getAuthentificationUsername()))) {
            throw new ValidationException((DBObject)dblink, DBArb.getString((int)412));
        }
    }
}

