/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.Iterator;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SXMLGenerator
extends SXMLFragmentGenerator {
    private static final String SXML_VERSION_1 = "1.0";
    protected static final String SXML_VERSION_CURRENT = "1.0";
    private DBObject m_obj;
    private boolean m_buildParsedSQL = false;

    public SXMLGenerator() {
        this(new SXMLMappings());
    }

    SXMLGenerator(SXMLMappings mappings) {
        super.setMappings(mappings);
    }

    public boolean canGenerate(DBObject obj) {
        return this.canGenerate(obj.getType());
    }

    public boolean canGenerate(String type) {
        return this.getMappings().hasMappings(type) || this.getMappings().getGenerators(type) != null;
    }

    public void addMapping(String type, String elementPath, String propertyPath, SXMLValueConverter con) {
        this.getMappings().cache(type, elementPath, propertyPath, con);
    }

    public void removeMapping(String type, String elementPath, String propertyPath) {
        this.getMappings().uncache(type, elementPath, propertyPath);
    }

    public void addGenerator(String type, Class<? extends SXMLFragmentGenerator> gen) {
        this.getMappings().registerGen(type, gen);
    }

    public Document generateSXML(DBObject obj) {
        XMLDocument doc = new XMLDocument();
        this.m_obj = obj;
        String type = this.getType(obj);
        doc.setEncoding("UTF-8");
        if (obj instanceof ComplexType && "OBJECT".equals(((ComplexType)obj).getTypeCode()) && (this.alwaysUseComposite() || ((ComplexType)obj).getBodySource() != null && ((ComplexType)obj).getBodySource().length() > 0)) {
            this.populateCompositeDocForComplexType(doc, (ComplexType)obj);
            type = "COMPOSITE";
        } else if (obj instanceof Table && (this.alwaysUseComposite() || ((Table)obj).getIndexes() != null && ((Table)obj).getIndexes().length > 0)) {
            this.populateCompositeDocForTable(doc, (Table)obj, type);
            type = "COMPOSITE";
        } else {
            this.populateDoc(doc, obj, type);
        }
        XMLSchema schema = this.getMappings().getXSD(type);
        if (schema != null) {
            doc.setSchema(schema);
        }
        this.addComments(doc, obj);
        return doc;
    }

    protected boolean alwaysUseComposite() {
        return false;
    }

    protected void addComments(XMLDocument doc, DBObject obj) {
    }

    protected void populateDoc(XMLDocument doc, DBObject obj, String type) {
        Element node = doc.createElementNS("http://xmlns.oracle.com/ku", this.getMappings().getNodeName(type));
        node.setAttribute("version", "1.0");
        this.populateNode(node, (Document)doc, obj);
        doc.appendChild((Node)node);
    }

    private void populateCompositeDocForTable(XMLDocument doc, Table tab, String type) {
        Element composite = doc.createElementNS("http://xmlns.oracle.com/ku", "COMPOSITE");
        composite.setAttribute("version", "1.0");
        doc.appendChild((Node)composite);
        Element baseObject = doc.createElementNS("http://xmlns.oracle.com/ku", "BASE_OBJECT");
        composite.appendChild(baseObject);
        Element indexList = doc.createElementNS("http://xmlns.oracle.com/ku", "INDEX_LIST");
        composite.appendChild(indexList);
        Element node = doc.createElementNS("http://xmlns.oracle.com/ku", type.replaceAll(" ", "_"));
        this.populateNode(node, (Document)doc, tab);
        baseObject.appendChild(node);
        node.setAttribute("version", "1.0");
        for (Index index : tab.getIndexes()) {
            Element indexNode = doc.createElementNS("http://xmlns.oracle.com/ku", "INDEX");
            this.populateNode(indexNode, (Document)doc, index);
            indexNode.setAttribute("version", "1.0");
            indexList.appendChild(indexNode);
        }
    }

    private void populateCompositeDocForComplexType(XMLDocument doc, ComplexType obj) {
        Element composite = doc.createElementNS("http://xmlns.oracle.com/ku", "COMPOSITE");
        composite.setAttribute("version", "1.0");
        doc.appendChild((Node)composite);
        Element base_object = doc.createElementNS("http://xmlns.oracle.com/ku", "BASE_OBJECT");
        composite.appendChild(base_object);
        Element spec = doc.createElementNS("http://xmlns.oracle.com/ku", "TYPE_SPEC");
        base_object.appendChild(spec);
        spec.setAttribute("version", "1.0");
        this.populateNode(spec, (Document)doc, obj);
        Element body = doc.createElementNS("http://xmlns.oracle.com/ku", "TYPE_BODY");
        composite.appendChild(body);
        body.setAttribute("version", "1.0");
        Node schemaNode = this.createNode((Document)doc, body, "SCHEMA");
        schemaNode.appendChild(doc.createTextNode(obj.getSchema().getName()));
        Node nameNode = this.findOrCreateNodeAfter((Document)doc, body, "NAME", "SCHEMA");
        nameNode.appendChild(doc.createTextNode(obj.getName()));
        Node plsqlNode = this.findOrCreateNodeAfter((Document)doc, body, "PLSQL_BLOCK", "NAME");
        plsqlNode.appendChild(doc.createTextNode(obj.getBodySource()));
    }

    @Override
    protected void populateNode(Node objNode, Document doc, Object obj) {
        this.populateNodeImpl(objNode, doc, obj);
        Iterator<Class<? extends SXMLFragmentGenerator>> gens = this.getMappings().getGenerators(this.getType(obj));
        if (gens != null) {
            while (gens.hasNext()) {
                try {
                    SXMLFragmentGenerator gen = gens.next().newInstance();
                    gen.setParentGenerator(this);
                    gen.populateNode(objNode, doc, obj);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void populateNodeImpl(Node objNode, Document doc, Object obj) {
        String type = this.getType(obj);
        Iterator<SXMLMappings.Mapping> maps = this.getMappings().getMappings(type);
        while (maps.hasNext()) {
            SXMLMappings.Mapping map = maps.next();
            this.processPropertyMapping(objNode, doc, obj, map);
        }
    }

    String getTopLevelObjectSchemaName() {
        String retval = null;
        if (this.m_obj instanceof SchemaObject && ((SchemaObject)this.m_obj).getSchema() != null) {
            retval = ((SchemaObject)this.m_obj).getSchema().getName();
        }
        return retval;
    }

    @Override
    protected void readNode(Node parent, Object obj) {
    }

    public void setBuildParsedSQL(boolean buildParsedSQL) {
        this.m_buildParsedSQL = buildParsedSQL;
    }

    public boolean isBuildParsedSQL() {
        return this.m_buildParsedSQL;
    }
}

