/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.PlSqlMethod;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class PlSqlMethodGenerator
extends SXMLFragmentGenerator {
    PlSqlMethodGenerator() {
    }

    protected void populateNode(Node parent, Document doc, Object obj) {
        if (obj instanceof PlSqlMethod) {
            PlSqlMethod method = (PlSqlMethod)obj;
            if (method.getMethodType().equals((Object)PlSqlMethod.MethodType.CONSTRUCTOR)) {
                Node mtNode = this.createNode(doc, parent, "CONSTRUCTOR_FUNCTION");
                this.populateSubProgramNode(mtNode, doc, method, true);
            } else {
                String methodType = method.getMethodType().toString();
                String subProgramType = method.getReturnTypeID() == null ? "PROCEDURE" : "FUNCTION";
                Node mtNode = this.createNode(doc, parent, methodType);
                Node spNode = this.createNode(doc, mtNode, subProgramType);
                this.populateSubProgramNode(spNode, doc, method, false);
            }
        }
    }

    private void populateSubProgramNode(Node parent, Document doc, PlSqlMethod method, boolean constructor) {
        Node node;
        if (constructor) {
            node = this.createNode(doc, parent, "DATATYPE");
            node.appendChild(doc.createTextNode("UDT"));
        } else {
            node = this.createNode(doc, parent, "NAME");
            node.appendChild(doc.createTextNode(method.getName()));
        }
        for (PlSqlParameter p : method.getParameters()) {
            Node paramListNode = this.findOrCreateNode(doc, parent, "PARAMETER_LIST");
            Node paramNode = this.createNode(doc, paramListNode, "PARAMETER_LIST_ITEM");
            this.getParentGenerator().populateNode(paramNode, doc, p);
        }
        if (constructor) {
            this.createNode(doc, parent, "RETURN_SELF");
        } else if ((method.getSqljSigName() != null || method.getSqljSigVarName() != null) && method.getReturnTypeID().equals(method.getParent().getID())) {
            this.createNode(doc, parent, "RETURN_SELF");
        } else if (method.getReturnTypeID() != null) {
            Node returnNode = this.createNode(doc, parent, "RETURN");
            DataTypeSXMLGenerator dtgen = new DataTypeSXMLGenerator();
            dtgen.setParentGenerator(this.getParentGenerator());
            dtgen.populateNode(returnNode, doc, method);
        }
        if (method.getCallSpecLanguage() != null) {
            Node callSpecNode = this.createNode(doc, parent, "CALL_SPEC");
            Node langNode = this.createNode(doc, callSpecNode, "LANGUAGE");
            if (method.getCallSpecLanguage() == PlSqlMethod.CallSpecLanguage.JAVA) {
                this.createNode(doc, langNode, "JAVA");
            } else {
                this.createNode(doc, langNode, "C");
            }
            if (method.getCallSpecName() != null) {
                Node node2 = this.createNode(doc, callSpecNode, "NAME");
                node2.appendChild(doc.createTextNode(method.getCallSpecName()));
            }
            if (method.getCallSpecLibName() != null) {
                Node node3 = this.createNode(doc, callSpecNode, "LIBRARY");
                node3.appendChild(doc.createTextNode(method.getCallSpecLibName()));
            }
            if (method.isCallSpecWithContext()) {
                this.createNode(doc, callSpecNode, "WITH_CONTEXT");
            }
        } else if (method.getSqljSigName() != null) {
            node = this.createNode(doc, parent, "EXTERNAL_NAME");
            node.appendChild(doc.createTextNode(method.getSqljSigName()));
        } else if (method.getSqljSigVarName() != null) {
            node = this.createNode(doc, parent, "EXTERNAL_VARIABLE_NAME");
            node.appendChild(doc.createTextNode(method.getSqljSigVarName()));
        }
    }

    protected void readNode(Node parent, Object obj) {
    }
}

