/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PlSqlAttribute;
import oracle.javatools.db.PlSqlMethod;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.resource.OracleTypesBundle;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataTypeSXMLGenerator
extends SXMLFragmentGenerator {
    private static Map<String, TypesFromXSD> s_dtMap;
    private static final String DEFAULTED_SCALE = "CUSTOMER_AREA/ODB_PROPERTY_LIST/DEFAULTED_SCALE";

    DataTypeSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
        SQLFragment frag;
        DBObjectProvider pro;
        ObjectTypeUsage dtu = null;
        Node dtNode = null;
        if (obj instanceof Column) {
            if (!(((Column)obj).getRelation() instanceof View)) {
                dtNode = this.findOrCreateNodeAfter(doc, parent, "DATATYPE", "NAME");
                dtu = ((Column)obj).getDataTypeUsage();
            }
        } else if (obj instanceof PlSqlAttribute) {
            dtNode = this.findOrCreateNodeAfter(doc, parent, "DATATYPE", "NAME");
            dtu = ((PlSqlAttribute)obj).getDataTypeUsage();
        } else if (obj instanceof PlSqlParameter) {
            PlSqlParameter param = (PlSqlParameter)obj;
            dtu = new ObjectTypeUsage();
            dtu.setDataTypeID(param.getDataTypeID());
            dtNode = this.nodeExists(parent, "NO_COPY") ? this.findOrCreateNodeAfter(doc, parent, "DATATYPE", "NO_COPY") : (this.nodeExists(parent, "IN_OUT") ? this.findOrCreateNodeAfter(doc, parent, "DATATYPE", "IN_OUT") : (this.nodeExists(parent, "OUT") ? this.findOrCreateNodeAfter(doc, parent, "DATATYPE", "OUT") : this.findOrCreateNodeAfter(doc, parent, "DATATYPE", "NAME")));
        } else if (obj instanceof PlSqlMethod) {
            PlSqlMethod method = (PlSqlMethod)obj;
            dtu = new ObjectTypeUsage();
            dtu.setDataTypeID(method.getReturnTypeID());
            dtNode = this.createNode(doc, parent, "DATATYPE");
        } else if (obj instanceof ComplexType) {
            ComplexType ct = (ComplexType)obj;
            if ("COLLECTION".equals(ct.getTypeCode())) {
                Node collNode;
                if ("VARYING ARRAY".equals(ct.getCollectionType())) {
                    collNode = this.findOrCreateNode(doc, parent, "VARRAY");
                    if (ct.getLimit() != null) {
                        Node n = this.findOrCreateNode(doc, collNode, "LIMIT");
                        n.appendChild(doc.createTextNode(ct.getLimit().toString()));
                    }
                } else {
                    collNode = this.findOrCreateNode(doc, parent, "NESTED_TABLE");
                }
                dtNode = this.findOrCreateNode(doc, collNode, "DATATYPE");
                dtu = ct.getOfTypeUsage();
                if (dtu == null) {
                    this.addErrorMessage(obj, "No DTU");
                }
            }
        } else if (obj instanceof SQLFragment && (pro = this.getProvider((DBObject)(frag = (SQLFragment)obj), true)) != null) {
            String datatype = frag.getSQLText();
            dtu = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)pro, null, (String)datatype);
            dtNode = this.createNode(doc, parent, "DATATYPE");
        }
        if (dtu != null) {
            try {
                String dataTypeElementText;
                DataType type = DataTypeHelper.getDataType(dtu);
                boolean isRef = false;
                if (type == null && dtu.getDataTypeID() instanceof ReferenceID) {
                    ReferenceID id = (ReferenceID)dtu.getDataTypeID();
                    DBObjectID parID = dtu.getDataTypeID().getParent();
                    if ("DATATYPE".equals(id.getType())) {
                        type = this.createType((BaseObjectID)id);
                    } else if ("REF".equals(id.getType())) {
                        DBObject par = null;
                        try {
                            par = parID.resolveID();
                        }
                        catch (DBException e) {
                            DBLog.logStackTrace((Throwable)e);
                        }
                        if (par instanceof ComplexType) {
                            type = (ComplexType)par;
                        } else if (parID instanceof BaseObjectID) {
                            type = this.createType((BaseObjectID)parID);
                        }
                        isRef = true;
                    }
                }
                if (type == null) {
                    dataTypeElementText = DataTypeHelper.getDDL((DataTypeUsage)dtu);
                    this.addErrorMessage(obj, "Unrecognized datatype " + dataTypeElementText);
                } else {
                    dataTypeElementText = isRef ? "REF" : DataTypeSXMLGenerator.getDataTypeElementText(type, (DataTypeUsage)dtu);
                }
                dtNode.appendChild(doc.createTextNode(dataTypeElementText));
                if (type instanceof ComplexType) {
                    Schema s = ((ComplexType)type).getSchema();
                    String name = dataTypeElementText.equals("XMLTYPE") ? dataTypeElementText : ((ComplexType)type).getName();
                    if (s != null) {
                        Node sNode = this.findOrCreateNodeAfter(doc, dtNode.getParentNode(), "TYPE_PROPERTIES/SCHEMA", "DATATYPE");
                        sNode.appendChild(doc.createTextNode(s.getName()));
                    }
                    if (ModelUtil.hasLength((String)name)) {
                        Node nameNode = this.findOrCreateNodeAfter(doc, dtNode.getParentNode(), "TYPE_PROPERTIES/NAME", "DATATYPE");
                        nameNode.appendChild(doc.createTextNode(name));
                    }
                } else {
                    Object length;
                    Object precision;
                    Object scale = dtu.getAttributeValue("scale");
                    if (scale == null && "TIMESTAMP".equals(dataTypeElementText)) {
                        scale = 6;
                        if (obj instanceof Column) {
                            this.findOrCreateNode(doc, parent, DEFAULTED_SCALE);
                        }
                    }
                    if (scale != null) {
                        Node node = this.findOrCreateNodeAfter(doc, dtNode.getParentNode(), "scale".toUpperCase(), "DATATYPE");
                        node.appendChild(doc.createTextNode(scale.toString()));
                    }
                    if ((precision = dtu.getAttributeValue("precision")) != null) {
                        Node node = this.findOrCreateNodeAfter(doc, dtNode.getParentNode(), "precision".toUpperCase(), "DATATYPE");
                        node.appendChild(doc.createTextNode(precision.toString()));
                    }
                    if ((length = dtu.getAttributeValue("size")) != null) {
                        Node node = this.findOrCreateNodeAfter(doc, dtNode.getParentNode(), "LENGTH", "DATATYPE");
                        node.appendChild(doc.createTextNode(length.toString()));
                    }
                    if ("CHAR".equals(dtu.getAttributeValue("unit"))) {
                        this.findOrCreateNodeAfter(doc, dtNode.getParentNode(), "CHAR_SEMANTICS", "LENGTH");
                    }
                }
            }
            catch (DBException dbe) {
                DBLog.logStackTrace((Throwable)dbe);
            }
        }
    }

    private ComplexType createType(BaseObjectID id) {
        ComplexType retval = null;
        if (id.getParent() == null) {
            String schemaName = id.getSchemaName();
            String name = id.getName();
            retval = new ComplexType(name, new Schema(schemaName));
            retval.setTypeCode("OBJECT");
        }
        return retval;
    }

    private void addErrorMessage(Object obj, String err) {
        String message;
        ComplexType owningType;
        if (obj instanceof ComplexType) {
            owningType = (ComplexType)obj;
            message = "Type " + owningType.getName();
        } else if (obj instanceof PlSqlAttribute) {
            owningType = (ComplexType)((PlSqlAttribute)obj).getParent();
            message = "Attribute " + owningType.getName() + "." + ((PlSqlAttribute)obj).getName();
        } else if (obj instanceof PlSqlMethod) {
            owningType = (ComplexType)((PlSqlMethod)obj).getParent();
            message = "Method " + owningType.getName() + "." + ((PlSqlMethod)obj).getName();
        } else if (obj instanceof PlSqlParameter) {
            PlSqlMethod method = (PlSqlMethod)((PlSqlParameter)obj).getParent();
            owningType = (ComplexType)method.getParent();
            message = "Parameter " + owningType.getName() + "." + method.getName() + "." + ((PlSqlParameter)obj).getName();
        } else {
            return;
        }
        owningType.addDeclaratorError(message + ": " + err);
    }

    static final String getDataTypeElementText(DataType type, DataTypeUsage dtu) {
        String dataTypeElementText = null;
        if (type instanceof ComplexType) {
            String collectionType = ((ComplexType)type).getCollectionType();
            dataTypeElementText = "TABLE".equals(collectionType) ? "NESTED_TABLE" : ("VARYING ARRAY".equals(collectionType) ? "VARRAY" : ("SYS".equals(((ComplexType)type).getSchema().getName()) && "XMLTYPE".equalsIgnoreCase(((ComplexType)type).getName()) ? "XMLTYPE" : "UDT"));
        } else if (type != null) {
            Map<String, TypesFromXSD> typeMap = DataTypeSXMLGenerator.getDatatypeMap();
            if (typeMap.containsKey(dataTypeElementText = type.getName())) {
                dataTypeElementText = typeMap.get(dataTypeElementText).toString();
            }
            if ("TIMESTAMP".equals(dataTypeElementText)) {
                Object tz = dtu.getAttributeValue("time_zone");
                if ("TIME ZONE".equals(tz)) {
                    dataTypeElementText = TypesFromXSD.TIMESTAMP_WITH_TIMEZONE.toString();
                } else if ("LOCAL TIME ZONE".equals(tz)) {
                    dataTypeElementText = TypesFromXSD.TIMESTAMP_WITH_LOCAL_TIMEZONE.toString();
                }
            }
        }
        if (dataTypeElementText == null) {
            DBLog.getLogger(DataTypeSXMLGenerator.class).log(Level.WARNING, "SXML - Invalid datatype: \"{0}\" ", new Object[]{type == null ? null : type.getName()});
        }
        return dataTypeElementText;
    }

    @Override
    protected void readNode(Node parent, Object obj) {
        String dataTypeName = this.nodeText(parent, "DATATYPE");
        PredefinedDataTypeUsage dtu = null;
        if ("NESTED_TABLE".equals(dataTypeName) || "VARRAY".equals(dataTypeName) || "XMLTYPE".equals(dataTypeName) || "UDT".equals(dataTypeName)) {
            Schema schema;
            String schemaName = this.nodeText(parent, "TYPE_PROPERTIES/SCHEMA");
            String typeName = this.nodeText(parent, "TYPE_PROPERTIES/NAME");
            String XMLType = OracleTypesBundle.get("TYPE_XMLTYPE_NAME");
            if (typeName.toUpperCase().equals(XMLType.toUpperCase())) {
                typeName = XMLType;
            }
            if ("XMLTYPE".equals(dataTypeName)) {
                SXMLReader reader;
                DBObjectProvider pro;
                if (schemaName == null) {
                    schemaName = "SYS";
                    schema = new Schema(schemaName);
                }
                if ((pro = (reader = (SXMLReader)this.getParentGenerator()).getProvider()) != null) {
                    dtu = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)pro, null, (String)(schemaName + "." + dataTypeName));
                }
            }
            if (dtu == null) {
                schema = new Schema(schemaName);
                ComplexType ot = new ComplexType(typeName, schema);
                DBObjectID id = null;
                DBObjectProvider pro = ((SXMLReader)this.getParentGenerator()).getProvider();
                if (pro != null) {
                    try {
                        SchemaObject so = pro.getObject("TYPE", schema, typeName);
                        if (so instanceof ComplexType) {
                            id = so.getID();
                        }
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
                if (id == null) {
                    NameBasedID nid = new NameBasedID();
                    nid.setName(typeName);
                    nid.setSchema(schema);
                    nid.setType("TYPE");
                    id = nid;
                }
                ot.setID(id);
                if ("NESTED_TABLE".equals(dataTypeName)) {
                    ot.setTypeCode("COLLECTION");
                    ot.setCollectionType("TABLE");
                } else if ("VARRAY".equals(dataTypeName)) {
                    ot.setTypeCode("COLLECTION");
                    ot.setCollectionType("VARYING ARRAY");
                } else {
                    ot.setTypeCode("OBJECT");
                    ot.setCollectionType(null);
                }
                dtu = new ObjectTypeUsage(ot);
            }
        } else if (dataTypeName != null) {
            DataTypeRegistry dtr = DataTypeRegistry.getInstance();
            DataType dataType = dtr.findDataType(dataTypeName, Oracle11g.class);
            if (dataType == null) {
                try {
                    TypesFromXSD t = TypesFromXSD.valueOf(dataTypeName);
                    for (String dt : DataTypeSXMLGenerator.getDatatypeMap().keySet()) {
                        if (!DataTypeSXMLGenerator.getDatatypeMap().get(dt).equals((Object)t)) continue;
                        dataTypeName = dt;
                        dataType = dtr.findDataType(dataTypeName, Oracle11g.class);
                        break;
                    }
                }
                catch (IllegalArgumentException iae) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "SXML - Invalid column datatype \"{0}\"", dataTypeName);
                }
            }
            if (dataType != null) {
                String scale;
                String precision;
                dtu = new PredefinedDataTypeUsage((PredefinedDataType)dataType);
                HashMap<String, Object> dtAttrs = new HashMap<String, Object>();
                String length = this.nodeText(parent, "LENGTH");
                if (length != null) {
                    dtAttrs.put("size", Long.valueOf(length));
                }
                if ((precision = this.nodeText(parent, "PRECISION")) != null) {
                    dtAttrs.put("precision", Long.valueOf(precision));
                }
                if ((scale = this.nodeText(parent, "SCALE")) != null && !this.nodeExists(parent, DEFAULTED_SCALE)) {
                    dtAttrs.put("scale", Long.valueOf(scale));
                }
                if (this.nodeExists(parent, "CHAR_SEMANTICS")) {
                    dtAttrs.put("unit", "CHAR");
                }
                dtu.setAttributeValues(dtAttrs);
            }
        }
        if (obj instanceof Column) {
            ((Column)obj).setDataTypeUsage(dtu);
        } else if (obj instanceof PlSqlAttribute) {
            ((PlSqlAttribute)obj).setDataTypeUsage(dtu);
        } else if (obj instanceof PlSqlAttribute) {
            ((PlSqlParameter)obj).setDataTypeID(dtu.getDataTypeID());
        } else if (obj instanceof ComplexType) {
            ((ComplexType)obj).setOfTypeUsage(dtu);
        }
    }

    private static final synchronized Map<String, TypesFromXSD> getDatatypeMap() {
        if (s_dtMap == null) {
            s_dtMap = new HashMap<String, TypesFromXSD>();
            s_dtMap.put("CHAR VARYING", TypesFromXSD.VARCHAR2);
            s_dtMap.put("CHARACTER", TypesFromXSD.CHAR);
            s_dtMap.put("CHARACTER VARYING", TypesFromXSD.VARCHAR2);
            s_dtMap.put("DEC", TypesFromXSD.NUMBER);
            s_dtMap.put("DECIMAL", TypesFromXSD.NUMBER);
            s_dtMap.put("DOUBLE PRECISION", TypesFromXSD.NUMBER);
            s_dtMap.put("INT", TypesFromXSD.NUMBER);
            s_dtMap.put("INTEGER", TypesFromXSD.NUMBER);
            s_dtMap.put("INTERVAL YEAR", TypesFromXSD.INTERVAL_YEAR_TO_MONTH);
            s_dtMap.put("INTERVAL DAY", TypesFromXSD.INTERVAL_DAY_TO_SECOND);
            s_dtMap.put("LONG RAW", TypesFromXSD.LONG_RAW);
            s_dtMap.put("LONG VARCHAR", TypesFromXSD.CLOB);
            s_dtMap.put("NATIONAL CHAR", TypesFromXSD.NCHAR);
            s_dtMap.put("NATIONAL CHARACTER", TypesFromXSD.NCHAR);
            s_dtMap.put("NATIONAL CHAR VARYING", TypesFromXSD.NCHAR);
            s_dtMap.put("NATIONAL CHARACTER VARYING", TypesFromXSD.NCHAR);
            s_dtMap.put("NCHAR VARYING", TypesFromXSD.NCHAR);
            s_dtMap.put("NUMERIC", TypesFromXSD.NUMBER);
            s_dtMap.put("REAL", TypesFromXSD.NUMBER);
            s_dtMap.put("SMALLINT", TypesFromXSD.NUMBER);
            s_dtMap.put("VARCHAR", TypesFromXSD.VARCHAR2);
        }
        return s_dtMap;
    }

    private DBObjectProvider getProvider(DBObject obj, boolean up) {
        if (obj.getID() instanceof BaseObjectID && ((BaseObjectID)obj.getID()).getProvider() != null) {
            return ((BaseObjectID)obj.getID()).getProvider();
        }
        if (up && obj.getParent() != null) {
            return this.getProvider(obj.getParent(), true);
        }
        for (DBObject kid : obj.getOwnedObjects()) {
            DBObjectProvider p = this.getProvider(kid, false);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypesFromXSD {
        CHAR,
        VARCHAR2,
        NCHAR,
        NVARCHAR2,
        NUMBER,
        FLOAT,
        BINARY_FLOAT,
        BINARY_DOUBLE,
        LONG,
        LONG_RAW,
        RAW,
        DATE,
        TIMESTAMP,
        TIMESTAMP_WITH_TIMEZONE,
        TIMESTAMP_WITH_LOCAL_TIMEZONE,
        INTERVAL_YEAR_TO_MONTH,
        INTERVAL_DAY_TO_SECOND,
        TIME,
        TIME_WITH_TIMEZONE,
        BLOB,
        CLOB,
        NCLOB,
        BFILE,
        ROWID,
        UROWID,
        MLSLABEL,
        UDT,
        NESTED_TABLE,
        VARRAY,
        OPAQUE,
        REF,
        XMLTYPE;

    }
}

