/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddlgen;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;

public class OracleSourceDDLGenerator {
    protected static final String SP = " ";
    protected static final String SP2 = "  ";
    protected static final String SP4 = "    ";
    protected static final String NEWLINE = "\n";
    protected static final String SEMICOLON = ";";
    protected static final String AS = "AS";
    protected static final String BEGIN = "BEGIN";
    protected static final String CREATE_OR_REPLACE = "CREATE OR REPLACE";
    protected static final String BODY = "BODY";
    protected static final String END = "END";
    protected static final String NULL = "NULL";
    protected static final String RETURN = "RETURN";

    public static String defaultBodyForSpec(SpecPlSql obj, String externalName) {
        StringBuffer body = new StringBuffer();
        body.append(OracleSourceDDLGenerator.kw(CREATE_OR_REPLACE)).append(NEWLINE);
        body.append(OracleSourceDDLGenerator.kw(obj.getType())).append(SP).append(OracleSourceDDLGenerator.kw(BODY)).append(SP).append(OracleSourceDDLGenerator.kw(externalName)).append(SP).append(OracleSourceDDLGenerator.kw(AS));
        obj.getSource();
        PlSqlInterrogator pi = obj.getSourceInterrogator();
        PlSqlFragment frag = pi.getRoot();
        if (frag != null && frag.getChildren() != null) {
            frag = frag.getChildren()[0];
        }
        if (frag != null) {
            for (PlSqlFragment subFrag : frag.getChildren()) {
                if (subFrag.getFramentType() != PlSqlFragment.Type.PROCEDURE_FD && subFrag.getFramentType() != PlSqlFragment.Type.FUNCTION_FD) continue;
                String fd = subFrag.getSource();
                PlSqlToken tok = subFrag.getFirstToken();
                while (!tok.matches("FUNCTION") && !tok.matches("PROCEDURE")) {
                    tok = tok.getNextCodeToken();
                }
                tok = tok.getNextCodeToken();
                String methodName = tok.getSource();
                int pos = fd.length();
                if (obj.getType().equals("PACKAGE")) {
                    pos = fd.lastIndexOf(SEMICOLON);
                }
                body.append(NEWLINE).append(NEWLINE).append(SP2);
                body.append(fd.substring(0, pos)).append(SP).append(OracleSourceDDLGenerator.kw(AS));
                body.append(NEWLINE).append(SP2).append(OracleSourceDDLGenerator.kw(BEGIN));
                body.append(NEWLINE).append(SP4).append(DBArb.getString((int)385));
                body.append(NEWLINE).append(SP4);
                if (subFrag.getFramentType() == PlSqlFragment.Type.FUNCTION_FD) {
                    body.append(OracleSourceDDLGenerator.kw(RETURN)).append(SP);
                }
                body.append(OracleSourceDDLGenerator.kw(NULL)).append(SEMICOLON);
                body.append(NEWLINE).append(SP2).append(OracleSourceDDLGenerator.kw(END)).append(SP).append(methodName).append(SEMICOLON);
            }
        }
        body.append(NEWLINE).append(NEWLINE).append(OracleSourceDDLGenerator.kw(END));
        if (!(obj instanceof ComplexType)) {
            body.append(SP).append(OracleSourceDDLGenerator.kw(externalName));
        }
        body.append(SEMICOLON);
        return body.toString();
    }

    protected static String kw(String str) {
        boolean lowercasePlSql;
        GlobalSettings settings = GlobalSettings.getInstance();
        boolean bl = lowercasePlSql = settings != null && settings.isNewPlSqlLowerCase();
        if (str != null && lowercasePlSql && !str.startsWith("\"") && !str.startsWith("'")) {
            return str.toLowerCase();
        }
        return str;
    }
}

