/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Function;
import oracle.javatools.db.Package;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Procedure;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.DBSourceBuilder;
import oracle.javatools.db.plsql.PlSqlDeclarator;
import oracle.javatools.db.plsql.PlSqlDeclaratorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlSqlSourceBuilder
extends DBSourceBuilder<PlSql> {
    PlSqlSourceBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
        if (!("FUNCTION".equals(type) || "PROCEDURE".equals(type) || "PACKAGE".equals(type) || "TYPE".equals(type) || "TRIGGER".equals(type))) {
            throw new IllegalArgumentException("Illegal object type: " + type);
        }
    }

    @Override
    protected String getQuery() {
        return "SELECT /*OracleDictionaryQueries.ALL_PL_SQL_SOURCE_QUERY*/\n       TEXT FROM SYS.ALL_SOURCE WHERE TYPE = ? AND OWNER = ? AND NAME = ? ORDER BY LINE";
    }

    public PlSql createObject(String name, Schema schema, DBObjectID id) {
        Function result = null;
        String type = this.getObjectType();
        if ("FUNCTION".equals(type)) {
            result = new Function(name, schema);
        } else if ("PROCEDURE".equals(type)) {
            result = new Procedure(name, schema);
        } else if ("PACKAGE".equals(type)) {
            result = new Package(name, schema);
        } else if ("TYPE".equals(type)) {
            result = new ComplexType(name, schema);
        }
        if (result != null) {
            result.setID(id);
        }
        return result;
    }

    protected void fillInObject(PlSql plsql) throws DBException {
        PlSqlDeclarator builder;
        String src = this.getSource((SourceObject)plsql);
        plsql.setSource(src);
        if (plsql instanceof SpecPlSql) {
            SpecPlSql spec = (SpecPlSql)plsql;
            String body = this.getBodySource(spec);
            spec.setBodySource(body);
        }
        if ((builder = PlSqlDeclaratorFactory.getDeclarator((PlSql)plsql, (DBObjectProvider)this.getDatabase())) != null) {
            builder.loadDeclarativeInfo((SourceObject)plsql);
        }
    }
}

