/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.View;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleViewBuilder
extends OracleRelationBuilder<View> {
    protected OracleViewBuilder(BaseOracleDatabase db) {
        super(db, "VIEW");
    }

    public View createObject(String name, Schema schema, DBObjectID id) {
        View view = new View(name, schema);
        view.setID(id);
        return view;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery", "queryRestriction"})
    public void fillInQueryText(final View view) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_VIEW_TEXT_QUERY*/\n       TEXT_LENGTH, TEXT FROM SYS.ALL_VIEWS WHERE OWNER = ? AND VIEW_NAME = ?", view.getSchema(), view);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        int len = rs.getInt(1);
                        String txt = rs.getString(2);
                        if (txt != null) {
                            if (txt.toUpperCase().trim().endsWith("WITH CHECK OPTION")) {
                                view.setQueryRestriction("WITH CHECK OPTION");
                                txt = txt.substring(0, txt.toUpperCase().lastIndexOf("WITH") - 1);
                            } else if (txt.toUpperCase().trim().endsWith("WITH READ ONLY")) {
                                view.setQueryRestriction("WITH READ ONLY");
                                txt = txt.substring(0, txt.toUpperCase().lastIndexOf("WITH") - 1);
                            }
                            NonDeclarativeSQLQuery query = new NonDeclarativeSQLQuery(txt);
                            view.setSQLQuery((SQLQuery)query);
                        }
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)view, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

