/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTableBuilder<T extends Table>
extends OracleRelationBuilder<T> {
    protected OracleTableBuilder(BaseOracleDatabase db) {
        this(db, "TABLE");
    }

    protected OracleTableBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
    }

    public T createObject(String name, Schema schema, DBObjectID id) {
        Table table = new Table(name, schema);
        table.setID(id);
        return (T)table;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexes"}, depends={"TableType", "constraints"})
    public void fillInIndexes(T table) throws DBException {
        OracleIndexBuilder ib = (OracleIndexBuilder)this.getDatabase().getBuilderForType("INDEX");
        ib.fillInIndexes((SchemaObject)table);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"TableType", "NESTED TABLE", "OBJECT TABLE", "PARTITIONED TABLE"})
    public void fillInTableType(T table) throws DBException {
        String query = this.getTableTypeQuery();
        if (query == null) {
            table.setProperty("TableType", (Object)Table.TableType.NORMAL);
            table.setProperty("NESTED TABLE", null);
            table.setProperty("PARTITIONED TABLE", null);
            table.setProperty("OBJECT TABLE", null);
        } else {
            final Holder tryObjectQuery = new Holder((Object)true);
            QueryWrapper wrap = this.newQueryWrapper(query, table.getSchema(), table);
            wrap.executeQuery(new QueryWrapper.QueryRunnable((Table)table, wrap){
                final /* synthetic */ Table val$table;
                final /* synthetic */ QueryWrapper val$wrap;
                {
                    this.val$table = table;
                    this.val$wrap = queryWrapper;
                }

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            tryObjectQuery.set((Object)false);
                            this.val$table.setProperty("OBJECT TABLE", null);
                            OracleTableBuilder.this.setTableType(this.val$table, rs);
                        }
                    }
                    catch (SQLException ex) {
                        this.val$wrap.throwDBException((DBObject)this.val$table, ex);
                    }
                }
            });
            if (((Boolean)tryObjectQuery.get()).booleanValue()) {
                QueryWrapper wrap2 = this.newQueryWrapper(this.convertToObjectQuery(query), table.getSchema(), table);
                wrap2.executeQuery(new QueryWrapper.QueryRunnable((Table)table, wrap){
                    final /* synthetic */ Table val$table;
                    final /* synthetic */ QueryWrapper val$wrap;
                    {
                        this.val$table = table;
                        this.val$wrap = queryWrapper;
                    }

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            if (rs.next()) {
                                this.val$table.setProperty("OBJECT TABLE", (Object)Boolean.TRUE);
                                OracleTableBuilder.this.setTableType(this.val$table, rs);
                            }
                        }
                        catch (SQLException ex) {
                            this.val$wrap.throwDBException((DBObject)this.val$table, ex);
                        }
                    }
                });
            }
        }
    }

    private void setTableType(Table table, ResultSet rs) throws SQLException {
        boolean isNestedTable = "YES".equals(rs.getString(5));
        boolean isPartitionedTable = "YES".equals(rs.getString(4));
        Table.TableType type = Table.TableType.NORMAL;
        if ("IOT".equals(rs.getString(3))) {
            type = Table.TableType.INDEX_ORGANIZED;
        } else if ("Y".equals(rs.getString(1))) {
            String s = rs.getString(2);
            if ("SYS$SESSION".equals(s)) {
                type = Table.TableType.SESSION_TEMP;
            } else if ("SYS$TRANSACTION".equals(s)) {
                type = Table.TableType.TRANSACTION_TEMP;
            }
        } else if (!isNestedTable && "1".equals(rs.getString(6))) {
            type = Table.TableType.EXTERNAL;
        }
        table.setProperty("TableType", (Object)type);
        table.setProperty("NESTED TABLE", (Object)(isNestedTable ? Boolean.TRUE : null));
        table.setProperty("PARTITIONED TABLE", (Object)(isPartitionedTable ? Boolean.TRUE : null));
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleStorageProperties", "OracleExternalTableProperties", "compression", "parallel"}, depends={"TableType", "OBJECT TABLE", "NESTED TABLE", "PARTITIONED TABLE"})
    public void buildBaseProperties(T table) throws DBException {
        boolean isObjectTable = Boolean.TRUE.equals(table.getProperty("OBJECT TABLE"));
        String query = this.getTableQuery();
        if (isObjectTable) {
            query = this.convertToObjectQuery(query);
        }
        QueryWrapper wrap = this.newQueryWrapper(query, table.getSchema(), table);
        wrap.executeQuery(new QueryWrapper.QueryRunnable((Table)table, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        OracleTableBuilder.this.getBasePropertiesFromRS(this.val$table, rs);
                    }
                }
                catch (SQLException ex) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, ex);
                }
            }
        });
    }

    private void getBasePropertiesFromRS(T table, ResultSet rs) throws SQLException, DBException {
        boolean isNestedTable = Boolean.TRUE.equals(table.getProperty("NESTED TABLE"));
        boolean isPartitionedTable = Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"));
        Table.TableType type = (Table.TableType)table.getProperty("TableType");
        boolean compression = "ENABLED".equals(rs.getString(15));
        String degree = rs.getString(16);
        if (degree != null) {
            degree = degree.trim();
        }
        if (degree != null && degree.equals("DEFAULT")) {
            degree = "0";
        } else if ("1".equals(degree)) {
            degree = null;
        }
        if (Table.TableType.NORMAL.equals((Object)type) && compression) {
            table.setProperty("compression", (Object)Boolean.TRUE);
        }
        if (degree != null) {
            table.setProperty("parallel", (Object)Integer.valueOf(degree));
        }
        if (type == Table.TableType.INDEX_ORGANIZED) {
            if (isPartitionedTable) {
                table.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_IOT_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, null PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   all_part_indexes\nwhere  owner = ?\nand    index_name = ?\n", table, this.getQueryObject(table).getName()));
            } else {
                table.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties(OracleDictionaryQueries.TABLE_IOT_STORAGE_PROPERTIES_QUERY, table, table.getName()));
            }
        } else if (type == Table.TableType.EXTERNAL) {
            table.setProperty("OracleExternalTableProperties", (Object)this.getExternalTableProperties(table));
        } else if (isPartitionedTable) {
            table.setProperty("OracleStorageProperties", (Object)this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, def_pct_used PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   all_part_tables\nwhere  owner = ?\nand    table_name = ?\n", table, table.getName()));
        } else {
            table.setProperty("OracleStorageProperties", (Object)OracleTableBuilder.getSegmentAttributeProperties(rs, this.getDatabase()));
        }
    }

    private static OracleStorageProperties getStorageProperties(ResultSet rs) throws SQLException {
        OracleStorageProperties properties = new OracleStorageProperties();
        int i = rs.getInt("INITIAL_EXTENT");
        Integer I = rs.wasNull() ? null : new Integer(i);
        properties.setInitialExtent(I);
        i = rs.getInt("NEXT_EXTENT");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setNextExtent(I);
        i = rs.getInt("MIN_EXTENTS");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setMinExtent(I);
        i = rs.getInt("MAX_EXTENTS");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setMaxExtent(I);
        i = rs.getInt("PCT_INCREASE");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setPercentIncrease(I);
        i = rs.getInt("FREELISTS");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setFreelists(I);
        i = rs.getInt("FREELIST_GROUPS");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setFreelistGroups(I);
        String s = rs.getString("BUFFER_POOL");
        properties.setBufferMode(ModelUtil.hasLength((String)s) ? OracleStorageProperties.BufferModes.valueOf((String)s) : null);
        return properties;
    }

    private OracleStorageProperties getSegmentAttributeProperties(String query, T table, String objectName) throws DBException {
        final Holder osp = new Holder();
        final QueryWrapper wrap = this.newQueryWrapper(query, table.getSchema(), objectName);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        osp.set((Object)OracleTableBuilder.getSegmentAttributeProperties(rs, OracleTableBuilder.this.getDatabase()));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)this.val$table, ex);
                }
            }
        };
        wrap.executeQuery(r);
        return (OracleStorageProperties)osp.get();
    }

    public static OracleStorageProperties getSegmentAttributeProperties(ResultSet rs, BaseOracleDatabase db) throws SQLException {
        String tablespaceName;
        OracleStorageProperties properties = OracleTableBuilder.getStorageProperties(rs);
        int i = rs.getInt("PCT_FREE");
        Integer I = rs.wasNull() ? null : new Integer(i);
        properties.setPercentFree(I);
        i = rs.getInt("PCT_USED");
        I = rs.wasNull() ? null : new Integer(i);
        properties.setPercentUsed(I);
        i = rs.getInt("INI_TRANS");
        I = rs.wasNull() || i == 0 ? null : new Integer(i);
        properties.setInitrans(I);
        if (db.getDatabaseVersion() == 92) {
            i = rs.getInt("MAX_TRANS");
            I = rs.wasNull() || i == 0 ? null : new Integer(i);
            properties.setMaxtrans(I);
        }
        if (ModelUtil.hasLength((String)(tablespaceName = rs.getString("TABLESPACE_NAME")))) {
            properties.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)db, tablespaceName));
        }
        String s = rs.getString("LOGGING");
        if (!rs.wasNull() && s != null) {
            properties.setLogging("YES".equalsIgnoreCase(s) ? Boolean.TRUE : Boolean.FALSE);
        }
        return properties;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleIndexOrganizedTableProperties"}, depends={"columns", "constraints", "TableType"})
    public void fillInIOTProperties(T table) throws DBException {
        if (table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
            table.setProperty("OracleIndexOrganizedTableProperties", (Object)this.getIotProperties(table));
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleTablePartitions"}, depends={"columns", "constraints", "TableType", "PARTITIONED TABLE"})
    public void fillInTablePartitions(T table) throws DBException {
        boolean isExternal = table.getProperty("TableType") == Table.TableType.EXTERNAL;
        boolean isPartitionedTable = Boolean.TRUE.equals(table.getProperty("PARTITIONED TABLE"));
        if (isPartitionedTable && !isExternal) {
            table.setProperty("OracleTablePartitions", (Object)this.getOracleTablePartitions(table));
        }
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
    public void fillInColumns(T table) throws DBException {
        super.fillInColumns(table);
        boolean getLobParameters = false;
        if (this.getDatabase().getDatabaseVersion() != 1) {
            for (Column col : table.getColumns()) {
                if (!LOBDescriptor.isLOBColumn((Column)col) && !LOBDescriptor.isVARRAYColumn((Column)col)) continue;
                getLobParameters = true;
                break;
            }
        }
        if (getLobParameters) {
            QueryWrapper wrap = this.newQueryWrapper(OracleTableBuilder.getLobParametersQuery(this.getDatabase().getDatabaseVersion()), table.getSchema(), table, table.getSchema(), table);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, wrap){
                final /* synthetic */ Table val$table;
                final /* synthetic */ QueryWrapper val$wrap;
                {
                    this.val$table = table;
                    this.val$wrap = queryWrapper;
                }

                public void processResultSet(ResultSet rs2) throws DBException {
                    try {
                        while (rs2.next()) {
                            LOBDescriptor lobDescriptor = new LOBDescriptor();
                            int chunk = rs2.getInt("CHUNK");
                            lobDescriptor.setChunk(rs2.wasNull() ? null : Integer.valueOf(chunk));
                            lobDescriptor.setLOBSegName(rs2.getString("SEGMENT_NAME"));
                            int pctVersion = rs2.getInt("PCTVERSION");
                            lobDescriptor.setPctVersion(rs2.wasNull() ? null : Integer.valueOf(pctVersion));
                            lobDescriptor.setStorageEnabledInRow("YES".equalsIgnoreCase(rs2.getString("IN_ROW")));
                            int freepools = rs2.getInt("FREEPOOLS");
                            lobDescriptor.setFreepools(rs2.wasNull() ? null : Integer.valueOf(freepools));
                            if (lobDescriptor.getPctVersion() == null) {
                                rs2.getInt("RETENTION");
                                lobDescriptor.setRetention(!rs2.wasNull());
                            }
                            String cache = rs2.getString("CACHE");
                            if (!rs2.wasNull() && cache != null) {
                                lobDescriptor.setCache(cache.equals("YES") ? "CACHE" : (cache.equals("NO") ? "NOCACHE" : (cache.equals("CACHEREADS") ? "CACHE READS" : null)));
                            }
                            OracleStorageProperties storage = OracleTableBuilder.getStorageProperties(rs2);
                            lobDescriptor.setStorage(storage);
                            String tablespaceName = rs2.getString("TABLESPACE_NAME");
                            if (ModelUtil.hasLength((String)tablespaceName)) {
                                storage.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleTableBuilder.this.getDatabase(), tablespaceName));
                            }
                            String logging = rs2.getString("LOGGING");
                            if (!rs2.wasNull() && logging != null) {
                                storage.setLogging("YES".equalsIgnoreCase(logging) ? Boolean.TRUE : Boolean.FALSE);
                            }
                            OracleColumnProperties ocp = new OracleColumnProperties();
                            Column col = this.val$table.getColumn(rs2.getString("COLUMN_NAME"));
                            if (col == null) continue;
                            if (LOBDescriptor.isLOBColumn((Column)col)) {
                                ocp.setLOBProperties(lobDescriptor);
                            } else if (LOBDescriptor.isVARRAYColumn((Column)col)) {
                                ocp.setVAProperties(lobDescriptor);
                            }
                            col.setProperty("OracleColumnProperties", (Object)ocp);
                        }
                    }
                    catch (SQLException ex) {
                        this.val$wrap.throwDBException((DBObject)this.val$table, ex);
                    }
                }
            };
            wrap.executeQuery(r);
        }
        boolean getXMLTypeColumnProps = false;
        if (this.getDatabase().getDescriptor().supportsFeature("XMLTYPE COLUMN STORAGE PROPERTIES")) {
            for (Column col : table.getColumns()) {
                DataTypeUsage dtu = col.getDataTypeUsage();
                if (dtu == null) continue;
                DataType dt = null;
                try {
                    dt = (DataType)dtu.getDataTypeID().resolveID();
                    if (!DataTypeHelper.isXMLType((DataType)dt)) continue;
                    getXMLTypeColumnProps = true;
                    break;
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
        if (getXMLTypeColumnProps) {
            QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_XMLTYPE_COLUMN_PROPERTIES_QUERY*/ \n       XTC.COLUMN_NAME, XTC.SCHEMA_OWNER, XTC.XMLSCHEMA, XTC.ELEMENT_NAME \n,      XTC.STORAGE_TYPE, XTC.ANYSCHEMA, XTC.NONSCHEMA \nFROM   ALL_XML_TAB_COLS XTC \nWHERE  XTC.OWNER = ? \nAND    XTC.TABLE_NAME = ?", table.getSchema(), table);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, wrap){
                final /* synthetic */ Table val$table;
                final /* synthetic */ QueryWrapper val$wrap;
                {
                    this.val$table = table;
                    this.val$wrap = queryWrapper;
                }

                public void processResultSet(ResultSet rs2) throws DBException {
                    try {
                        while (rs2.next()) {
                            XMLTypeColumnProperties props = new XMLTypeColumnProperties();
                            XMLTypeColumnProperties.StoreAs storeAs = null;
                            String storeAsStr = rs2.getString("STORAGE_TYPE");
                            storeAs = "BINARY".equals(storeAsStr) ? XMLTypeColumnProperties.StoreAs.BINARY_XML : ("OBJECT-RELATIONAL".equals(storeAsStr) ? XMLTypeColumnProperties.StoreAs.OBJECT_RELATIONAL : XMLTypeColumnProperties.StoreAs.valueOf((String)storeAsStr));
                            props.setStoreAs(storeAs);
                            String element = rs2.getString("ELEMENT_NAME");
                            if (ModelUtil.hasLength((String)element)) {
                                String xmlschemaOwner = rs2.getString("SCHEMA_OWNER");
                                String xmlschemaName = rs2.getString("XMLSCHEMA");
                                XMLSchema xmlschema = (XMLSchema)OracleTableBuilder.this.getProvider().getObject("XML SCHEMA", OracleTableBuilder.this.getSchema(xmlschemaOwner), xmlschemaName);
                                NameBasedID elemntid = new NameBasedID("XMLSchemaElement", element, xmlschema.getID());
                                props.setElementID((DBObjectID)elemntid);
                            } else {
                                props.setElementID(null);
                            }
                            props.setAllowAnySchema("YES".equals(rs2.getString("ANYSCHEMA")));
                            props.setAllowNonSchema("YES".equals(rs2.getString("NONSCHEMA")));
                            Column col = this.val$table.getColumn(rs2.getString("COLUMN_NAME"));
                            if (col == null) continue;
                            Object ld = null;
                            OracleColumnProperties ocp2 = (OracleColumnProperties)col.getProperty("OracleColumnProperties");
                            if (ocp2 == null) {
                                ocp2 = new OracleColumnProperties();
                                col.setProperty("OracleColumnProperties", (Object)ocp2);
                            }
                            ocp2.setXMLTypeColumnProperties(props);
                        }
                    }
                    catch (SQLException ex) {
                        this.val$wrap.throwDBException((DBObject)this.val$table, ex);
                    }
                }
            };
            wrap.executeQuery(r);
        }
    }

    protected OracleTablePartitions getOracleTablePartitions(T table) throws DBException {
        final Holder holder = new Holder();
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_TYPE_QUERY*/\n       apt.partitioning_type, apt.subpartitioning_type, apkc.column_name\nfrom   all_part_tables apt, all_part_key_columns apkc\nwhere  apt.owner = ?\nand    apt.table_name = ?\nand    apkc.owner = apt.owner\nand    apkc.name  = apt.table_name\nand    apkc.object_type = 'TABLE'\norder by apkc.column_position", table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        Column col;
                        OracleTablePartitions partitions = (OracleTablePartitions)holder.get();
                        if (partitions == null) {
                            String partitionType = rs.getString(1);
                            String subpartitionType = rs.getString(2);
                            if ("HASH".equals(partitionType) || "LIST".equals(partitionType) || "RANGE".equals(partitionType)) {
                                partitions = new OracleTablePartitions(OracleTablePartitions.PartitionType.valueOf((String)partitionType), OracleTablePartitions.ObjectType.PARTITION);
                                holder.set((Object)partitions);
                                NameBasedID parid = new NameBasedID((DBObject)partitions, this.val$table.getID());
                                partitions.setID((DBObjectID)parid);
                                if ("HASH".equals(subpartitionType) || "LIST".equals(subpartitionType)) {
                                    OracleTablePartitions subpartitionModel = new OracleTablePartitions(OracleTablePartitions.PartitionType.valueOf((String)subpartitionType), OracleTablePartitions.ObjectType.SUBPARTITION);
                                    subpartitionModel.setID((DBObjectID)new NameBasedID((DBObject)subpartitionModel, (DBObjectID)parid));
                                    partitions.setSubpartitionModel(subpartitionModel);
                                }
                            }
                        }
                        if (partitions == null || (col = this.val$table.getColumn(rs.getString(3))) == null) continue;
                        partitions.addPartitionColumn(col.getID());
                    }
                }
                catch (SQLException sqe) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, sqe);
                }
            }
        };
        wrap.executeQuery(r);
        final OracleTablePartitions partitions = (OracleTablePartitions)holder.get();
        if (partitions != null) {
            OracleTablePartitions subpartitionModel = partitions.getSubpartitionModel();
            final Map<String, List<LOBDescriptor>> lobPartitions = this.getPartitionLOBs(table, "select /*OracleDictionaryQueries.ALL_TABLE_LOB_PARTITIONS_QUERY*/\n       COLUMN_NAME, PARTITION_NAME NAME, LOB_PARTITION_NAME LOB_SEGMENT_NAME, CHUNK,\n       PCTVERSION, CACHE, IN_ROW, TABLESPACE_NAME, LOGGING, BUFFER_POOL,\n       decode(INITIAL_EXTENT, 'DEFAULT', null, INITIAL_EXTENT) INITIAL_EXTENT,\n       decode(NEXT_EXTENT, 'DEFAULT', null, NEXT_EXTENT) NEXT_EXTENT,\n       decode(MIN_EXTENTS, 'DEFAULT', null, MIN_EXTENTS) MIN_EXTENTS,\n       decode(MAX_EXTENTS, 'DEFAULT', null, MAX_EXTENTS) MAX_EXTENTS,\n       decode(PCT_INCREASE, 'DEFAULT', null, PCT_INCREASE) PCT_INCREASE,\n       decode(FREELISTS, 'DEFAULT', null, FREELISTS) FREELISTS,\n       decode(FREELIST_GROUPS, 'DEFAULT', null, FREELIST_GROUPS) FREELIST_GROUPS\nfrom   ALL_LOB_PARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_POSITION, COLUMN_NAME");
            final Map<String, OracleTablePartitions> partitionLevelSubpartitions = subpartitionModel != null ? this.getPartitionLevelSubpartitions(table, subpartitionModel.getPartitionType()) : null;
            final QueryWrapper wrap2 = this.newQueryWrapper(Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType") ? "select /*OracleDictionaryQueries.ALL_INDEX_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE, PARAMETERS\nfrom   all_ind_partitions aip\nwhere  aip.index_owner = ?\nand    aip.index_name  = ?\norder by aip.partition_position" : "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE\nfrom   all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position", table.getSchema(), this.getQueryObject(table));
            QueryWrapper.QueryRunnable r2 = new QueryWrapper.QueryRunnable((Table)table){
                final /* synthetic */ Table val$table;
                {
                    this.val$table = table;
                }

                public void processResultSet(ResultSet rs2) throws DBException {
                    try {
                        while (rs2.next()) {
                            TablePartition partition = partitions.createPartition(rs2.getString("PARTITION_NAME"));
                            partition.setID((DBObjectID)new NameBasedID((DBObject)partition, partitions.getID()));
                            OracleTableBuilder.this.initialisePartition(partition, rs2, lobPartitions, partitionLevelSubpartitions);
                        }
                    }
                    catch (SQLException sqe) {
                        wrap2.throwDBException((DBObject)this.val$table, sqe);
                    }
                }
            };
            wrap2.executeQuery(r2);
            if (subpartitionModel != null) {
                this.getSubpartitionColumns(table, subpartitionModel);
                this.getSubpartitionTemplates(table, subpartitionModel);
            }
        }
        return partitions;
    }

    private DBObject getQueryObject(T table) {
        if (Table.TableType.INDEX_ORGANIZED == table.getProperty("TableType")) {
            for (Constraint constraint : table.getConstraints()) {
                if (!(constraint instanceof PKConstraint)) continue;
                return constraint;
            }
        }
        return table;
    }

    private Map<String, List<LOBDescriptor>> getPartitionLOBs(T table, String query) throws DBException {
        HashMap<String, List<LOBDescriptor>> lobPartitions = new HashMap<String, List<LOBDescriptor>>();
        QueryWrapper wrap = this.newQueryWrapper(query, table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, lobPartitions, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ Map val$lobPartitions;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$lobPartitions = map;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        List<LOBDescriptor> lobItems;
                        Column col = this.val$table.getColumn(rs.getString("COLUMN_NAME"));
                        if (col == null) continue;
                        String partitionName = rs.getString("NAME");
                        if (!this.val$lobPartitions.containsKey(partitionName)) {
                            lobItems = new ArrayList();
                            this.val$lobPartitions.put(partitionName, lobItems);
                        } else {
                            lobItems = (List)this.val$lobPartitions.get(partitionName);
                        }
                        LOBDescriptor lobDescriptor = new LOBDescriptor();
                        lobItems.add(lobDescriptor);
                        lobDescriptor.addColumn(col.getID());
                        int chunk = rs.getInt("CHUNK");
                        lobDescriptor.setChunk(rs.wasNull() ? null : Integer.valueOf(chunk));
                        lobDescriptor.setLOBSegName(rs.getString("LOB_SEGMENT_NAME"));
                        int pctVersion = rs.getInt("PCTVERSION");
                        lobDescriptor.setPctVersion(rs.wasNull() ? null : Integer.valueOf(pctVersion));
                        lobDescriptor.setStorageEnabledInRow("YES".equalsIgnoreCase(rs.getString("IN_ROW")));
                        String cache = rs.getString("CACHE");
                        if (!rs.wasNull() && cache != null) {
                            lobDescriptor.setCache(cache.equals("YES") ? "CACHE" : (cache.equals("NO") ? "NOCACHE" : (cache.equals("CACHEREADS") ? "CACHE READS" : null)));
                        }
                        OracleStorageProperties storage = OracleTableBuilder.getStorageProperties(rs);
                        lobDescriptor.setStorage(storage);
                        String tablespaceName = rs.getString("TABLESPACE_NAME");
                        if (ModelUtil.hasLength((String)tablespaceName)) {
                            storage.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleTableBuilder.this.getDatabase(), tablespaceName));
                        }
                        String logging = rs.getString("LOGGING");
                        if (rs.wasNull() || logging == null) continue;
                        storage.setLogging("YES".equalsIgnoreCase(logging) ? Boolean.TRUE : Boolean.FALSE);
                    }
                }
                catch (SQLException sqe) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, sqe);
                }
            }
        };
        wrap.executeQuery(r);
        return lobPartitions;
    }

    private void initialisePartition(TablePartition partition, ResultSet rs, Map<String, List<LOBDescriptor>> lobPartitions, Map<String, OracleTablePartitions> partitionLevelSubpartitions) throws SQLException {
        if (partition != null && partition.getPartitionType() != null) {
            if (partition.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                this.initialiseHashPartition(partition, rs.getString("TABLESPACE_NAME"), lobPartitions);
            } else {
                OracleTablePartitions plSubpartitions;
                List<LOBDescriptor> lobDescriptors;
                partition.setValues(rs.getString("HIGH_VALUE"));
                String compression = rs.getString("COMPRESSION");
                if ("ENABLED".equals(compression)) {
                    partition.setCompression("COMPRESS");
                } else if ("DISABLED".equals(compression) || "NONE".equals(compression)) {
                    partition.setCompression("NOCOMPRESS");
                }
                partition.setSegmentAttributes(OracleTableBuilder.getSegmentAttributeProperties(rs, this.getDatabase()));
                if (lobPartitions != null && lobPartitions.containsKey(partition.getName()) && (lobDescriptors = lobPartitions.get(partition.getName())) != null) {
                    for (LOBDescriptor lob : lobDescriptors) {
                        lob.setID((DBObjectID)new NameBasedID((DBObject)lob, partition.getID()));
                        partition.addLOBDescriptor(lob);
                    }
                }
                if (partition.getPartitionType() == OracleTablePartitions.PartitionType.RANGE && partitionLevelSubpartitions != null && partitionLevelSubpartitions.containsKey(partition.getName()) && (plSubpartitions = partitionLevelSubpartitions.get(partition.getName())) != null) {
                    NameBasedID plsID = new NameBasedID((DBObject)plSubpartitions, partition.getID());
                    plSubpartitions.setID((DBObjectID)plsID);
                    for (TablePartition subpartition : plSubpartitions.getPartitions()) {
                        NameBasedID subpartid = new NameBasedID((DBObject)subpartition, (DBObjectID)plsID);
                        subpartition.setID((DBObjectID)subpartid);
                        LOBDescriptor[] lobDescriptors2 = subpartition.getLOBDescriptors();
                        if (lobDescriptors2 == null) continue;
                        for (LOBDescriptor lob : lobDescriptors2) {
                            NameBasedID id = new NameBasedID((DBObject)lob, (DBObjectID)subpartid);
                            lob.setID((DBObjectID)id);
                        }
                    }
                    partition.setPartitionLevelSubpartitions(plSubpartitions);
                }
            }
        } else assert (partition != null && partition.getPartitionType() != null);
    }

    private void initialiseHashPartition(TablePartition partition, String tsName, Map<String, List<LOBDescriptor>> lobPartitions) {
        this.addTablespace(partition, tsName);
        if (lobPartitions != null && lobPartitions.containsKey(partition.getName())) {
            List<LOBDescriptor> lobDescriptors = lobPartitions.get(partition.getName());
            for (int i = 0; i < lobDescriptors.size(); ++i) {
                LOBDescriptor partitionStorageLOB = new LOBDescriptor();
                partition.addLOBDescriptor(partitionStorageLOB);
                LOBDescriptor lob = lobDescriptors.get(i);
                NameBasedID id = new NameBasedID((DBObject)lob, partition.getID());
                partitionStorageLOB.setID((DBObjectID)id);
                partitionStorageLOB.setColumns(lob.getColumns());
                partitionStorageLOB.setLOBSegName(lob.getLOBSegName());
                if (lob.getStorage() == null || !ModelUtil.hasLength((String)lob.getStorage().getTablespace())) continue;
                this.addTablespace(partitionStorageLOB, lob.getStorage().getTablespace());
            }
        }
    }

    private void getSubpartitionColumns(T table, OracleTablePartitions subpartitions) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_COLUMNS_QUERY*/\n       COLUMN_NAME\nfrom   ALL_SUBPART_KEY_COLUMNS\nwhere  OWNER = ?\nand    NAME  = ?\norder by COLUMN_POSITION", table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, subpartitions, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ OracleTablePartitions val$subpartitions;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$subpartitions = oracleTablePartitions;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        Column col = this.val$table.getColumn(rs.getString(1));
                        if (col == null) continue;
                        this.val$subpartitions.addPartitionColumn(col.getID());
                    }
                }
                catch (SQLException sqe) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private void getSubpartitionTemplates(T table, final OracleTablePartitions subpartitions) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_TEMPLATES_QUERY*/\n       SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_BOUND\nfrom   ALL_SUBPARTITION_TEMPLATES\nwhere  USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_POSITION", table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String tablespaceName;
                        subpartitions.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
                        String name = rs.getString("SUBPARTITION_NAME");
                        TablePartition template = subpartitions.createPartition(name);
                        template.setID((DBObjectID)new NameBasedID((DBObject)template, subpartitions.getID()));
                        String values = rs.getString("HIGH_BOUND");
                        if (values != null && !rs.wasNull()) {
                            template.setValues(values);
                        }
                        if ((tablespaceName = rs.getString("TABLESPACE_NAME")) == null || rs.wasNull()) continue;
                        OracleTableBuilder.this.addTablespace(template, tablespaceName);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)this.val$table, sqe);
                }
            }
        };
        wrap.executeQuery(r);
        this.getSubpartitionLOBTemplates(table, subpartitions.getPartitions());
    }

    private void getSubpartitionLOBTemplates(T table, final TablePartition[] subpartitionTemplates) throws DBException {
        if (subpartitionTemplates.length > 0) {
            QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_LOB_TEMPLATES_QUERY*/\n       distinct SUBPARTITION_NAME, LOB_SEGMENT_NAME, TABLESPACE_NAME, LOB_COL_NAME\nfrom   ALL_LOB_TEMPLATES\nwhere  USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_NAME", table.getSchema(), table);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, wrap){
                final /* synthetic */ Table val$table;
                final /* synthetic */ QueryWrapper val$wrap;
                {
                    this.val$table = table;
                    this.val$wrap = queryWrapper;
                }

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            TablePartition template = OracleTableBuilder.this.findSubpartitionTemplate(rs.getString("SUBPARTITION_NAME"), subpartitionTemplates);
                            assert (template != null);
                            if (template == null) continue;
                            LOBDescriptor lobDescriptor = new LOBDescriptor();
                            template.addLOBDescriptor(lobDescriptor);
                            lobDescriptor.setID((DBObjectID)new NameBasedID((DBObject)lobDescriptor, template.getID()));
                            lobDescriptor.addColumn(this.val$table.getColumn(rs.getString("LOB_COL_NAME")).getID());
                            lobDescriptor.setLOBSegName(rs.getString("LOB_SEGMENT_NAME"));
                            String tablespaceName = rs.getString("TABLESPACE_NAME");
                            if (tablespaceName == null || rs.wasNull()) continue;
                            OracleTableBuilder.this.addTablespace(lobDescriptor, tablespaceName);
                        }
                    }
                    catch (SQLException sqe) {
                        this.val$wrap.throwDBException((DBObject)this.val$table, sqe);
                    }
                }
            };
            wrap.executeQuery(r);
        }
    }

    private TablePartition findSubpartitionTemplate(String name, TablePartition[] subpartitions) {
        for (int i = 0; i < subpartitions.length; ++i) {
            if (!subpartitions[i].getName().equals(name)) continue;
            return subpartitions[i];
        }
        return null;
    }

    private Map<String, OracleTablePartitions> getPartitionLevelSubpartitions(T table, final OracleTablePartitions.PartitionType partitionType) throws DBException {
        final HashMap<String, OracleTablePartitions> subpartitionMap = new HashMap<String, OracleTablePartitions>();
        final Map<String, List<LOBDescriptor>> lobSubpartitionMap = this.getPartitionLOBs(table, "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITION_LOBS_QUERY*/\n       LS.COLUMN_NAME\n,      LS.SUBPARTITION_NAME NAME\n,      LS.LOB_SUBPARTITION_NAME LOB_SEGMENT_NAME\n,      LS.CHUNK\n,      LS.PCTVERSION\n,      LS.CACHE\n,      LS.IN_ROW\n,      LS.TABLESPACE_NAME\n,      LS.LOGGING\n,      LS.BUFFER_POOL\n,      LS.INITIAL_EXTENT\n,      LS.NEXT_EXTENT\n,      LS.MIN_EXTENTS\n,      LS.MAX_EXTENTS\n,      LS.PCT_INCREASE\n,      LS.FREELISTS\n,      LS.FREELIST_GROUPS\nfrom   ALL_LOB_SUBPARTITIONS LS\n,      ALL_LOBS L\nwhere  LS.TABLE_OWNER = :1\nand    LS.TABLE_NAME  = :2\nand    LS.TABLE_OWNER = L.OWNER\nand    LS.TABLE_NAME = L.TABLE_NAME\nand    LS.COLUMN_NAME = L.COLUMN_NAME\norder by LS.SUBPARTITION_NAME");
        final QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION", table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    OracleTablePartitions subpartitions = null;
                    while (rs.next()) {
                        List lobDescriptors;
                        String partitionName = rs.getString("PARTITION_NAME");
                        if (!subpartitionMap.containsKey(partitionName)) {
                            subpartitions = new OracleTablePartitions(partitionType, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                            subpartitionMap.put(partitionName, subpartitions);
                        }
                        String subpartitionName = rs.getString("SUBPARTITION_NAME");
                        TablePartition subpartition = subpartitions.createPartition(subpartitionName);
                        subpartition.setValues(rs.getString("HIGH_VALUE"));
                        String tablespaceName = rs.getString("TABLESPACE_NAME");
                        if (tablespaceName != null && !rs.wasNull()) {
                            OracleTableBuilder.this.addTablespace(subpartition, tablespaceName);
                        }
                        if (lobSubpartitionMap == null || !lobSubpartitionMap.containsKey(subpartitionName) || (lobDescriptors = (List)lobSubpartitionMap.get(subpartitionName)) == null) continue;
                        subpartition.setLOBDescriptors(lobDescriptors.toArray(new LOBDescriptor[lobDescriptors.size()]));
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)this.val$table, sqe);
                }
            }
        };
        wrap.executeQuery(r);
        return subpartitionMap;
    }

    private Map<String, List<LOBDescriptor>> getPartitionLevelSubpartitionLOBs(T table) throws DBException {
        final HashMap<String, List<LOBDescriptor>> lobDescriptorsMap = new HashMap<String, List<LOBDescriptor>>();
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITION_LOBS_QUERY*/\n       LS.COLUMN_NAME\n,      LS.SUBPARTITION_NAME NAME\n,      LS.LOB_SUBPARTITION_NAME LOB_SEGMENT_NAME\n,      LS.CHUNK\n,      LS.PCTVERSION\n,      LS.CACHE\n,      LS.IN_ROW\n,      LS.TABLESPACE_NAME\n,      LS.LOGGING\n,      LS.BUFFER_POOL\n,      LS.INITIAL_EXTENT\n,      LS.NEXT_EXTENT\n,      LS.MIN_EXTENTS\n,      LS.MAX_EXTENTS\n,      LS.PCT_INCREASE\n,      LS.FREELISTS\n,      LS.FREELIST_GROUPS\nfrom   ALL_LOB_SUBPARTITIONS LS\n,      ALL_LOBS L\nwhere  LS.TABLE_OWNER = :1\nand    LS.TABLE_NAME  = :2\nand    LS.TABLE_OWNER = L.OWNER\nand    LS.TABLE_NAME = L.TABLE_NAME\nand    LS.COLUMN_NAME = L.COLUMN_NAME\norder by LS.SUBPARTITION_NAME", table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    ArrayList<LOBDescriptor> lobDescriptors = null;
                    while (rs.next()) {
                        String subpartitionName = rs.getString("SUBPARTITION_NAME");
                        if (!lobDescriptorsMap.containsKey(subpartitionName)) {
                            lobDescriptors = new ArrayList<LOBDescriptor>();
                            lobDescriptorsMap.put(subpartitionName, lobDescriptors);
                        }
                        LOBDescriptor lob = new LOBDescriptor();
                        lobDescriptors.add(lob);
                        lob.addColumn(this.val$table.getColumn(rs.getString("COLUMN_NAME")).getID());
                        lob.setLOBSegName(rs.getString("LOB_SUBPARTITION_NAME"));
                        OracleTableBuilder.this.addTablespace(lob, rs.getString("TABLESPACE_NAME"));
                    }
                }
                catch (SQLException sqe) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, sqe);
                }
            }
        };
        wrap.executeQuery(r);
        return lobDescriptorsMap;
    }

    private void addTablespace(TablePartition partition, String tablespaceName) {
        OracleStorageProperties segmentAttributes = this.getSegmentAttributes(partition);
        segmentAttributes.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)this.getDatabase(), tablespaceName));
    }

    private void addTablespace(LOBDescriptor descriptor, String tablespaceName) {
        OracleStorageProperties storage = descriptor.getStorage();
        if (storage == null) {
            storage = new OracleStorageProperties();
            descriptor.setStorage(storage);
        }
        storage.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)this.getDatabase(), tablespaceName));
    }

    private OracleStorageProperties getSegmentAttributes(TablePartition partition) {
        OracleStorageProperties segmentAttributes = partition.getSegmentAttributes();
        if (segmentAttributes == null) {
            segmentAttributes = new OracleStorageProperties();
            partition.setSegmentAttributes(segmentAttributes);
        }
        return segmentAttributes;
    }

    private OracleIndexOrganizedTableProperties getIotProperties(T table) throws DBException {
        OracleIndexOrganizedTableProperties properties = new OracleIndexOrganizedTableProperties();
        properties.setID((DBObjectID)new NameBasedID((DBObject)properties, table.getID()));
        this.populateIotPropsFromAllIndexes(table, properties);
        this.populateIotPropsFromAllTables(table, properties);
        return properties;
    }

    private void populateIotPropsFromAllIndexes(T table, final OracleIndexOrganizedTableProperties properties) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper(OracleDictionaryQueries.TABLE_IOT_INDEX_QUERY, table.getSchema(), this.getQueryObject(table));
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        int pctThreshold = rs.getInt(1);
                        properties.setPctThreshold(rs.wasNull() ? null : new Integer(pctThreshold));
                        int compression = rs.getInt(2);
                        properties.setKeyCompression(rs.wasNull() ? null : new Integer(compression));
                        int includeColumnId = rs.getInt(3);
                        Column includeColumn = null;
                        if (!rs.wasNull()) {
                            Column[] columns = this.val$table.getColumns();
                            Column column = includeColumn = includeColumnId > 0 && includeColumnId <= columns.length ? columns[includeColumnId - 1] : null;
                        }
                        if (includeColumn != null) {
                            properties.setIncludeColumn(includeColumn.getID());
                        }
                    }
                }
                catch (SQLException sqe) {
                    this.val$wrap.throwDBException(sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private void populateIotPropsFromAllTables(T table, final OracleIndexOrganizedTableProperties properties) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper(OracleDictionaryQueries.TABLE_IOT_MAPPING_AND_OVERFLOW_QUERY, table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table, wrap){
            final /* synthetic */ Table val$table;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$table = table;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        if (rs.getString("IOT_TYPE").equals("IOT_OVERFLOW")) {
                            properties.setOverflowable(true);
                            if (Boolean.TRUE.equals(this.val$table.getProperty("PARTITIONED TABLE"))) {
                                String overflowTableName = rs.getString("TABLE_NAME");
                                properties.setOverflowProperties(OracleTableBuilder.this.getSegmentAttributeProperties("select /*OracleDictionaryQueries.ALL_PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, def_pct_used PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   all_part_tables\nwhere  owner = ?\nand    table_name = ?\n", this.val$table, overflowTableName));
                                continue;
                            }
                            properties.setOverflowProperties(OracleTableBuilder.getSegmentAttributeProperties(rs, OracleTableBuilder.this.getDatabase()));
                            continue;
                        }
                        properties.setMapped(true);
                    }
                }
                catch (SQLException x) {
                    this.val$wrap.throwDBException((DBObject)this.val$table, x);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private OracleExternalTableProperties getExternalTableProperties(T table) throws DBException {
        final Holder holder = new Holder();
        BaseOracleDatabase db = this.getDatabase();
        int dbType = db.getDatabaseVersion();
        String query = OracleTableBuilder.getExternalTableQuery(dbType);
        if (query != null) {
            final QueryWrapper wrap = this.newQueryWrapper(query, table.getSchema(), table);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table){
                final /* synthetic */ Table val$table;
                {
                    this.val$table = table;
                }

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            String pc;
                            OracleExternalTableProperties properties = new OracleExternalTableProperties();
                            properties.setAccessDriverType(rs.getString(1));
                            properties.setRejectLimit(rs.getString(2));
                            if (rs.getString(4) != null) {
                                properties.setAccessParameters((Object)rs.getString(4).trim());
                            }
                            if ((pc = rs.getString(5)) != null && !pc.equals("null")) {
                                properties.setProjectColumn(OracleExternalTableProperties.ProjectColumn.valueOf((String)pc));
                            }
                            properties.setDefaultDirectory(OracleTableBuilder.this.getDirectory(rs.getString(6), rs.getString(7)));
                            holder.set((Object)properties);
                        }
                    }
                    catch (SQLException sqe) {
                        wrap.throwDBException((DBObject)this.val$table, sqe);
                    }
                }
            };
            wrap.executeQuery(r);
            OracleExternalTableProperties properties = (OracleExternalTableProperties)holder.get();
            if (properties != null) {
                this.populateLocAndDir(table, properties);
            }
        }
        return (OracleExternalTableProperties)holder.get();
    }

    private void populateLocAndDir(T table, final OracleExternalTableProperties properties) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_TABLE_EXT_LOCATIONS_QUERY*/\n       LOCATION, DIRECTORY_OWNER, DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_LOCATIONS \nwhere  OWNER = ?\nand    TABLE_NAME = ?\n", table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Table)table){
            final /* synthetic */ Table val$table;
            {
                this.val$table = table;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        properties.addLocationSpecifier(OracleTableBuilder.this.getDirectory(rs.getString(2), rs.getString(3)), rs.getString(1));
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)this.val$table, sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private DBObjectID getDirectory(String owner, String name) {
        if (ModelUtil.hasLength((String)name)) {
            return new ReferenceID("DIRECTORY", owner, name);
        }
        return null;
    }

    private String getTableTypeQuery() {
        String query = null;
        switch (this.getDatabase().getDatabaseVersion()) {
            case 0: 
            case 1: {
                break;
            }
            case 81: 
            case 82: {
                query = "SELECT /*OracleDictionaryQueries.TABLE_TYPE_ORACLE8_QUERY(SYS.ALL_TABLES)*/\n 'N' TEMPORARY, null DURATION, IOT_TYPE, PARTITIONED, NESTED, null EXTERNAL_TAB\nFROM SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            default: {
                query = "SELECT /*OracleDictionaryQueries.TABLE_TYPE_QUERY(SYS.ALL_TABLES)*/\n A.TEMPORARY, A.DURATION, A.IOT_TYPE, A.PARTITIONED, A.NESTED,\n ( SELECT 1 FROM SYS.ALL_EXTERNAL_TABLES E    WHERE E.OWNER = A.OWNER AND E.TABLE_NAME = A.TABLE_NAME ) EXTERNAL_TAB\nFROM SYS.ALL_TABLES A \nWHERE A.OWNER = ? AND A.TABLE_NAME = ?";
            }
        }
        return query;
    }

    private static String getExternalTableQuery(int databaseType) {
        switch (databaseType) {
            case 0: 
            case 1: 
            case 81: 
            case 82: {
                return null;
            }
            case 91: 
            case 92: {
                return "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_ORACLE9i_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, null, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n";
            }
        }
        return "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, PROPERTY, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n";
    }

    protected String getTableQuery() {
        String query = null;
        switch (this.getDatabase().getDatabaseVersion()) {
            case 1: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_OLITE_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING,\n       null BUFFER_POOL, null COMPRESSION, null DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            case 0: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE7_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, null LOGGING, null BUFFER_POOL, null COMPRESSION, 1 DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            case 81: 
            case 82: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE8_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, null COMPRESSION, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            case 91: 
            case 92: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE9_QUERY(ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, null COMPRESSION, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            default: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
            }
        }
        return query;
    }

    private String convertToObjectQuery(String query) {
        String retval = null;
        if (this.getDatabase().getDatabaseVersion() > 81) {
            Pattern p1 = Pattern.compile("ALL_TABLES", 2);
            retval = p1.matcher(query).replaceAll("ALL_OBJECT_TABLES");
        }
        return retval;
    }

    private static String getLobParametersQuery(int databaseType) {
        return databaseType > 82 ? "SELECT /*OracleDictionaryQueries.ALL_TABLE_LOB_PARMATERS_QUERY*/ \n       AL.COLUMN_NAME\n,      AL.SEGMENT_NAME\n,      AL.PCTVERSION\n,      AL.IN_ROW\n,      AL.CHUNK\n,      AL.FREEPOOLS\n,      AL.RETENTION\n,      PS.TABLESPACE_NAME\n,      AL.CACHE\n,      AL.LOGGING\n,      PS.INITIAL_EXTENT\n,      PS.NEXT_EXTENT\n,      PS.MIN_EXTENTS\n,      PS.MAX_EXTENTS\n,      PS.PCT_INCREASE\n,      PS.FREELISTS\n,      PS.FREELIST_GROUPS\n,      PS.BUFFER_POOL\nFROM   ALL_LOBS AL\n,      ALL_TABLES T\n,     (SELECT US.SEGMENT_NAME\n       ,      US.TABLESPACE_NAME\n       ,      US.INITIAL_EXTENT\n       ,      US.NEXT_EXTENT\n       ,      US.MIN_EXTENTS\n       ,      US.MAX_EXTENTS\n       ,      US.PCT_INCREASE\n       ,      US.FREELISTS\n       ,      US.FREELIST_GROUPS\n       ,      US.BUFFER_POOL\n       ,      US.PARTITION_NAME\n       FROM   USER_SEGMENTS US\n       ,      USER_LOBS UL\n       WHERE  US.SEGMENT_NAME = UL.SEGMENT_NAME\n       AND    US.PARTITION_NAME IS NULL\n       AND    US.SEGMENT_TYPE = 'LOBSEGMENT'\n       AND    USER = ?\n       AND    UL.TABLE_NAME = ?\n      ) PS\nWHERE AL.OWNER = ?\nAND   AL.TABLE_NAME = ?\nAND   AL.OWNER = T.OWNER\nAND   AL.TABLE_NAME = T.TABLE_NAME\nAND   T.PARTITIONED = 'NO'\nAND   AL.SEGMENT_NAME = PS.SEGMENT_NAME (+)" : "SELECT /*OracleDictionaryQueries.ALL_TABLE_LOB_PARMATERS_QUERY*/ \n       AL.COLUMN_NAME\n,      AL.SEGMENT_NAME\n,      AL.PCTVERSION\n,      AL.IN_ROW\n,      AL.CHUNK\n,      AL.FREEPOOLS\n,      AL.RETENTION\n,      PS.TABLESPACE_NAME\n,      AL.CACHE\n,      AL.LOGGING\n,      PS.INITIAL_EXTENT\n,      PS.NEXT_EXTENT\n,      PS.MIN_EXTENTS\n,      PS.MAX_EXTENTS\n,      PS.PCT_INCREASE\n,      PS.FREELISTS\n,      PS.FREELIST_GROUPS\n,      PS.BUFFER_POOL\nFROM   ALL_LOBS AL\n,      ALL_TABLES T\n,     (SELECT US.SEGMENT_NAME\n       ,      US.TABLESPACE_NAME\n       ,      US.INITIAL_EXTENT\n       ,      US.NEXT_EXTENT\n       ,      US.MIN_EXTENTS\n       ,      US.MAX_EXTENTS\n       ,      US.PCT_INCREASE\n       ,      US.FREELISTS\n       ,      US.FREELIST_GROUPS\n       ,      US.BUFFER_POOL\n       ,      US.PARTITION_NAME\n       FROM   USER_SEGMENTS US\n       ,      USER_LOBS UL\n       WHERE  US.SEGMENT_NAME = UL.SEGMENT_NAME\n       AND    US.PARTITION_NAME IS NULL\n       AND    US.SEGMENT_TYPE = 'LOBSEGMENT'\n       AND    USER = ?\n       AND    UL.TABLE_NAME = ?\n      ) PS\nWHERE AL.OWNER = ?\nAND   AL.TABLE_NAME = ?\nAND   AL.OWNER = T.OWNER\nAND   AL.TABLE_NAME = T.TABLE_NAME\nAND   T.PARTITIONED = 'NO'\nAND   AL.SEGMENT_NAME = PS.SEGMENT_NAME (+)".replaceFirst("AL.FREEPOOLS", "null FREEPOOLS").replaceFirst("AL.RETENTION", "null RETENTION");
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

