/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OracleRelationBuilder<T extends Relation>
extends OracleDBObjectBuilder<T> {
    private static final String ORACLE8i_NOT_NULL_COND = "\"{0}\" IS NOT NULL";
    private static final String ORACLE7_NOT_NULL_COND = "{0} IS NOT NULL";
    private static final char PK_TYPE = 'P';
    private static final char FK_TYPE = 'R';
    private static final char UNIQUE_TYPE = 'U';
    private static final char CHECK_TYPE = 'C';

    protected OracleRelationBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"Comment"})
    public void fillInComment(T rel) throws DBException {
        QueryWrapper wrap = rel instanceof MaterializedView && this.getProvider() instanceof Oracle10g ? this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_MVIEW_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_MVIEW_COMMENTS WHERE OWNER = ? AND MVIEW_NAME = ?", rel.getSchema(), rel) : (rel instanceof MaterializedView ? this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_TABLE_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?", rel.getSchema(), rel, "TABLE") : this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_TABLE_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?", rel.getSchema(), rel, this.getObjectType()));
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Relation)rel, wrap){
            final /* synthetic */ Relation val$rel;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$rel = relation;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        String com = rs.getString(1);
                        com = ModelUtil.hasLength((String)com) ? com : null;
                        this.val$rel.setProperty("Comment", (Object)com);
                    }
                }
                catch (SQLException ex) {
                    this.val$wrap.throwDBException((DBObject)this.val$rel, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
    public void fillInColumns(T relation) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        int databaseType = db.getDatabaseVersion();
        String query = OracleRelationBuilder.getColumnQuery(databaseType);
        relation.setColumns(new Column[0]);
        HashMap<Column, String> complexCols = new HashMap<Column, String>();
        QueryWrapper wrap = this.newQueryWrapper(query, relation.getSchema(), relation);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Relation)relation, complexCols, db, wrap){
            final /* synthetic */ Relation val$relation;
            final /* synthetic */ Map val$complexCols;
            final /* synthetic */ BaseOracleDatabase val$db;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$relation = relation;
                this.val$complexCols = map;
                this.val$db = baseOracleDatabase;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String colName = rs.getString(1);
                        Column col = new Column(colName);
                        this.val$relation.addColumn(col);
                        String typeName = rs.getString(2);
                        String typeOwner = rs.getString(3);
                        if (!rs.wasNull()) {
                            typeName = typeOwner + "." + typeName;
                        }
                        col.setNotNull(rs.getString(7).equals("N"));
                        String defValue = rs.getString(10);
                        if (null != defValue) {
                            defValue = defValue.trim();
                        }
                        col.setDefault((Object)defValue);
                        String cmt = rs.getString(11);
                        col.setProperty("Comment", (Object)cmt);
                        col.setID((DBObjectID)new NameBasedID((DBObject)col, this.val$relation.getID()));
                        if (typeName != null && typeName.indexOf(46) >= 0) {
                            this.val$complexCols.put(col, typeName);
                            continue;
                        }
                        DataType dataType = this.val$db.getOrCreateDataType(typeName);
                        if (dataType == null) continue;
                        long length = rs.getLong(5);
                        Long precision = rs.wasNull() ? null : new Long(length);
                        length = OracleRelationBuilder.this.isCharType(typeName) ? rs.getLong(9) : rs.getLong(4);
                        Long size = rs.wasNull() ? null : new Long(length);
                        Long scale = new Long(rs.getLong(6));
                        scale = rs.wasNull() ? null : scale;
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        attributes.put("name", typeName);
                        attributes.put("size", DataTypeHelper.getAttributeValue((Object)size, (DataType)dataType, (String)"size"));
                        attributes.put("precision", DataTypeHelper.getAttributeValue((Object)precision, (DataType)dataType, (String)"precision"));
                        attributes.put("scale", DataTypeHelper.getAttributeValue((Object)scale, (DataType)dataType, (String)"scale"));
                        attributes.put("unit", rs.getString(12));
                        col.setDataTypeUsage(dataType.createUsage(attributes));
                    }
                }
                catch (SQLException ex) {
                    this.val$wrap.throwDBException((DBObject)this.val$relation, ex);
                }
            }
        };
        wrap.executeQuery(100, r);
        if (complexCols.size() > 0) {
            this.populateComplexColumnTypes(relation, complexCols);
        }
    }

    private void populateComplexColumnTypes(T relation, Map<Column, String> complexCols) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        for (Map.Entry<Column, String> entry : complexCols.entrySet()) {
            final Column col = entry.getKey();
            String typeName = entry.getValue();
            DataType dataType = null;
            try {
                int split = typeName.indexOf(46);
                String schemaName = typeName.substring(0, split);
                String objName = typeName.substring(split + 1, typeName.length());
                dataType = (ComplexType)db.getObject("TYPE", new Schema(schemaName), objName);
                if (dataType == null) {
                    DBObject o;
                    Synonym s = (Synonym)db.getObject("SYNONYM", new Schema(schemaName), objName);
                    if (s == null) {
                        s = (Synonym)db.getObject("SYNONYM", new Schema("PUBLIC"), objName);
                    }
                    if (s != null && s.getReference() != null && (o = s.getReference().resolveID()) instanceof DataType) {
                        dataType = (DataType)o;
                    }
                }
            }
            catch (DBException dbe) {
                DBLog.logStackTrace((Throwable)dbe);
            }
            if (dataType == null) {
                dataType = db.getOrCreateDataType(typeName);
            }
            dataType.getProperty("test");
            HashMap attributes = new HashMap();
            if (dataType instanceof ComplexType && ((ComplexType)dataType).getCollectionType().equals("TABLE")) {
                final QueryWrapper cuWrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_COLUMN_NESTED_TAB_QUERY*/\n       ANT.TABLE_NAME NESTED_TABLE \n,      TRIM(ANT.RETURN_TYPE) \nFROM   ALL_NESTED_TABLES ANT \nWHERE  ANT.OWNER = ? \nAND    ANT.PARENT_TABLE_NAME = ? \nAND    ANT.PARENT_TABLE_COLUMN = ? \n", relation.getSchema(), relation, col);
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet curs) throws DBException {
                        try {
                            if (curs.next()) {
                                OracleColumnProperties ocp = new OracleColumnProperties();
                                OracleNestedTableProperties ntp = new OracleNestedTableProperties();
                                ntp.setTableName(curs.getString(1));
                                ntp.setReturnAs(curs.getString(2));
                                ocp.setNestedTableProperties(ntp);
                                col.setProperty("OracleColumnProperties", (Object)ocp);
                            }
                        }
                        catch (SQLException e) {
                            cuWrap.throwDBException(e);
                        }
                    }
                };
                cuWrap.executeQuery(r);
            }
            col.setDataTypeUsage(dataType.createUsage(attributes));
        }
    }

    private boolean isCharType(String typeName) {
        return typeName.equals("CHAR") || typeName.equals("NCHAR") || typeName.equals("VARCHAR2") || typeName.equals("NVARCHAR2");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"constraints"}, depends={"columns"})
    public void fillInConstraints(T relation) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        String query = OracleRelationBuilder.getConstraintQuery(db.getDatabaseVersion());
        if (DBUtil.getNameComparator().compare(db.getDefaultSchema(), relation.getSchema()) != 0) {
            Pattern p1 = Pattern.compile("USER_CONSTRAINTS", 2);
            query = p1.matcher(query).replaceAll("ALL_CONSTRAINTS");
            Pattern p2 = Pattern.compile("USER_CONS_COLUMNS", 2);
            query = p2.matcher(query).replaceAll("ALL_CONS_COLUMNS");
        }
        QueryWrapper wrap = this.newQueryWrapper(query, relation.getSchema(), relation);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Relation)relation, wrap){
            final /* synthetic */ Relation val$relation;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$relation = relation;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    HashMap<String, ConstraintData> data = new HashMap<String, ConstraintData>();
                    while (rs.next()) {
                        String colName;
                        String conName = rs.getString(1);
                        ConstraintData con = (ConstraintData)data.get(conName);
                        if (con == null) {
                            con = new ConstraintData(conName, rs);
                            data.put(conName, con);
                        }
                        if (con.isInvisibleFK()) {
                            con.m_ignore = true;
                        }
                        if ((colName = rs.getString(9)) == null) continue;
                        if (colName.startsWith("SYS_NC")) {
                            con.m_ignore = true;
                            continue;
                        }
                        if (DBUtil.isCompoundName((String)colName, (String)OracleRelationBuilder.this.getDatabase().getIdentifierQuoteString())) {
                            DBLog.getLogger().warning("Constraint " + this.val$relation.getName() + "." + conName + " ignored;" + " compound column name " + colName + " not supported.");
                            con.m_ignore = true;
                            continue;
                        }
                        if (rs.wasNull()) continue;
                        con.addColumn(colName);
                    }
                    ArrayList<Constraint> cons = new ArrayList<Constraint>(data.size());
                    for (ConstraintData cd : data.values()) {
                        Constraint con;
                        if (cd.m_ignore || (con = cd.createConstraint(this.val$relation)) == null) continue;
                        cons.add(con);
                    }
                    this.val$relation.setConstraints(cons.toArray(new Constraint[cons.size()]));
                }
                catch (SQLException ex) {
                    this.val$wrap.throwDBException((DBObject)this.val$relation, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private static int _translateDeleteAction(String action) {
        int result = 0;
        if ("CASCADE".equals(action)) {
            result = 1;
        } else if ("SET NULL".equals(action)) {
            result = 2;
        }
        return result;
    }

    private static String getColumnQuery(int type) {
        String query = null;
        switch (type) {
            case 1: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_OLITE_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER(+) \nAND   C.TABLE_NAME = CMT.TABLE_NAME(+) \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME(+) \nORDER BY COLUMN_ID \n";
                break;
            }
            case 0: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE7_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null,        DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE,        DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null FROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
                break;
            }
            case 81: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
                break;
            }
            case 82: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8i_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, CHAR_COL_DECL_LENGTH, DATA_DEFAULT, COMMENTS, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
                break;
            }
            default: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, CHAR_LENGTH, DATA_DEFAULT, COMMENTS \n    , decode(CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID\n";
            }
        }
        return query;
    }

    private static String getConstraintQuery(int type) {
        return type == 1 ? "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_OLITE_QUERY*/\n        A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER, \n        A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, 'GENERATED NAME' GENERATED, \n        B.COLUMN_NAME,  \n        ( SELECT D.CONSTRAINT_TYPE  \n          FROM SYS.ALL_CONSTRAINTS D  \n          WHERE D.OWNER = A.R_OWNER  \n          AND   D.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME  ) ref_constraint_type, \n        null                                               ref_relation_object_id, \n        ( SELECT 'TABLE' \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_TABLES      BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.TABLE_NAME \n         UNION\n          SELECT 'VIEW' \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_VIEWS       BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.VIEW_NAME           ) ref_relation_type,\n        ( SELECT AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_TABLES     BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.TABLE_NAME \n         UNION\n          SELECT AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_VIEWS       BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.VIEW_NAME           ) ref_relation_name\nFROM SYS.ALL_CONSTRAINTS  A,  \n     SYS.ALL_CONS_COLUMNS B  \nWHERE A.OWNER           = ?  \nAND   A.TABLE_NAME      = ?  \nAND   A.OWNER           = B.OWNER  \nAND   A.CONSTRAINT_NAME = B.CONSTRAINT_NAME  \nORDER BY B.POSITION \n" : "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_ENTERPRISE_QUERY*/\n        CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER,  \n       A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED, B.COLUMN_NAME, \n       ( SELECT D.CONSTRAINT_TYPE \n         FROM  SYS.ALL_CONSTRAINTS D \n         WHERE D.OWNER = A.R_OWNER \n         AND   D.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ref_constraint_type, \n       ( SELECT D.TABLE_NAME \n         FROM  SYS.ALL_CONSTRAINTS D \n         WHERE D.OWNER = A.R_OWNER \n         AND   D.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ref_relation_name, \n       ( SELECT (SELECT BB.OBJECT_ID \n                 FROM SYS.ALL_OBJECTS BB \n                 WHERE AA.OWNER = BB.OWNER \n                 AND   AA.TABLE_NAME = BB.OBJECT_NAME \n                 AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n         FROM SYS.ALL_CONSTRAINTS AA \n         WHERE AA.OWNER = A.R_OWNER \n         AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ref_relation_object_id, \n       ( SELECT (SELECT BB.OBJECT_TYPE \n                 FROM SYS.ALL_OBJECTS BB \n                 WHERE AA.OWNER = BB.OWNER \n                 AND   AA.TABLE_NAME = BB.OBJECT_NAME \n                 AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n         FROM SYS.ALL_CONSTRAINTS AA \n         WHERE AA.OWNER = A.R_OWNER \n         AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME)  ref_relation_type \nFROM SYS.USER_CONSTRAINTS  A LEFT OUTER JOIN \n     SYS.USER_CONS_COLUMNS B USING ( OWNER, CONSTRAINT_NAME ) \nWHERE   OWNER           = ? \nAND     A.TABLE_NAME      = ? \nORDER BY B.POSITION  \n";
    }

    private static String getNotNullText(int type) {
        String query = null;
        switch (type) {
            case 0: 
            case 1: 
            case 81: {
                query = ORACLE7_NOT_NULL_COND;
                break;
            }
            default: {
                query = ORACLE8i_NOT_NULL_COND;
            }
        }
        return query;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstraintData {
        private String m_cName;
        private char m_cType;
        private String m_cond;
        private String m_rSchemaName;
        private String m_rConstraintName;
        private String m_rRelationType;
        private String m_rRelationName;
        private Object m_rRelationObjectID;
        private int m_dRule;
        private boolean m_status;
        private boolean m_generated;
        private List<String> m_cols = new ArrayList<String>();
        private boolean m_ignore = false;

        ConstraintData(String name, ResultSet rs) throws SQLException {
            this.m_cName = name;
            String cType = rs.getString("CONSTRAINT_TYPE");
            this.m_cType = ModelUtil.hasLength((String)cType) ? cType.charAt(0) : (char)'\u0000';
            switch (this.m_cType) {
                case 'C': {
                    this.m_cond = rs.getString("SEARCH_CONDITION");
                    break;
                }
                case 'P': 
                case 'U': {
                    break;
                }
                case 'R': {
                    this.m_rSchemaName = rs.getString("R_OWNER");
                    this.m_rConstraintName = rs.getString("R_CONSTRAINT_NAME");
                    this.m_rRelationObjectID = rs.getObject("ref_relation_object_id");
                    this.m_rRelationType = rs.getString("ref_relation_type");
                    this.m_rRelationName = rs.getString("ref_relation_name");
                    this.m_dRule = OracleRelationBuilder._translateDeleteAction(rs.getString("DELETE_RULE"));
                    break;
                }
                default: {
                    this.m_cType = '\u0000';
                }
            }
            String enabled = rs.getString("STATUS");
            this.m_status = "ENABLED".equals(enabled);
            String generated = rs.getString("GENERATED");
            this.m_generated = "GENERATED NAME".equals(generated);
        }

        private boolean isInvisibleFK() {
            return this.m_cType == 'R' && !this.isVisibleFK();
        }

        private boolean isVisibleFK() {
            return this.m_rSchemaName != null && this.m_rRelationName != null && this.m_rRelationType != null;
        }

        private void addColumn(String cName) {
            this.m_cols.add(cName);
        }

        private Constraint createConstraint(T relation) throws SQLException, DBException {
            CheckConstraint con = null;
            switch (this.m_cType) {
                case 'C': {
                    con = this.createCheckConstraint(relation);
                    break;
                }
                case 'P': 
                case 'U': {
                    con = this.createUniqueConstraint(relation);
                    break;
                }
                case 'R': {
                    con = this.createFK(relation);
                    break;
                }
                default: {
                    con = null;
                }
            }
            if (con != null) {
                BaseOracleDatabase db = OracleRelationBuilder.this.getDatabase();
                con.setID((DBObjectID)new NameBasedID((DBObject)con, relation.getID()));
                con.setEnabled(this.m_status);
            }
            return con;
        }

        private CheckConstraint createCheckConstraint(T relation) {
            String colName;
            Column col;
            if (this.m_cond == null) {
                return null;
            }
            this.m_cond = this.m_cond.trim();
            if (this.m_generated && this.m_cols.size() == 1 && (col = relation.getColumn(colName = this.m_cols.get(0))) != null && col.isNotNull() && MessageFormat.format(OracleRelationBuilder.getNotNullText(OracleRelationBuilder.this.getDatabase().getDatabaseVersion()), colName).equals(this.m_cond)) {
                return null;
            }
            CheckConstraint con = new CheckConstraint(this.m_cName, relation);
            con.setCheckConditionFragment(SQLFragmentExpressionBuilder.getExpression((DBObjectProvider)OracleRelationBuilder.this.getProvider(), relation, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.CONDITION, (String)this.m_cond));
            return con;
        }

        private void setConstraintColumns(ColumnConstraint con, T relation) {
            DBObjectID relID = relation.getID();
            if (relID == null) {
                String[] colNames = this.m_cols.toArray(new String[this.m_cols.size()]);
                int count = 0;
                Column[] cols = new Column[colNames.length];
                for (int i = 0; i < colNames.length; ++i) {
                    Column col = relation.getColumn(colNames[i]);
                    if (col == null) continue;
                    cols[count++] = col;
                }
                if (count < cols.length) {
                    Column[] tmp = cols;
                    cols = new Column[count];
                    System.arraycopy(tmp, 0, cols, 0, count);
                }
                con.setColumns(cols);
            } else {
                DBObjectID[] ids = new DBObjectID[this.m_cols.size()];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = new NameBasedID("COLUMN", this.m_cols.get(i), relID);
                }
                con.setColumnIDs(ids);
            }
        }

        private UniqueConstraint createUniqueConstraint(T relation) {
            PKConstraint con = this.m_cType == 'P' ? new PKConstraint(this.m_cName, relation) : new UniqueConstraint(this.m_cName, relation);
            this.setConstraintColumns((ColumnConstraint)con, relation);
            return con;
        }

        private FKConstraint createFK(T relation) throws SQLException, DBException {
            FKConstraint fk = new FKConstraint(this.m_cName, relation);
            this.setConstraintColumns((ColumnConstraint)fk, relation);
            fk.setDeleteMode(this.m_dRule);
            if (this.isVisibleFK()) {
                Schema refSchema = OracleRelationBuilder.this.getSchema(this.m_rSchemaName);
                DBObjectID refRelationID = OracleRelationBuilder.this.getDatabase().createID(refSchema, this.m_rRelationName, this.m_rRelationType, this.m_rRelationObjectID);
                NameBasedID refConstraintID = new NameBasedID("CONSTRAINT", this.m_rConstraintName, refRelationID);
                fk.setReferenceID((DBObjectID)refConstraintID);
            }
            return fk;
        }
    }
}

